/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import java.util.function.Consumer;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.SVGContainer;
import org.jackhuang.hmcl.ui.animation.Motion;
import org.jackhuang.hmcl.ui.construct.AdvancedListItem;
import org.jackhuang.hmcl.ui.construct.ClassTitle;
import org.jackhuang.hmcl.ui.construct.TabControl;
import org.jackhuang.hmcl.ui.construct.TabHeader;

public class AdvancedListBox
extends ScrollPane {
    private final VBox container = new VBox();

    public AdvancedListBox() {
        this.setContent((Node)this.container);
        FXUtils.smoothScrolling(this);
        this.setFitToHeight(true);
        this.setFitToWidth(true);
        this.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.setVbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.container.getStyleClass().add((Object)"advanced-list-box-content");
        this.addEventFilter(MouseEvent.MOUSE_ENTERED, event -> {
            if (this.container.getHeight() > this.getHeight()) {
                this.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
            }
        });
        this.addEventFilter(MouseEvent.MOUSE_EXITED, event -> this.setVbarPolicy(ScrollPane.ScrollBarPolicy.NEVER));
    }

    public AdvancedListBox add(Node child) {
        if (child instanceof Pane || child instanceof AdvancedListItem) {
            this.container.getChildren().add((Object)child);
        } else {
            StackPane pane = new StackPane();
            pane.getStyleClass().add((Object)"advanced-list-box-item");
            pane.getChildren().setAll((Object[])new Node[]{child});
            this.container.getChildren().add((Object)pane);
        }
        return this;
    }

    private AdvancedListItem createNavigationDrawerItem(String title, SVG leftGraphic) {
        AdvancedListItem item = new AdvancedListItem();
        item.getStyleClass().add((Object)"navigation-drawer-item");
        item.setTitle(title);
        if (leftGraphic != null) {
            item.setLeftIcon(leftGraphic);
        }
        return item;
    }

    public AdvancedListBox addNavigationDrawerItem(String title, SVG leftGraphic, Runnable onAction) {
        return this.addNavigationDrawerItem(title, leftGraphic, onAction, null);
    }

    public AdvancedListBox addNavigationDrawerItem(String title, SVG leftGraphic, Runnable onAction, Consumer<AdvancedListItem> initializer) {
        AdvancedListItem item = this.createNavigationDrawerItem(title, leftGraphic);
        if (onAction != null) {
            item.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> onAction.run()));
        }
        if (initializer != null) {
            initializer.accept(item);
        }
        return this.add((Node)item);
    }

    public AdvancedListBox addNavigationDrawerTab(TabHeader tabHeader, TabControl.Tab<?> tab, String title, SVG leftGraphic) {
        AdvancedListItem item = this.createNavigationDrawerItem(title, leftGraphic);
        item.activeProperty().bind((ObservableValue)tabHeader.getSelectionModel().selectedItemProperty().isEqualTo(tab));
        item.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> tabHeader.select(tab)));
        return this.add((Node)item);
    }

    public AdvancedListBox addNavigationDrawerTab(TabHeader tabHeader, TabControl.Tab<?> tab, String title, SVG unselectedGraphic, SVG selectedGraphic) {
        AdvancedListItem item = this.createNavigationDrawerItem(title, null);
        item.activeProperty().bind((ObservableValue)tabHeader.getSelectionModel().selectedItemProperty().isEqualTo(tab));
        item.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> tabHeader.select(tab)));
        SVGContainer leftGraphic = new SVGContainer(item.isActive() ? selectedGraphic : unselectedGraphic, 20.0);
        leftGraphic.setMouseTransparent(true);
        AdvancedListItem.setAlignment((Node)leftGraphic, Pos.CENTER);
        AdvancedListItem.setMargin((Node)leftGraphic, AdvancedListItem.LEFT_ICON_MARGIN);
        FXUtils.onChange(item.activeProperty(), active -> leftGraphic.setIcon(active != false ? selectedGraphic : unselectedGraphic, Motion.SHORT4));
        item.setLeftGraphic((Node)leftGraphic);
        return this.add((Node)item);
    }

    public AdvancedListBox add(int index, Node child) {
        if (child instanceof Pane || child instanceof AdvancedListItem) {
            this.container.getChildren().add(index, (Object)child);
        } else {
            StackPane pane = new StackPane();
            pane.getStyleClass().add((Object)"advanced-list-box-item");
            pane.getChildren().setAll((Object[])new Node[]{child});
            this.container.getChildren().add(index, (Object)pane);
        }
        return this;
    }

    public AdvancedListBox remove(Node child) {
        this.container.getChildren().remove(this.indexOf(child));
        return this;
    }

    public int indexOf(Node child) {
        if (child instanceof Pane) {
            return this.container.getChildren().indexOf((Object)child);
        }
        for (int i = 0; i < this.container.getChildren().size(); ++i) {
            ObservableList list;
            Node node = (Node)this.container.getChildren().get(i);
            if (!(node instanceof StackPane) || (list = ((StackPane)node).getChildren()).size() != 1 || list.get(0) != child) continue;
            return i;
        }
        return -1;
    }

    public AdvancedListBox startCategory(String category) {
        return this.add((Node)new ClassTitle(category));
    }

    public void setSpacing(double spacing) {
        this.container.setSpacing(spacing);
    }

    public void clear() {
        this.container.getChildren().clear();
    }
}

