/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.export;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXSlider;
import com.jfoenix.controls.JFXTextArea;
import com.jfoenix.controls.JFXTextField;
import com.jfoenix.validation.base.ValidatorBase;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TextInputControl;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import javafx.util.Callback;
import org.jackhuang.hmcl.auth.Account;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorServer;
import org.jackhuang.hmcl.game.HMCLGameRepository;
import org.jackhuang.hmcl.mod.ModpackExportInfo;
import org.jackhuang.hmcl.mod.mcbbs.McbbsModpackManifest;
import org.jackhuang.hmcl.setting.Accounts;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.setting.VersionSetting;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.HintPane;
import org.jackhuang.hmcl.ui.construct.LinePane;
import org.jackhuang.hmcl.ui.construct.LineSelectButton;
import org.jackhuang.hmcl.ui.construct.LineTextPane;
import org.jackhuang.hmcl.ui.construct.LineToggleButton;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.NumberValidator;
import org.jackhuang.hmcl.ui.construct.RequiredValidator;
import org.jackhuang.hmcl.ui.construct.URLValidator;
import org.jackhuang.hmcl.ui.export.ModpackTypeSelectionPage;
import org.jackhuang.hmcl.ui.wizard.WizardController;
import org.jackhuang.hmcl.ui.wizard.WizardPage;
import org.jackhuang.hmcl.util.DataSizeUnit;
import org.jackhuang.hmcl.util.SettingsMap;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.io.JarUtils;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.platform.SystemInfo;

public final class ModpackInfoPage
extends Control
implements WizardPage {
    private final WizardController controller;
    private final HMCLGameRepository gameRepository;
    private final ModpackExportInfo.Options options;
    private final String versionName;
    private final boolean canIncludeLauncher;
    private final ModpackExportInfo exportInfo = new ModpackExportInfo();
    private final SimpleStringProperty name = new SimpleStringProperty("");
    private final SimpleStringProperty author = new SimpleStringProperty("");
    private final SimpleStringProperty version = new SimpleStringProperty("1.0");
    private final SimpleStringProperty description = new SimpleStringProperty("");
    private final SimpleStringProperty url = new SimpleStringProperty("");
    private final SimpleBooleanProperty forceUpdate = new SimpleBooleanProperty();
    private final SimpleBooleanProperty packWithLauncher = new SimpleBooleanProperty();
    private final SimpleStringProperty fileApi = new SimpleStringProperty("");
    private final SimpleIntegerProperty minMemory = new SimpleIntegerProperty(0);
    private final SimpleStringProperty authlibInjectorServer = new SimpleStringProperty();
    private final SimpleStringProperty launchArguments = new SimpleStringProperty("");
    private final SimpleStringProperty javaArguments = new SimpleStringProperty("");
    private final SimpleStringProperty mcbbsThreadId = new SimpleStringProperty("");
    private final SimpleBooleanProperty noCreateRemoteFiles = new SimpleBooleanProperty();
    private final SimpleBooleanProperty skipCurseForgeRemoteFiles = new SimpleBooleanProperty();
    public static final SettingsMap.Key<ModpackExportInfo> MODPACK_INFO = new SettingsMap.Key("modpack.info");
    public static final SettingsMap.Key<Path> MODPACK_FILE = new SettingsMap.Key("modpack.file");
    public static final SettingsMap.Key<ModpackExportInfo.Options> MODPACK_INFO_OPTION = new SettingsMap.Key("modpack.info.option");

    public ModpackInfoPage(WizardController controller, HMCLGameRepository gameRepository, String version) {
        this.controller = controller;
        this.gameRepository = gameRepository;
        this.options = controller.getSettings().get(MODPACK_INFO_OPTION);
        this.versionName = version;
        if (this.options == null) {
            throw new IllegalArgumentException("Settings.MODPACK_INFO_OPTION is required");
        }
        this.name.set(version);
        this.author.set(Optional.ofNullable(Accounts.getSelectedAccount()).map(Account::getUsername).orElse(""));
        VersionSetting versionSetting = gameRepository.getVersionSetting(this.versionName);
        this.minMemory.set(Optional.ofNullable(versionSetting.getMinMemory()).orElse(0).intValue());
        this.launchArguments.set(versionSetting.getMinecraftArgs());
        this.javaArguments.set(versionSetting.getJavaArgs());
        this.canIncludeLauncher = JarUtils.thisJarPath() != null;
    }

    private void onNext() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(I18n.i18n("modpack.wizard.step.initialization.save"));
        if (!this.packWithLauncher.get() && this.controller.getSettings().get(ModpackTypeSelectionPage.MODPACK_TYPE) == "modrinth") {
            fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(I18n.i18n("modpack"), new String[]{"*.mrpack"}));
            fileChooser.setInitialFileName(this.name.get() + (OperatingSystem.CURRENT_OS == OperatingSystem.MACOS ? "" : ".mrpack"));
        } else {
            fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(I18n.i18n("modpack"), new String[]{"*.zip"}));
            fileChooser.setInitialFileName(this.name.get() + ".zip");
        }
        Path file = FileUtils.toPath(fileChooser.showSaveDialog((Window)Controllers.getStage()));
        if (file == null) {
            this.controller.onEnd();
            return;
        }
        this.exportInfo.setName(this.name.get());
        this.exportInfo.setFileApi(this.fileApi.get());
        this.exportInfo.setVersion(this.version.get());
        this.exportInfo.setAuthor(this.author.get());
        this.exportInfo.setDescription(this.description.get());
        this.exportInfo.setUrl(this.url.get());
        this.exportInfo.setForceUpdate(this.forceUpdate.get());
        this.exportInfo.setPackWithLauncher(this.packWithLauncher.get());
        this.exportInfo.setMinMemory(this.minMemory.get());
        this.exportInfo.setLaunchArguments(this.launchArguments.get());
        this.exportInfo.setJavaArguments(this.javaArguments.get());
        this.exportInfo.setAuthlibInjectorServer(this.authlibInjectorServer.get());
        this.exportInfo.setNoCreateRemoteFiles(this.noCreateRemoteFiles.get());
        this.exportInfo.setSkipCurseForgeRemoteFiles(this.skipCurseForgeRemoteFiles.get());
        if (StringUtils.isNotBlank(this.mcbbsThreadId.get())) {
            this.exportInfo.setOrigins(Collections.singletonList(new McbbsModpackManifest.Origin("mcbbs", Integer.parseInt(this.mcbbsThreadId.get()))));
        }
        this.controller.getSettings().put(MODPACK_INFO, this.exportInfo);
        this.controller.getSettings().put(MODPACK_FILE, file);
        this.controller.onNext();
    }

    @Override
    public void cleanup(SettingsMap settings) {
        this.controller.getSettings().remove(MODPACK_INFO);
    }

    @Override
    public String getTitle() {
        return I18n.i18n("modpack.wizard.step.1.title");
    }

    protected Skin<?> createDefaultSkin() {
        return new ModpackInfoPageSkin(this);
    }

    public static class ModpackInfoPageSkin
    extends SkinBase<ModpackInfoPage> {
        private ObservableList<Node> originList;
        private final List<JFXTextField> validatingFields = new ArrayList<JFXTextField>();

        public ModpackInfoPageSkin(ModpackInfoPage skinnable) {
            super((Control)skinnable);
            VBox pane;
            Insets componentListMargin = new Insets(16.0, 0.0, 16.0, 0.0);
            ScrollPane scroll = new ScrollPane();
            scroll.setFitToWidth(true);
            scroll.setFitToHeight(true);
            this.getChildren().setAll((Object[])new Node[]{scroll});
            BorderPane borderPane = new BorderPane();
            borderPane.setStyle("-fx-padding: 16;");
            scroll.setContent((Node)borderPane);
            if (skinnable.controller.getSettings().get(ModpackTypeSelectionPage.MODPACK_TYPE) == "server") {
                Hyperlink hyperlink = new Hyperlink(I18n.i18n("modpack.wizard.step.initialization.server"));
                hyperlink.setOnAction(e -> FXUtils.openLink("https://docs.hmcl.net/modpack/serverpack.html"));
                borderPane.setTop((Node)hyperlink);
            }
            if (skinnable.controller.getSettings().get(ModpackTypeSelectionPage.MODPACK_TYPE) == "modrinth") {
                pane = new HintPane(MessageDialogPane.MessageType.INFO);
                pane.setText(I18n.i18n("modpack.wizard.step.initialization.modrinth.info"));
                borderPane.setTop((Node)pane);
            } else {
                pane = new HintPane(MessageDialogPane.MessageType.INFO);
                pane.setText(I18n.i18n("modpack.wizard.step.initialization.warning"));
                borderPane.setTop((Node)pane);
            }
            ComponentList list = new ComponentList();
            BorderPane.setMargin((Node)list, (Insets)componentListMargin);
            borderPane.setCenter((Node)list);
            LineTextPane instanceNamePane = new LineTextPane();
            instanceNamePane.setTitle(I18n.i18n("modpack.wizard.step.initialization.exported_version"));
            instanceNamePane.setText(skinnable.versionName);
            list.getContent().add((Object)instanceNamePane);
            list.getContent().addAll((Object[])new Node[]{this.createTextFieldLinePane(I18n.i18n("modpack.name"), (StringProperty)skinnable.name, new RequiredValidator()), this.createTextFieldLinePane(I18n.i18n("archive.author"), (StringProperty)skinnable.author, new RequiredValidator()), this.createTextFieldLinePane(I18n.i18n("archive.version"), (StringProperty)skinnable.version, new RequiredValidator())});
            if (skinnable.options.isRequireFileApi()) {
                list.getContent().add((Object)this.createTextFieldLinePane(I18n.i18n("modpack.file_api"), (StringProperty)skinnable.fileApi, skinnable.options.isValidateFileApi() ? new RequiredValidator() : null, new URLValidator(true)));
            }
            if (skinnable.options.isRequireLaunchArguments()) {
                list.getContent().add((Object)this.createTextFieldLinePane(I18n.i18n("settings.advanced.minecraft_arguments"), (StringProperty)skinnable.launchArguments, new ValidatorBase[0]));
            }
            if (skinnable.options.isRequireJavaArguments()) {
                list.getContent().add((Object)this.createTextFieldLinePane(I18n.i18n("settings.advanced.jvm_args"), (StringProperty)skinnable.javaArguments, new ValidatorBase[0]));
            }
            if (skinnable.options.isRequireUrl()) {
                list.getContent().add((Object)this.createTextFieldLinePane(I18n.i18n("modpack.origin.url"), (StringProperty)skinnable.url, new ValidatorBase[0]));
            }
            if (skinnable.options.isRequireOrigins()) {
                list.getContent().add((Object)this.createTextFieldLinePane(I18n.i18n("modpack.origin.mcbbs"), (StringProperty)skinnable.mcbbsThreadId, new NumberValidator(I18n.i18n("input.number"), true)));
            }
            if (skinnable.options.isRequireMinMemory()) {
                pane = new VBox();
                Label title = new Label(I18n.i18n("settings.memory"));
                VBox.setMargin((Node)title, (Insets)new Insets(0.0, 0.0, 8.0, 0.0));
                HBox lowerBoundPane = new HBox(8.0);
                lowerBoundPane.setAlignment(Pos.CENTER);
                VBox.setMargin((Node)lowerBoundPane, (Insets)new Insets(0.0, 0.0, 0.0, 16.0));
                Label label = new Label(I18n.i18n("settings.memory.lower_bound"));
                JFXSlider slider = new JFXSlider(0.0, 1.0, 0.0);
                HBox.setMargin((Node)slider, (Insets)new Insets(0.0, 0.0, 0.0, 8.0));
                HBox.setHgrow((Node)slider, (Priority)Priority.ALWAYS);
                slider.setValueFactory((Callback<JFXSlider, StringBinding>)((Callback)self -> Bindings.createStringBinding(() -> (int)(self.getValue() * 100.0) + "%", (Observable[])new Observable[]{self.valueProperty()})));
                AtomicBoolean changedByTextField = new AtomicBoolean(false);
                FXUtils.onChangeAndOperate(skinnable.minMemory, minMemory -> {
                    changedByTextField.set(true);
                    slider.setValue((double)minMemory.intValue() * 1.0 / DataSizeUnit.MEGABYTES.convertFromBytes(SystemInfo.getTotalMemorySize()));
                    changedByTextField.set(false);
                });
                slider.valueProperty().addListener((value, oldVal, newVal) -> {
                    if (changedByTextField.get()) {
                        return;
                    }
                    skinnable.minMemory.set((int)(((Number)value.getValue()).doubleValue() * DataSizeUnit.MEGABYTES.convertFromBytes(SystemInfo.getTotalMemorySize())));
                });
                JFXTextField txtMinMemory = new JFXTextField();
                FXUtils.bindInt(txtMinMemory, (Property<Number>)skinnable.minMemory);
                txtMinMemory.getValidators().add((Object)new NumberValidator(I18n.i18n("input.number"), false));
                FXUtils.setLimitWidth((Region)txtMinMemory, 60.0);
                this.validatingFields.add(txtMinMemory);
                lowerBoundPane.getChildren().setAll((Object[])new Node[]{label, slider, txtMinMemory, new Label("MiB")});
                pane.getChildren().setAll((Object[])new Node[]{title, lowerBoundPane});
                list.getContent().add((Object)pane);
            }
            pane = new VBox(8.0);
            JFXTextArea area = new JFXTextArea();
            area.textProperty().bindBidirectional((Property)skinnable.description);
            area.setMinHeight(400.0);
            pane.getChildren().setAll((Object[])new Node[]{new Label(I18n.i18n("modpack.desc")), area});
            list.getContent().add((Object)pane);
            if (skinnable.options.isRequireAuthlibInjectorServer()) {
                LineSelectButton<AuthlibInjectorServer> serversSelectButton = new LineSelectButton<AuthlibInjectorServer>();
                serversSelectButton.setTitle(I18n.i18n("account.injector.server"));
                serversSelectButton.setConverter(AuthlibInjectorServer::getName);
                serversSelectButton.setDescriptionConverter(AuthlibInjectorServer::getUrl);
                serversSelectButton.itemsProperty().set(ConfigHolder.config().getAuthlibInjectorServers());
                skinnable.authlibInjectorServer.bind((ObservableValue)Bindings.createStringBinding(() -> {
                    AuthlibInjectorServer selected = (AuthlibInjectorServer)serversSelectButton.getValue();
                    return selected != null ? selected.getUrl() : null;
                }, (Observable[])new Observable[]{serversSelectButton.valueProperty()}));
                list.getContent().add(serversSelectButton);
            }
            if (skinnable.options.isRequireForceUpdate()) {
                LineToggleButton requireForceUpdateButton = new LineToggleButton();
                requireForceUpdateButton.setTitle(I18n.i18n("modpack.wizard.step.initialization.force_update"));
                requireForceUpdateButton.selectedProperty().bindBidirectional((Property)skinnable.forceUpdate);
                list.getContent().add((Object)requireForceUpdateButton);
            }
            LineToggleButton canIncludeLauncherButton = new LineToggleButton();
            canIncludeLauncherButton.setTitle(I18n.i18n("modpack.wizard.step.initialization.include_launcher"));
            canIncludeLauncherButton.setDisable(!skinnable.canIncludeLauncher);
            canIncludeLauncherButton.selectedProperty().bindBidirectional((Property)skinnable.packWithLauncher);
            list.getContent().add((Object)canIncludeLauncherButton);
            if (skinnable.options.isRequireNoCreateRemoteFiles()) {
                LineToggleButton requireNoCreateRemoteFilesButton = new LineToggleButton();
                requireNoCreateRemoteFilesButton.setTitle(I18n.i18n("modpack.wizard.step.initialization.no_create_remote_files"));
                requireNoCreateRemoteFilesButton.selectedProperty().bindBidirectional((Property)skinnable.noCreateRemoteFiles);
                list.getContent().add((Object)requireNoCreateRemoteFilesButton);
            }
            if (skinnable.options.isRequireSkipCurseForgeRemoteFiles()) {
                LineToggleButton skipCurseForgeRemoteFilesButton = new LineToggleButton();
                skipCurseForgeRemoteFilesButton.setTitle(I18n.i18n("modpack.wizard.step.initialization.skip_curseforge_remote_files"));
                skipCurseForgeRemoteFilesButton.selectedProperty().bindBidirectional((Property)skinnable.skipCurseForgeRemoteFiles);
                list.getContent().add((Object)skipCurseForgeRemoteFilesButton);
            }
            HBox hbox = new HBox();
            hbox.setAlignment(Pos.CENTER_RIGHT);
            borderPane.setBottom((Node)hbox);
            JFXButton nextButton = FXUtils.newRaisedButton(I18n.i18n("wizard.next"));
            nextButton.setOnAction(e -> skinnable.onNext());
            nextButton.setPrefWidth(100.0);
            nextButton.setPrefHeight(40.0);
            nextButton.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.validatingFields.stream().map(field -> !field.validate()).reduce(false, (left, right) -> left != false || right != false), (Observable[])((Observable[])this.validatingFields.stream().map(TextInputControl::textProperty).toArray(StringProperty[]::new))));
            hbox.getChildren().add((Object)nextButton);
            FXUtils.smoothScrolling(scroll);
        }

        private LinePane createTextFieldLinePane(String title, StringProperty property, ValidatorBase ... validators) {
            LinePane linePane = new LinePane();
            JFXTextField textField = new JFXTextField();
            textField.setMinWidth(500.0);
            linePane.setTitle(title);
            linePane.setRight((Node)textField);
            textField.textProperty().bindBidirectional((Property)property);
            boolean needValidation = false;
            if (validators != null) {
                for (ValidatorBase validator : validators) {
                    if (validator == null) continue;
                    needValidation = true;
                    textField.getValidators().add((Object)validator);
                }
            }
            if (needValidation) {
                FXUtils.setValidateWhileTextChanged((Node)textField, true);
                this.validatingFields.add(textField);
            }
            return linePane;
        }
    }
}

