/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.nbt;

import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import java.lang.reflect.Array;
import java.util.EnumMap;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.skin.TreeViewSkin;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.util.Callback;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.nbt.NBTTagType;
import org.jackhuang.hmcl.util.i18n.I18n;

public final class NBTTreeView
extends TreeView<Tag> {
    public NBTTreeView(Item tree) {
        this.setRoot(tree);
        if (tree != null) {
            tree.setExpanded(true);
        }
        this.setCellFactory(NBTTreeView.cellFactory());
    }

    protected Skin<?> createDefaultSkin() {
        return new TreeViewSkin<Tag>((TreeView)this){
            {
                FXUtils.smoothScrolling(this.getVirtualFlow());
            }
        };
    }

    private static Callback<TreeView<Tag>, TreeCell<Tag>> cellFactory() {
        final EnumMap icons = new EnumMap(NBTTagType.class);
        return view -> new TreeCell<Tag>(){

            private void setTagText(String text) {
                String name = ((Item)this.getTreeItem()).getName();
                if (name == null) {
                    this.setText(text);
                } else if (text == null) {
                    this.setText(name);
                } else {
                    this.setText(name + ": " + text);
                }
            }

            private void setTagText(int nEntries) {
                this.setTagText(I18n.i18n("nbt.entries", nEntries));
            }

            public void updateItem(Tag item, boolean empty) {
                super.updateItem((Object)item, empty);
                ImageView imageView = (ImageView)this.getGraphic();
                if (imageView == null) {
                    imageView = new ImageView();
                    this.setGraphic((Node)imageView);
                }
                if (item == null) {
                    imageView.setImage(null);
                    this.setText(null);
                    return;
                }
                NBTTagType tagType = NBTTagType.typeOf(item);
                imageView.setImage(icons.computeIfAbsent(tagType, type -> new Image(type.getIconUrl())));
                imageView.setFitHeight(16.0);
                imageView.setFitWidth(16.0);
                if (((Item)this.getTreeItem()).getText() != null) {
                    this.setText(((Item)this.getTreeItem()).getText());
                } else {
                    switch (tagType) {
                        case BYTE: 
                        case SHORT: 
                        case INT: 
                        case LONG: 
                        case FLOAT: 
                        case DOUBLE: 
                        case STRING: {
                            this.setTagText(item.getValue().toString());
                            break;
                        }
                        case BYTE_ARRAY: 
                        case INT_ARRAY: 
                        case LONG_ARRAY: {
                            this.setTagText(Array.getLength(item.getValue()));
                            break;
                        }
                        case LIST: {
                            this.setTagText(((ListTag)item).size());
                            break;
                        }
                        case COMPOUND: {
                            this.setTagText(((CompoundTag)item).size());
                            break;
                        }
                        default: {
                            this.setTagText(null);
                        }
                    }
                }
            }
        };
    }

    public static Item buildTree(Tag tag) {
        Item item = new Item(tag);
        if (tag instanceof CompoundTag) {
            for (Tag subTag : (CompoundTag)tag) {
                item.getChildren().add((Object)NBTTreeView.buildTree(subTag));
            }
        } else if (tag instanceof ListTag) {
            int idx = 0;
            for (Tag subTag : (ListTag)tag) {
                Item subTree = NBTTreeView.buildTree(subTag);
                subTree.setName(String.valueOf(idx++));
                item.getChildren().add((Object)subTree);
            }
        }
        FXUtils.onChangeAndOperate(item.expandedProperty(), expanded -> {
            if (expanded.booleanValue() && item.getChildren().size() == 1) {
                ((TreeItem)item.getChildren().get(0)).setExpanded(true);
            }
        });
        return item;
    }

    public CompoundTag getRootTag() {
        return (CompoundTag)this.getRoot().getValue();
    }

    public static class Item
    extends TreeItem<Tag> {
        private String text;
        private String name;

        public Item() {
        }

        public Item(Tag value) {
            super((Object)value);
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name == null ? ((Tag)this.getValue()).getName() : this.name;
        }
    }
}

