/*
 * ____ DAPHNE COPYRIGHT NOTICE ____
 *
 * Copyright (C) 2001 Matt Ownby
 *
 * This file is part of DAPHNE, a laserdisc arcade game emulator
 *
 * DAPHNE is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * DAPHNE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

// hypseus.h

#ifndef DAPHNE_H
#define DAPHNE_H

#define SDL_ERROR_INIT           0x96
#define SDL_ERROR_MAINRENDERER   0x97
#define SDL_ERROR_SCOREWINDOW    0x98
#define SDL_ERROR_SCORERENDERER  0x99
#define SDL_ERROR_FONT           0x9A
#define SDL_ERROR_SCREENSHOT     0x9B

// global definitions ...

// The current version of DAPHNE will now be returned by this function alone.
// I was having problems with VS6's dependency detector (it wasn't detecting when I was changing
//  the version in the .h file).  Another advantage to having it here is not having to change
//  a header file.
const char *get_hypseus_version();

unsigned char get_filename(char *s, unsigned char n);
void set_quitflag();
unsigned char get_quitflag();
bool change_dir(const char *pszNewDir);
void set_cur_dir(const char *exe_loc);
//int main(int, char **);
void set_unix_signals();
void handle_unix_signals(int);
void set_search_offset(int i);
int get_search_offset();
void set_file_mask(char *mask);
char *get_file_mask();
unsigned char get_autostart();
unsigned char get_frame_modifier();
void set_frame_modifier(unsigned char value);
void set_scoreboard(unsigned char value);
void set_scoreboard_usb_port(unsigned char value);
void set_scoreboard_usb_impl(unsigned char value);
void set_scoreboard_usb_baud(unsigned int value);
void set_scoreboard_usb_rts(bool value);
unsigned char get_scoreboard();
void set_scoreboard_port(unsigned int value);
unsigned int get_scoreboard_port();
void reset_logfile(int argc, char **argv);
void set_scoreboard_text(char sb_text[]);

void set_idleexit(unsigned int value); // added by JFA for -idleexit
unsigned int get_idleexit(); // added by JFA for -idleexit
// added by JFA for -startsilent
void set_startsilent(unsigned char value);
unsigned char get_startsilent();
// end edit

unsigned char get_usb_port();
unsigned char get_usb_impl();
unsigned int get_usb_baud();
bool get_usb_rts();

// added by MAC for -nolog
void set_log_was_disabled(bool value);
// end edit

#endif // DAPHNE_H

