/*
 * Copyright (c) 2013, Alexey Degtyarev <alexey@renatasystems.org>.
 * All rights reserved.
 *
 * Precalculation of matrix A multiplication.
 *
 * $Id$
 */

#ifndef __GOST3411_BIG_ENDIAN__
ALIGN(16) static const unsigned long long Ax[8][256] =
{
    {
        0xd01f715b5c7ef8e6ULL, 0x16fa240980778325ULL, 0xa8a42e857ee049c8ULL,
        0x6ac1068fa186465bULL, 0x6e417bd7a2e9320bULL, 0x665c8167a437daabULL,
        0x7666681aa89617f6ULL, 0x4b959163700bdcf5ULL, 0xf14be6b78df36248ULL,
        0xc585bd689a625cffULL, 0x9557d7fca67d82cbULL, 0x89f0b969af6dd366ULL,
        0xb0833d48749f6c35ULL, 0xa1998c23b1ecbc7cULL, 0x8d70c431ac02a736ULL,
        0xd6dfbc2fd0a8b69eULL, 0x37aeb3e551fa198bULL, 0x0b7d128a40b5cf9cULL,
        0x5a8f2008b5780cbcULL, 0xedec882284e333e5ULL, 0xd25fc177d3c7c2ceULL,
        0x5e0f5d50b61778ecULL, 0x1d873683c0c24cb9ULL, 0xad040bcbb45d208cULL,
        0x2f89a0285b853c76ULL, 0x5732fff6791b8d58ULL, 0x3e9311439ef6ec3fULL,
        0xc9183a809fd3c00fULL, 0x83adf3f5260a01eeULL, 0xa6791941f4e8ef10ULL,
        0x103ae97d0ca1cd5dULL, 0x2ce948121dee1b4aULL, 0x39738421dbf2bf53ULL,
        0x093da2a6cf0cf5b4ULL, 0xcd9847d89cbcb45fULL, 0xf9561c078b2d8ae8ULL,
        0x9c6a755a6971777fULL, 0xbc1ebaa0712ef0c5ULL, 0x72e61542abf963a6ULL,
        0x78bb5fde229eb12eULL, 0x14ba94250fceb90dULL, 0x844d6697630e5282ULL,
        0x98ea08026a1e032fULL, 0xf06bbea144217f5cULL, 0xdb6263d11ccb377aULL,
        0x641c314b2b8ee083ULL, 0x320e96ab9b4770cfULL, 0x1ee7deb986a96b85ULL,
        0xe96cf57a878c47b5ULL, 0xfdd6615f8842feb8ULL, 0xc83862965601dd1bULL,
        0x2ea9f83e92572162ULL, 0xf876441142ff97fcULL, 0xeb2c455608357d9dULL,
        0x5612a7e0b0c9904cULL, 0x6c01cbfb2d500823ULL, 0x4548a6a7fa037a2dULL,
        0xabc4c6bf388b6ef4ULL, 0xbade77d4fdf8bebdULL, 0x799b07c8eb4cac3aULL,
        0x0c9d87e805b19cf0ULL, 0xcb588aac106afa27ULL, 0xea0c1d40c1e76089ULL,
        0x2869354a1e816f1aULL, 0xff96d17307fbc490ULL, 0x9f0a9d602f1a5043ULL,
        0x96373fc6e016a5f7ULL, 0x5292dab8b3a6e41cULL, 0x9b8ae0382c752413ULL,
        0x4f15ec3b7364a8a5ULL, 0x3fb349555724f12bULL, 0xc7c50d4415db66d7ULL,
        0x92b7429ee379d1a7ULL, 0xd37f99611a15dfdaULL, 0x231427c05e34a086ULL,
        0xa439a96d7b51d538ULL, 0xb403401077f01865ULL, 0xdda2aea5901d7902ULL,
        0x0a5d4a9c8967d288ULL, 0xc265280adf660f93ULL, 0x8bb0094520d4e94eULL,
        0x2a29856691385532ULL, 0x42a833c5bf072941ULL, 0x73c64d54622b7eb2ULL,
        0x07e095624504536cULL, 0x8a905153e906f45aULL, 0x6f6123c16b3b2f1fULL,
        0xc6e55552dc097bc3ULL, 0x4468feb133d16739ULL, 0xe211e7f0c7398829ULL,
        0xa2f96419f7879b40ULL, 0x19074bdbc3ad38e9ULL, 0xf4ebc3f9474e0b0cULL,
        0x43886bd376d53455ULL, 0xd8028beb5aa01046ULL, 0x51f23282f5cdc320ULL,
        0xe7b1c2be0d84e16dULL, 0x081dfab006dee8a0ULL, 0x3b33340d544b857bULL,
        0x7f5bcabc679ae242ULL, 0x0edd37c48a08a6d8ULL, 0x81ed43d9a9b33bc6ULL,
        0xb1a3655ebd4d7121ULL, 0x69a1eeb5e7ed6167ULL, 0xf6ab73d5c8f73124ULL,
        0x1a67a3e185c61fd5ULL, 0x2dc91004d43c065eULL, 0x0240b02c8fb93a28ULL,
        0x90f7f2b26cc0eb8fULL, 0x3cd3a16f114fd617ULL, 0xaae49ea9f15973e0ULL,
        0x06c0cd748cd64e78ULL, 0xda423bc7d5192a6eULL, 0xc345701c16b41287ULL,
        0x6d2193ede4821537ULL, 0xfcf639494190e3acULL, 0x7c3b228621f1c57eULL,
        0xfb16ac2b0494b0c0ULL, 0xbf7e529a3745d7f9ULL, 0x6881b6a32e3f7c73ULL,
        0xca78d2bad9b8e733ULL, 0xbbfe2fc2342aa3a9ULL, 0x0dbddffecc6381e4ULL,
        0x70a6a56e2440598eULL, 0xe4d12a844befc651ULL, 0x8c509c2765d0ba22ULL,
        0xee8c6018c28814d9ULL, 0x17da7c1f49a59e31ULL, 0x609c4c1328e194d3ULL,
        0xb3e3d57232f44b09ULL, 0x91d7aaa4a512f69bULL, 0x0ffd6fd243dabbccULL,
        0x50d26a943c1fde34ULL, 0x6be15e9968545b4fULL, 0x94778fea6faf9fdfULL,
        0x2b09dd7058ea4826ULL, 0x677cd9716de5c7bfULL, 0x49d5214fffb2e6ddULL,
        0x0360e83a466b273cULL, 0x1fc786af4f7b7691ULL, 0xa0b9d435783ea168ULL,
        0xd49f0c035f118cb6ULL, 0x01205816c9d21d14ULL, 0xac2453dd7d8f3d98ULL,
        0x545217cc3f70aa64ULL, 0x26b4028e9489c9c2ULL, 0xdec2469fd6765e3eULL,
        0x04807d58036f7450ULL, 0xe5f17292823ddb45ULL, 0xf30b569b024a5860ULL,
        0x62dcfc3fa758aefbULL, 0xe84cad6c4e5e5aa1ULL, 0xccb81fce556ea94bULL,
        0x53b282ae7a74f908ULL, 0x1b47fbf74c1402c1ULL, 0x368eebf39828049fULL,
        0x7afbeff2ad278b06ULL, 0xbe5e0a8cfe97caedULL, 0xcfd8f7f413058e77ULL,
        0xf78b2bc301252c30ULL, 0x4d555c17fcdd928dULL, 0x5f2f05467fc565f8ULL,
        0x24f4b2a21b30f3eaULL, 0x860dd6bbecb768aaULL, 0x4c750401350f8f99ULL,
        0x0000000000000000ULL, 0xecccd0344d312ef1ULL, 0xb5231806be220571ULL,
        0xc105c030990d28afULL, 0x653c695de25cfd97ULL, 0x159acc33c61ca419ULL,
        0xb89ec7f872418495ULL, 0xa9847693b73254dcULL, 0x58cf90243ac13694ULL,
        0x59efc832f3132b80ULL, 0x5c4fed7c39ae42c4ULL, 0x828dabe3efd81cfaULL,
        0xd13f294d95ace5f2ULL, 0x7d1b7a90e823d86aULL, 0xb643f03cf849224dULL,
        0x3df3f979d89dcb03ULL, 0x7426d836272f2ddeULL, 0xdfe21e891fa4432aULL,
        0x3a136c1b9d99986fULL, 0xfa36f43dcd46add4ULL, 0xc025982650df35bbULL,
        0x856d3e81aadc4f96ULL, 0xc4a5e57e53b041ebULL, 0x4708168b75ba4005ULL,
        0xaf44bbe73be41aa4ULL, 0x971767d029c4b8e3ULL, 0xb9be9feebb939981ULL,
        0x215497ecd18d9aaeULL, 0x316e7e91dd2c57f3ULL, 0xcef8afe2dad79363ULL,
        0x3853dc371220a247ULL, 0x35ee03c9de4323a3ULL, 0xe6919aa8c456fc79ULL,
        0xe05157dc4880b201ULL, 0x7bdbb7e464f59612ULL, 0x127a59518318f775ULL,
        0x332ecebd52956ddbULL, 0x8f30741d23bb9d1eULL, 0xd922d3fd93720d52ULL,
        0x7746300c61440ae2ULL, 0x25d4eab4d2e2eefeULL, 0x75068020eefd30caULL,
        0x135a01474acaea61ULL, 0x304e268714fe4ae7ULL, 0xa519f17bb283c82cULL,
        0xdc82f6b359cf6416ULL, 0x5baf781e7caa11a8ULL, 0xb2c38d64fb26561dULL,
        0x34ce5bdf17913eb7ULL, 0x5d6fb56af07c5fd0ULL, 0x182713cd0a7f25fdULL,
        0x9e2ac576e6c84d57ULL, 0x9aaab82ee5a73907ULL, 0xa3d93c0f3e558654ULL,
        0x7e7b92aaae48ff56ULL, 0x872d8ead256575beULL, 0x41c8dbfff96c0e7dULL,
        0x99ca5014a3cc1e3bULL, 0x40e883e930be1369ULL, 0x1ca76e95091051adULL,
        0x4e35b42dbab6b5b1ULL, 0x05a0254ecabd6944ULL, 0xe1710fca8152af15ULL,
        0xf22b0e8dcb984574ULL, 0xb763a82a319b3f59ULL, 0x63fca4296e8ab3efULL,
        0x9d4a2d4ca0a36a6bULL, 0xe331bfe60eeb953dULL, 0xd5bf541596c391a2ULL,
        0xf5cb9bef8e9c1618ULL, 0x46284e9dbc685d11ULL, 0x2074cffa185f87baULL,
        0xbd3ee2b6b8fcedd1ULL, 0xae64e3f1f23607b0ULL, 0xfeb68965ce29d984ULL,
        0x55724fdaf6a2b770ULL, 0x29496d5cd753720eULL, 0xa75941573d3af204ULL,
        0x8e102c0bea69800aULL, 0x111ab16bc573d049ULL, 0xd7ffe439197aab8aULL,
        0xefac380e0b5a09cdULL, 0x48f579593660fbc9ULL, 0x22347fd697e6bd92ULL,
        0x61bc1405e13389c7ULL, 0x4ab5c975b9d9c1e1ULL, 0x80cd1bcf606126d2ULL,
        0x7186fd78ed92449aULL, 0x93971a882aabccb3ULL, 0x88d0e17f66bfce72ULL,
        0x27945a985d5bd4d6ULL
    },
    {
        0xde553f8c05a811c8ULL, 0x1906b59631b4f565ULL, 0x436e70d6b1964ff7ULL,
        0x36d343cb8b1e9d85ULL, 0x843dfacc858aab5aULL, 0xfdfc95c299bfc7f9ULL,
        0x0f634bdea1d51fa2ULL, 0x6d458b3b76efb3cdULL, 0x85c3f77cf8593f80ULL,
        0x3c91315fbe737cb2ULL, 0x2148b03366ace398ULL, 0x18f8b8264c6761bfULL,
        0xc830c1c495c9fb0fULL, 0x981a76102086a0aaULL, 0xaa16012142f35760ULL,
        0x35cc54060c763cf6ULL, 0x42907d66cc45db2dULL, 0x8203d44b965af4bcULL,
        0x3d6f3cefc3a0e868ULL, 0xbc73ff69d292bda7ULL, 0x8722ed0102e20a29ULL,
        0x8f8185e8cd34deb7ULL, 0x9b0561dda7ee01d9ULL, 0x5335a0193227fad6ULL,
        0xc9cecc74e81a6fd5ULL, 0x54f5832e5c2431eaULL, 0x99e47ba05d553470ULL,
        0xf7bee756acd226ceULL, 0x384e05a5571816fdULL, 0xd1367452a47d0e6aULL,
        0xf29fde1c386ad85bULL, 0x320c77316275f7caULL, 0xd0c879e2d9ae9ab0ULL,
        0xdb7406c69110ef5dULL, 0x45505e51a2461011ULL, 0xfc029872e46c5323ULL,
        0xfa3cb6f5f7bc0cc5ULL, 0x031f17cd8768a173ULL, 0xbd8df2d9af41297dULL,
        0x9d3b4f5ab43e5e3fULL, 0x4071671b36feee84ULL, 0x716207e7d3e3b83dULL,
        0x48d20ff2f9283a1aULL, 0x27769eb4757cbc7eULL, 0x5c56ebc793f2e574ULL,
        0xa48b474f9ef5dc18ULL, 0x52cbada94ff46e0cULL, 0x60c7da982d8199c6ULL,
        0x0e9d466edc068b78ULL, 0x4eec2175eaf865fcULL, 0x550b8e9e21f7a530ULL,
        0x6b7ba5bc653fec2bULL, 0x5eb7f1ba6949d0ddULL, 0x57ea94e3db4c9099ULL,
        0xf640eae6d101b214ULL, 0xdd4a284182c0b0bbULL, 0xff1d8fbf6304f250ULL,
        0xb8accb933bf9d7e8ULL, 0xe8867c478eb68c4dULL, 0x3f8e2692391bddc1ULL,
        0xcb2fd60912a15a7cULL, 0xaec935dbab983d2fULL, 0xf55ffd2b56691367ULL,
        0x80e2ce366ce1c115ULL, 0x179bf3f8edb27e1dULL, 0x01fe0db07dd394daULL,
        0xda8a0b76ecc37b87ULL, 0x44ae53e1df9584cbULL, 0xb310b4b77347a205ULL,
        0xdfab323c787b8512ULL, 0x3b511268d070b78eULL, 0x65e6e3d2b9396753ULL,
        0x6864b271e2574d58ULL, 0x259784c98fc789d7ULL, 0x02e11a7dfabb35a9ULL,
        0x8841a6dfa337158bULL, 0x7ade78c39b5dcdd0ULL, 0xb7cf804d9a2cc84aULL,
        0x20b6bd831b7f7742ULL, 0x75bd331d3a88d272ULL, 0x418f6aab4b2d7a5eULL,
        0xd9951cbb6babdaf4ULL, 0xb6318dfde7ff5c90ULL, 0x1f389b112264aa83ULL,
        0x492c024284fbaec0ULL, 0xe33a0363c608f9a0ULL, 0x2688930408af28a4ULL,
        0xc7538a1a341ce4adULL, 0x5da8e677ee2171aeULL, 0x8c9e92254a5c7fc4ULL,
        0x63d8cd55aae938b5ULL, 0x29ebd8daa97a3706ULL, 0x959827b37be88aa1ULL,
        0x1484e4356adadf6eULL, 0xa7945082199d7d6bULL, 0xbf6ce8a455fa1cd4ULL,
        0x9cc542eac9edcae5ULL, 0x79c16f0e1c356ca3ULL, 0x89bfab6fdee48151ULL,
        0xd4174d1830c5f0ffULL, 0x9258048415eb419dULL, 0x6139d72850520d1cULL,
        0x6a85a80c18ec78f1ULL, 0xcd11f88e0171059aULL, 0xcceff53e7ca29140ULL,
        0xd229639f2315af19ULL, 0x90b91ef9ef507434ULL, 0x5977d28d074a1be1ULL,
        0x311360fce51d56b9ULL, 0xc093a92d5a1f2f91ULL, 0x1a19a25bb6dc5416ULL,
        0xeb996b8a09de2d3eULL, 0xfee3820f1ed7668aULL, 0xd7085ad5b7ad518cULL,
        0x7fff41890fe53345ULL, 0xec5948bd67dde602ULL, 0x2fd5f65dbaaa68e0ULL,
        0xa5754affe32648c2ULL, 0xf8ddac880d07396cULL, 0x6fa491468c548664ULL,
        0x0c7c5c1326bdbed1ULL, 0x4a33158f03930fb3ULL, 0x699abfc19f84d982ULL,
        0xe4fa2054a80b329cULL, 0x6707f9af438252faULL, 0x08a368e9cfd6d49eULL,
        0x47b1442c58fd25b8ULL, 0xbbb3dc5ebc91769bULL, 0x1665fe489061eac7ULL,
        0x33f27a811fa66310ULL, 0x93a609346838d547ULL, 0x30ed6d4c98cec263ULL,
        0x1dd9816cd8df9f2aULL, 0x94662a03063b1e7bULL, 0x83fdd9fbeb896066ULL,
        0x7b207573e68e590aULL, 0x5f49fc0a149a4407ULL, 0x343259b671a5a82cULL,
        0xfbc2bb458a6f981fULL, 0xc272b350a0a41a38ULL, 0x3aaf1fd8ada32354ULL,
        0x6cbb868b0b3c2717ULL, 0xa2b569c88d2583feULL, 0xf180c9d1bf027928ULL,
        0xaf37386bd64ba9f5ULL, 0x12bacab2790a8088ULL, 0x4c0d3b0810435055ULL,
        0xb2eeb9070e9436dfULL, 0xc5b29067cea7d104ULL, 0xdcb425f1ff132461ULL,
        0x4f122cc5972bf126ULL, 0xac282fa651230886ULL, 0xe7e537992f6393efULL,
        0xe61b3a2952b00735ULL, 0x709c0a57ae302ce7ULL, 0xe02514ae416058d3ULL,
        0xc44c9dd7b37445deULL, 0x5a68c5408022ba92ULL, 0x1c278cdca50c0bf0ULL,
        0x6e5a9cf6f18712beULL, 0x86dce0b17f319ef3ULL, 0x2d34ec2040115d49ULL,
        0x4bcd183f7e409b69ULL, 0x2815d56ad4a9a3dcULL, 0x24698979f2141d0dULL,
        0x0000000000000000ULL, 0x1ec696a15fb73e59ULL, 0xd86b110b16784e2eULL,
        0x8e7f8858b0e74a6dULL, 0x063e2e8713d05fe6ULL, 0xe2c40ed3bbdb6d7aULL,
        0xb1f1aeca89fc97acULL, 0xe1db191e3cb3cc09ULL, 0x6418ee62c4eaf389ULL,
        0xc6ad87aa49cf7077ULL, 0xd6f65765ca7ec556ULL, 0x9afb6c6dda3d9503ULL,
        0x7ce05644888d9236ULL, 0x8d609f95378feb1eULL, 0x23a9aa4e9c17d631ULL,
        0x6226c0e5d73aac6fULL, 0x56149953a69f0443ULL, 0xeeb852c09d66d3abULL,
        0x2b0ac2a753c102afULL, 0x07c023376e03cb3cULL, 0x2ccae1903dc2c993ULL,
        0xd3d76e2f5ec63bc3ULL, 0x9e2458973356ff4cULL, 0xa66a5d32644ee9b1ULL,
        0x0a427294356de137ULL, 0x783f62be61e6f879ULL, 0x1344c70204d91452ULL,
        0x5b96c8f0fdf12e48ULL, 0xa90916ecc59bf613ULL, 0xbe92e5142829880eULL,
        0x727d102a548b194eULL, 0x1be7afebcb0fc0ccULL, 0x3e702b2244c8491bULL,
        0xd5e940a84d166425ULL, 0x66f9f41f3e51c620ULL, 0xabe80c913f20c3baULL,
        0xf07ec461c2d1edf2ULL, 0xf361d3ac45b94c81ULL, 0x0521394a94b8fe95ULL,
        0xadd622162cf09c5cULL, 0xe97871f7f3651897ULL, 0xf4a1f09b2bba87bdULL,
        0x095d6559b2054044ULL, 0x0bbc7f2448be75edULL, 0x2af4cf172e129675ULL,
        0x157ae98517094bb4ULL, 0x9fda55274e856b96ULL, 0x914713499283e0eeULL,
        0xb952c623462a4332ULL, 0x74433ead475b46a8ULL, 0x8b5eb112245fb4f8ULL,
        0xa34b6478f0f61724ULL, 0x11a5dd7ffe6221fbULL, 0xc16da49d27ccbb4bULL,
        0x76a224d0bde07301ULL, 0x8aa0bca2598c2022ULL, 0x4df336b86d90c48fULL,
        0xea67663a740db9e4ULL, 0xef465f70e0b54771ULL, 0x39b008152acb8227ULL,
        0x7d1e5bf4f55e06ecULL, 0x105bd0cf83b1b521ULL, 0x775c2960c033e7dbULL,
        0x7e014c397236a79fULL, 0x811cc386113255cfULL, 0xeda7450d1a0e72d8ULL,
        0x5889df3d7a998f3bULL, 0x2e2bfbedc779fc3aULL, 0xce0eef438619a4e9ULL,
        0x372d4e7bf6cd095fULL, 0x04df34fae96b6a4fULL, 0xf923a13870d4adb6ULL,
        0xa1aa7e050a4d228dULL, 0xa8f71b5cb84862c9ULL, 0xb52e9a306097fde3ULL,
        0x0d8251a35b6e2a0bULL, 0x2257a7fee1c442ebULL, 0x73831d9a29588d94ULL,
        0x51d4ba64c89ccf7fULL, 0x502ab7d4b54f5ba5ULL, 0x97793dce8153bf08ULL,
        0xe5042de4d5d8a646ULL, 0x9687307efc802bd2ULL, 0xa05473b5779eb657ULL,
        0xb4d097801d446939ULL, 0xcff0e2f3fbca3033ULL, 0xc38cbee0dd778ee2ULL,
        0x464f499c252eb162ULL, 0xcad1dbb96f72cea6ULL, 0xba4dd1eec142e241ULL,
        0xb00fa37af42f0376ULL
    },
    {
        0xcce4cd3aa968b245ULL, 0x089d5484e80b7fafULL, 0x638246c1b3548304ULL,
        0xd2fe0ec8c2355492ULL, 0xa7fbdf7ff2374eeeULL, 0x4df1600c92337a16ULL,
        0x84e503ea523b12fbULL, 0x0790bbfd53ab0c4aULL, 0x198a780f38f6ea9dULL,
        0x2ab30c8f55ec48cbULL, 0xe0f7fed6b2c49db5ULL, 0xb6ecf3f422cadbdcULL,
        0x409c9a541358df11ULL, 0xd3ce8a56dfde3fe3ULL, 0xc3e9224312c8c1a0ULL,
        0x0d6dfa58816ba507ULL, 0xddf3e1b179952777ULL, 0x04c02a42748bb1d9ULL,
        0x94c2abff9f2decb8ULL, 0x4f91752da8f8acf4ULL, 0x78682befb169bf7bULL,
        0xe1c77a48af2ff6c4ULL, 0x0c5d7ec69c80ce76ULL, 0x4cc1e4928fd81167ULL,
        0xfeed3d24d9997b62ULL, 0x518bb6dfc3a54a23ULL, 0x6dbf2d26151f9b90ULL,
        0xb5bc624b05ea664fULL, 0xe86aaa525acfe21aULL, 0x4801ced0fb53a0beULL,
        0xc91463e6c00868edULL, 0x1027a815cd16fe43ULL, 0xf67069a0319204cdULL,
        0xb04ccc976c8abce7ULL, 0xc0b9b3fc35e87c33ULL, 0xf380c77c58f2de65ULL,
        0x50bb3241de4e2152ULL, 0xdf93f490435ef195ULL, 0xf1e0d25d62390887ULL,
        0xaf668bfb1a3c3141ULL, 0xbc11b251f00a7291ULL, 0x73a5eed47e427d47ULL,
        0x25bee3f6ee4c3b2eULL, 0x43cc0beb34786282ULL, 0xc824e778dde3039cULL,
        0xf97d86d98a327728ULL, 0xf2b043e24519b514ULL, 0xe297ebf7880f4b57ULL,
        0x3a94a49a98fab688ULL, 0x868516cb68f0c419ULL, 0xeffa11af0964ee50ULL,
        0xa4ab4ec0d517f37dULL, 0xa9c6b498547c567aULL, 0x8e18424f80fbbbb6ULL,
        0x0bcdc53bcf2bc23cULL, 0x137739aaea3643d0ULL, 0x2c1333ec1bac2ff0ULL,
        0x8d48d3f0a7db0625ULL, 0x1e1ac3f26b5de6d7ULL, 0xf520f81f16b2b95eULL,
        0x9f0f6ec450062e84ULL, 0x0130849e1deb6b71ULL, 0xd45e31ab8c7533a9ULL,
        0x652279a2fd14e43fULL, 0x3209f01e70f1c927ULL, 0xbe71a770cac1a473ULL,
        0x0e3d6be7a64b1894ULL, 0x7ec8148cff29d840ULL, 0xcb7476c7fac3be0fULL,
        0x72956a4a63a91636ULL, 0x37f95ec21991138fULL, 0x9e3fea5a4ded45f5ULL,
        0x7b38ba50964902e8ULL, 0x222e580bbde73764ULL, 0x61e253e0899f55e6ULL,
        0xfc8d2805e352ad80ULL, 0x35994be3235ac56dULL, 0x09add01af5e014deULL,
        0x5e8659a6780539c6ULL, 0xb17c48097161d796ULL, 0x026015213acbd6e2ULL,
        0xd1ae9f77e515e901ULL, 0xb7dc776a3f21b0adULL, 0xaba6a1b96eb78098ULL,
        0x9bcf4486248d9f5dULL, 0x582666c536455efdULL, 0xfdbdac9bfeb9c6f1ULL,
        0xc47999be4163cdeaULL, 0x765540081722a7efULL, 0x3e548ed8ec710751ULL,
        0x3d041f67cb51bac2ULL, 0x7958af71ac82d40aULL, 0x36c9da5c047a78feULL,
        0xed9a048e33af38b2ULL, 0x26ee7249c96c86bdULL, 0x900281bdeba65d61ULL,
        0x11172c8bd0fd9532ULL, 0xea0abf73600434f8ULL, 0x42fc8f75299309f3ULL,
        0x34a9cf7d3eb1ae1cULL, 0x2b838811480723baULL, 0x5ce64c8742ceef24ULL,
        0x1adae9b01fd6570eULL, 0x3c349bf9d6bad1b3ULL, 0x82453c891c7b75c0ULL,
        0x97923a40b80d512bULL, 0x4a61dbf1c198765cULL, 0xb48ce6d518010d3eULL,
        0xcfb45c858e480fd6ULL, 0xd933cbf30d1e96aeULL, 0xd70ea014ab558e3aULL,
        0xc189376228031742ULL, 0x9262949cd16d8b83ULL, 0xeb3a3bed7def5f89ULL,
        0x49314a4ee6b8cbcfULL, 0xdcc3652f647e4c06ULL, 0xda635a4c2a3e2b3dULL,
        0x470c21a940f3d35bULL, 0x315961a157d174b4ULL, 0x6672e81dda3459acULL,
        0x5b76f77a1165e36eULL, 0x445cb01667d36ec8ULL, 0xc5491d205c88a69bULL,
        0x456c34887a3805b9ULL, 0xffddb9bac4721013ULL, 0x99af51a71e4649bfULL,
        0xa15be01cbc7729d5ULL, 0x52db2760e485f7b0ULL, 0x8c78576eba306d54ULL,
        0xae560f6507d75a30ULL, 0x95f22f6182c687c9ULL, 0x71c5fbf54489aba5ULL,
        0xca44f259e728d57eULL, 0x88b87d2ccebbdc8dULL, 0xbab18d32be4a15aaULL,
        0x8be8ec93e99b611eULL, 0x17b713e89ebdf209ULL, 0xb31c5d284baa0174ULL,
        0xeeca9531148f8521ULL, 0xb8d198138481c348ULL, 0x8988f9b2d350b7fcULL,
        0xb9e11c8d996aa839ULL, 0x5a4673e40c8e881fULL, 0x1687977683569978ULL,
        0xbf4123eed72acf02ULL, 0x4ea1f1b3b513c785ULL, 0xe767452be16f91ffULL,
        0x7505d1b730021a7cULL, 0xa59bca5ec8fc980cULL, 0xad069eda20f7e7a3ULL,
        0x38f4b1bba231606aULL, 0x60d2d77e94743e97ULL, 0x9affc0183966f42cULL,
        0x248e6768f3a7505fULL, 0xcdd449a4b483d934ULL, 0x87b59255751baf68ULL,
        0x1bea6d2e023d3c7fULL, 0x6b1f12455b5ffcabULL, 0x743555292de9710dULL,
        0xd8034f6d10f5fddfULL, 0xc6198c9f7ba81b08ULL, 0xbb8109aca3a17edbULL,
        0xfa2d1766ad12cabbULL, 0xc729080166437079ULL, 0x9c5fff7b77269317ULL,
        0x0000000000000000ULL, 0x15d706c9a47624ebULL, 0x6fdf38072fd44d72ULL,
        0x5fb6dd3865ee52b7ULL, 0xa33bf53d86bcff37ULL, 0xe657c1b5fc84fa8eULL,
        0xaa962527735cebe9ULL, 0x39c43525bfda0b1bULL, 0x204e4d2a872ce186ULL,
        0x7a083ece8ba26999ULL, 0x554b9c9db72efbfaULL, 0xb22cd9b656416a05ULL,
        0x96a2bedea5e63a5aULL, 0x802529a826b0a322ULL, 0x8115ad363b5bc853ULL,
        0x8375b81701901eb1ULL, 0x3069e53f4a3a1fc5ULL, 0xbd2136cfede119e0ULL,
        0x18bafc91251d81ecULL, 0x1d4a524d4c7d5b44ULL, 0x05f0aedc6960daa8ULL,
        0x29e39d3072ccf558ULL, 0x70f57f6b5962c0d4ULL, 0x989fd53903ad22ceULL,
        0xf84d024797d91c59ULL, 0x547b1803aac5908bULL, 0xf0d056c37fd263f6ULL,
        0xd56eb535919e58d8ULL, 0x1c7ad6d351963035ULL, 0x2e7326cd2167f912ULL,
        0xac361a443d1c8cd2ULL, 0x697f076461942a49ULL, 0x4b515f6fdc731d2dULL,
        0x8ad8680df4700a6fULL, 0x41ac1eca0eb3b460ULL, 0x7d988533d80965d3ULL,
        0xa8f6300649973d0bULL, 0x7765c4960ac9cc9eULL, 0x7ca801adc5e20ea2ULL,
        0xdea3700e5eb59ae4ULL, 0xa06b6482a19c42a4ULL, 0x6a2f96db46b497daULL,
        0x27def6d7d487edccULL, 0x463ca5375d18b82aULL, 0xa6cb5be1efdc259fULL,
        0x53eba3fef96e9cc1ULL, 0xce84d81b93a364a7ULL, 0xf4107c810b59d22fULL,
        0x333974806d1aa256ULL, 0x0f0def79bba073e5ULL, 0x231edc95a00c5c15ULL,
        0xe437d494c64f2c6cULL, 0x91320523f64d3610ULL, 0x67426c83c7df32ddULL,
        0x6eefbc99323f2603ULL, 0x9d6f7be56acdf866ULL, 0x5916e25b2bae358cULL,
        0x7ff89012e2c2b331ULL, 0x035091bf2720bd93ULL, 0x561b0d22900e4669ULL,
        0x28d319ae6f279e29ULL, 0x2f43a2533c8c9263ULL, 0xd09e1be9f8fe8270ULL,
        0xf740ed3e2c796fbcULL, 0xdb53ded237d5404cULL, 0x62b2c25faebfe875ULL,
        0x0afd41a5d2c0a94dULL, 0x6412fd3ce0ff8f4eULL, 0xe3a76f6995e42026ULL,
        0x6c8fa9b808f4f0e1ULL, 0xc2d9a6dd0f23aad1ULL, 0x8f28c6d19d10d0c7ULL,
        0x85d587744fd0798aULL, 0xa20b71a39b579446ULL, 0x684f83fa7c7f4138ULL,
        0xe507500adba4471dULL, 0x3f640a46f19a6c20ULL, 0x1247bd34f7dd28a1ULL,
        0x2d23b77206474481ULL, 0x93521002cc86e0f2ULL, 0x572b89bc8de52d18ULL,
        0xfb1d93f8b0f9a1caULL, 0xe95a2ecc4724896bULL, 0x3ba420048511ddf9ULL,
        0xd63e248ab6bee54bULL, 0x5dd6c8195f258455ULL, 0x06a03f634e40673bULL,
        0x1f2a476c76b68da6ULL, 0x217ec9b49ac78af7ULL, 0xecaa80102e4453c3ULL,
        0x14e78257b99d4f9aULL
    },
    {
        0x20329b2cc87bba05ULL, 0x4f5eb6f86546a531ULL, 0xd4f44775f751b6b1ULL,
        0x8266a47b850dfa8bULL, 0xbb986aa15a6ca985ULL, 0xc979eb08f9ae0f99ULL,
        0x2da6f447a2375ea1ULL, 0x1e74275dcd7d8576ULL, 0xbc20180a800bc5f8ULL,
        0xb4a2f701b2dc65beULL, 0xe726946f981b6d66ULL, 0x48e6c453bf21c94cULL,
        0x42cad9930f0a4195ULL, 0xefa47b64aacccd20ULL, 0x71180a8960409a42ULL,
        0x8bb3329bf6a44e0cULL, 0xd34c35de2d36daccULL, 0xa92f5b7cbc23dc96ULL,
        0xb31a85aa68bb09c3ULL, 0x13e04836a73161d2ULL, 0xb24dfc4129c51d02ULL,
        0x8ae44b70b7da5acdULL, 0xe671ed84d96579a7ULL, 0xa4bb3417d66f3832ULL,
        0x4572ab38d56d2de8ULL, 0xb1b47761ea47215cULL, 0xe81c09cf70aba15dULL,
        0xffbdb872ce7f90acULL, 0xa8782297fd5dc857ULL, 0x0d946f6b6a4ce4a4ULL,
        0xe4df1f4f5b995138ULL, 0x9ebc71edca8c5762ULL, 0x0a2c1dc0b02b88d9ULL,
        0x3b503c115d9d7b91ULL, 0xc64376a8111ec3a2ULL, 0xcec199a323c963e4ULL,
        0xdc76a87ec58616f7ULL, 0x09d596e073a9b487ULL, 0x14583a9d7d560dafULL,
        0xf4c6dc593f2a0cb4ULL, 0xdd21d19584f80236ULL, 0x4a4836983ddde1d3ULL,
        0xe58866a41ae745f9ULL, 0xf591a5b27e541875ULL, 0x891dc05074586693ULL,
        0x5b068c651810a89eULL, 0xa30346bc0c08544fULL, 0x3dbf3751c684032dULL,
        0x2a1e86ec785032dcULL, 0xf73f5779fca830eaULL, 0xb60c05ca30204d21ULL,
        0x0cc316802b32f065ULL, 0x8770241bdd96be69ULL, 0xb861e18199ee95dbULL,
        0xf805cad91418fcd1ULL, 0x29e70dccbbd20e82ULL, 0xc7140f435060d763ULL,
        0x0f3a9da0e8b0cc3bULL, 0xa2543f574d76408eULL, 0xbd7761e1c175d139ULL,
        0x4b1f4f737ca3f512ULL, 0x6dc2df1f2fc137abULL, 0xf1d05c3967b14856ULL,
        0xa742bf3715ed046cULL, 0x654030141d1697edULL, 0x07b872abda676c7dULL,
        0x3ce84eba87fa17ecULL, 0xc1fb0403cb79afdfULL, 0x3e46bc7105063f73ULL,
        0x278ae987121cd678ULL, 0xa1adb4778ef47cd0ULL, 0x26dd906c5362c2b9ULL,
        0x05168060589b44e2ULL, 0xfbfc41f9d79ac08fULL, 0x0e6de44ba9ced8faULL,
        0x9feb08068bf243a3ULL, 0x7b341749d06b129bULL, 0x229c69e74a87929aULL,
        0xe09ee6c4427c011bULL, 0x5692e30e725c4c3aULL, 0xda99a33e5e9f6e4bULL,
        0x353dd85af453a36bULL, 0x25241b4c90e0fee7ULL, 0x5de987258309d022ULL,
        0xe230140fc0802984ULL, 0x93281e86a0c0b3c6ULL, 0xf229d719a4337408ULL,
        0x6f6c2dd4ad3d1f34ULL, 0x8ea5b2fbae3f0aeeULL, 0x8331dd90c473ee4aULL,
        0x346aa1b1b52db7aaULL, 0xdf8f235e06042aa9ULL, 0xcc6f6b68a1354b7bULL,
        0x6c95a6f46ebf236aULL, 0x52d31a856bb91c19ULL, 0x1a35ded6d498d555ULL,
        0xf37eaef2e54d60c9ULL, 0x72e181a9a3c2a61cULL, 0x98537aad51952fdeULL,
        0x16f6c856ffaa2530ULL, 0xd960281e9d1d5215ULL, 0x3a0745fa1ce36f50ULL,
        0x0b7b642bf1559c18ULL, 0x59a87eae9aec8001ULL, 0x5e100c05408bec7cULL,
        0x0441f98b19e55023ULL, 0xd70dcc5534d38aefULL, 0x927f676de1bea707ULL,
        0x9769e70db925e3e5ULL, 0x7a636ea29115065aULL, 0x468b201816ef11b6ULL,
        0xab81a9b73edff409ULL, 0xc0ac7de88a07bb1eULL, 0x1f235eb68c0391b7ULL,
        0x6056b074458dd30fULL, 0xbe8eeac102f7ed67ULL, 0xcd381283e04b5fbaULL,
        0x5cbefecec277c4e3ULL, 0xd21b4c356c48ce0dULL, 0x1019c31664b35d8cULL,
        0x247362a7d19eea26ULL, 0xebe582efb3299d03ULL, 0x02aef2cb82fc289fULL,
        0x86275df09ce8aaa8ULL, 0x28b07427faac1a43ULL, 0x38a9b7319e1f47cfULL,
        0xc82e92e3b8d01b58ULL, 0x06ef0b409b1978bcULL, 0x62f842bfc771fb90ULL,
        0x9904034610eb3b1fULL, 0xded85ab5477a3e68ULL, 0x90d195a663428f98ULL,
        0x5384636e2ac708d8ULL, 0xcbd719c37b522706ULL, 0xae9729d76644b0ebULL,
        0x7c8c65e20a0c7ee6ULL, 0x80c856b007f1d214ULL, 0x8c0b40302cc32271ULL,
        0xdbcedad51fe17a8aULL, 0x740e8ae938dbdea0ULL, 0xa615c6dc549310adULL,
        0x19cc55f6171ae90bULL, 0x49b1bdb8fe5fdd8dULL, 0xed0a89af2830e5bfULL,
        0x6a7aadb4f5a65bd6ULL, 0x7e22972988f05679ULL, 0xf952b3325566e810ULL,
        0x39fecedadf61530eULL, 0x6101c99f04f3c7ceULL, 0x2e5f7f6761b562ffULL,
        0xf08725d226cf5c97ULL, 0x63af3b54860fef51ULL, 0x8ff2cb10ef411e2fULL,
        0x884ab9bb35267252ULL, 0x4df04433e7ba8daeULL, 0x9afd8866d3690741ULL,
        0x66b9bb34de94abb3ULL, 0x9baaf18d92171380ULL, 0x543c11c5f0a064a5ULL,
        0x17a1b1bdbed431f1ULL, 0xb5f58eeaf3a2717fULL, 0xc355f6c849858740ULL,
        0xec5df044694ef17eULL, 0xd83751f5dc6346d4ULL, 0xfc4433520dfdacf2ULL,
        0x0000000000000000ULL, 0x5a51f58e596ebc5fULL, 0x3285aaf12e34cf16ULL,
        0x8d5c39db6dbd36b0ULL, 0x12b731dde64f7513ULL, 0x94906c2d7aa7dfbbULL,
        0x302b583aacc8e789ULL, 0x9d45facd090e6b3cULL, 0x2165e2c78905aec4ULL,
        0x68d45f7f775a7349ULL, 0x189b2c1d5664fdcaULL, 0xe1c99f2f030215daULL,
        0x6983269436246788ULL, 0x8489af3b1e148237ULL, 0xe94b702431d5b59cULL,
        0x33d2d31a6f4adbd7ULL, 0xbfd9932a4389f9a6ULL, 0xb0e30e8aab39359dULL,
        0xd1e2c715afcaf253ULL, 0x150f43763c28196eULL, 0xc4ed846393e2eb3dULL,
        0x03f98b20c3823c5eULL, 0xfd134ab94c83b833ULL, 0x556b682eb1de7064ULL,
        0x36c4537a37d19f35ULL, 0x7559f30279a5ca61ULL, 0x799ae58252973a04ULL,
        0x9c12832648707ffdULL, 0x78cd9c6913e92ec5ULL, 0x1d8dac7d0effb928ULL,
        0x439da0784e745554ULL, 0x413352b3cc887dcbULL, 0xbacf134a1b12bd44ULL,
        0x114ebafd25cd494dULL, 0x2f08068c20cb763eULL, 0x76a07822ba27f63fULL,
        0xeab2fb04f25789c2ULL, 0xe3676de481fe3d45ULL, 0x1b62a73d95e6c194ULL,
        0x641749ff5c68832cULL, 0xa5ec4dfc97112cf3ULL, 0xf6682e92bdd6242bULL,
        0x3f11c59a44782bb2ULL, 0x317c21d1edb6f348ULL, 0xd65ab5be75ad9e2eULL,
        0x6b2dd45fb4d84f17ULL, 0xfaab381296e4d44eULL, 0xd0b5befeeeb4e692ULL,
        0x0882ef0b32d7a046ULL, 0x512a91a5a83b2047ULL, 0x963e9ee6f85bf724ULL,
        0x4e09cf132438b1f0ULL, 0x77f701c9fb59e2feULL, 0x7ddb1c094b726a27ULL,
        0x5f4775ee01f5f8bdULL, 0x9186ec4d223c9b59ULL, 0xfeeac1998f01846dULL,
        0xac39db1ce4b89874ULL, 0xb75b7c21715e59e0ULL, 0xafc0503c273aa42aULL,
        0x6e3b543fec430bf5ULL, 0x704f7362213e8e83ULL, 0x58ff0745db9294c0ULL,
        0x67eec2df9feabf72ULL, 0xa0facd9ccf8a6811ULL, 0xb936986ad890811aULL,
        0x95c715c63bd9cb7aULL, 0xca8060283a2c33c7ULL, 0x507de84ee9453486ULL,
        0x85ded6d05f6a96f6ULL, 0x1cdad5964f81ade9ULL, 0xd5a33e9eb62fa270ULL,
        0x40642b588df6690aULL, 0x7f75eec2c98e42b8ULL, 0x2cf18dace3494a60ULL,
        0x23cb100c0bf9865bULL, 0xeef3028febb2d9e1ULL, 0x4425d2d394133929ULL,
        0xaad6d05c7fa1e0c8ULL, 0xad6ea2f7a5c68cb5ULL, 0xc2028f2308fb9381ULL,
        0x819f2f5b468fc6d5ULL, 0xc5bafd88d29cfffcULL, 0x47dc59f357910577ULL,
        0x2b49ff07392e261dULL, 0x57c59ae5332258fbULL, 0x73b6f842e2bcb2ddULL,
        0xcf96e04862b77725ULL, 0x4ca73dd8a6c4996fULL, 0x015779eb417e14c1ULL,
        0x37932a9176af8bf4ULL
    },
    {
        0x190a2c9b249df23eULL, 0x2f62f8b62263e1e9ULL, 0x7a7f754740993655ULL,
        0x330b7ba4d5564d9fULL, 0x4c17a16a46672582ULL, 0xb22f08eb7d05f5b8ULL,
        0x535f47f40bc148ccULL, 0x3aec5d27d4883037ULL, 0x10ed0a1825438f96ULL,
        0x516101f72c233d17ULL, 0x13cc6f949fd04eaeULL, 0x739853c441474bfdULL,
        0x653793d90d3f5b1bULL, 0x5240647b96b0fc2fULL, 0x0c84890ad27623e0ULL,
        0xd7189b32703aaea3ULL, 0x2685de3523bd9c41ULL, 0x99317c5b11bffefaULL,
        0x0d9baa854f079703ULL, 0x70b93648fbd48ac5ULL, 0xa80441fce30bc6beULL,
        0x7287704bdc36ff1eULL, 0xb65384ed33dc1f13ULL, 0xd36417343ee34408ULL,
        0x39cd38ab6e1bf10fULL, 0x5ab861770a1f3564ULL, 0x0ebacf09f594563bULL,
        0xd04572b884708530ULL, 0x3cae9722bdb3af47ULL, 0x4a556b6f2f5cbaf2ULL,
        0xe1704f1f76c4bd74ULL, 0x5ec4ed7144c6dfcfULL, 0x16afc01d4c7810e6ULL,
        0x283f113cd629ca7aULL, 0xaf59a8761741ed2dULL, 0xeed5a3991e215facULL,
        0x3bf37ea849f984d4ULL, 0xe413e096a56ce33cULL, 0x2c439d3a98f020d1ULL,
        0x637559dc6404c46bULL, 0x9e6c95d1e5f5d569ULL, 0x24bb9836045fe99aULL,
        0x44efa466dac8ecc9ULL, 0xc6eab2a5c80895d6ULL, 0x803b50c035220cc4ULL,
        0x0321658cba93c138ULL, 0x8f9ebc465dc7ee1cULL, 0xd15a5137190131d3ULL,
        0x0fa5ec8668e5e2d8ULL, 0x91c979578d1037b1ULL, 0x0642ca05693b9f70ULL,
        0xefca80168350eb4fULL, 0x38d21b24f36a45ecULL, 0xbeab81e1af73d658ULL,
        0x8cbfd9cae7542f24ULL, 0xfd19cc0d81f11102ULL, 0x0ac6430fbb4dbc90ULL,
        0x1d76a09d6a441895ULL, 0x2a01573ff1cbbfa1ULL, 0xb572e161894fde2bULL,
        0x8124734fa853b827ULL, 0x614b1fdf43e6b1b0ULL, 0x68ac395c4238cc18ULL,
        0x21d837bfd7f7b7d2ULL, 0x20c714304a860331ULL, 0x5cfaab726324aa14ULL,
        0x74c5ba4eb50d606eULL, 0xf3a3030474654739ULL, 0x23e671bcf015c209ULL,
        0x45f087e947b9582aULL, 0xd8bd77b418df4c7bULL, 0xe06f6c90ebb50997ULL,
        0x0bd96080263c0873ULL, 0x7e03f9410e40dcfeULL, 0xb8e94be4c6484928ULL,
        0xfb5b0608e8ca8e72ULL, 0x1a2b49179e0e3306ULL, 0x4e29e76961855059ULL,
        0x4f36c4e6fcf4e4baULL, 0x49740ee395cf7bcaULL, 0xc2963ea386d17f7dULL,
        0x90d65ad810618352ULL, 0x12d34c1b02a1fa4dULL, 0xfa44258775bb3a91ULL,
        0x18150f14b9ec46ddULL, 0x1491861e6b9a653dULL, 0x9a1019d7ab2c3fc2ULL,
        0x3668d42d06fe13d7ULL, 0xdcc1fbb25606a6d0ULL, 0x969490dd795a1c22ULL,
        0x3549b1a1bc6dd2efULL, 0xc94f5e23a0ed770eULL, 0xb9f6686b5b39fdcbULL,
        0xc4d4f4a6efeae00dULL, 0xe732851a1fff2204ULL, 0x94aad6de5eb869f9ULL,
        0x3f8ff2ae07206e7fULL, 0xfe38a9813b62d03aULL, 0xa7a1ad7a8bee2466ULL,
        0x7b6056c8dde882b6ULL, 0x302a1e286fc58ca7ULL, 0x8da0fa457a259bc7ULL,
        0xb3302b64e074415bULL, 0x5402ae7eff8b635fULL, 0x08f8050c9cafc94bULL,
        0xae468bf98a3059ceULL, 0x88c355cca98dc58fULL, 0xb10e6d67c7963480ULL,
        0xbad70de7e1aa3cf3ULL, 0xbfb4a26e320262bbULL, 0xcb711820870f02d5ULL,
        0xce12b7a954a75c9dULL, 0x563ce87dd8691684ULL, 0x9f73b65e7884618aULL,
        0x2b1e74b06cba0b42ULL, 0x47cec1ea605b2df1ULL, 0x1c698312f735ac76ULL,
        0x5fdbcefed9b76b2cULL, 0x831a354c8fb1cdfcULL, 0x820516c312c0791fULL,
        0xb74ca762aeadabf0ULL, 0xfc06ef821c80a5e1ULL, 0x5723cbf24518a267ULL,
        0x9d4df05d5f661451ULL, 0x588627742dfd40bfULL, 0xda8331b73f3d39a0ULL,
        0x17b0e392d109a405ULL, 0xf965400bcf28fba9ULL, 0x7c3dbf4229a2a925ULL,
        0x023e460327e275dbULL, 0x6cd0b55a0ce126b3ULL, 0xe62da695828e96e7ULL,
        0x42ad6e63b3f373b9ULL, 0xe50cc319381d57dfULL, 0xc5cbd729729b54eeULL,
        0x46d1e265fd2a9912ULL, 0x6428b056904eeff8ULL, 0x8be23040131e04b7ULL,
        0x6709d5da2add2ec0ULL, 0x075de98af44a2b93ULL, 0x8447dcc67bfbe66fULL,
        0x6616f655b7ac9a23ULL, 0xd607b8bded4b1a40ULL, 0x0563af89d3a85e48ULL,
        0x3db1b4ad20c21ba4ULL, 0x11f22997b8323b75ULL, 0x292032b34b587e99ULL,
        0x7f1cdace9331681dULL, 0x8e819fc9c0b65affULL, 0xa1e3677fe2d5bb16ULL,
        0xcd33d225ee349da5ULL, 0xd9a2543b85aef898ULL, 0x795e10cbfa0af76dULL,
        0x25a4bbb9992e5d79ULL, 0x78413344677b438eULL, 0xf0826688cef68601ULL,
        0xd27b34bba392f0ebULL, 0x551d8df162fad7bcULL, 0x1e57c511d0d7d9adULL,
        0xdeffbdb171e4d30bULL, 0xf4feea8e802f6caaULL, 0xa480c8f6317de55eULL,
        0xa0fc44f07fa40ff5ULL, 0x95b5f551c3c9dd1aULL, 0x22f952336d6476eaULL,
        0x0000000000000000ULL, 0xa6be8ef5169f9085ULL, 0xcc2cf1aa73452946ULL,
        0x2e7ddb39bf12550aULL, 0xd526dd3157d8db78ULL, 0x486b2d6c08becf29ULL,
        0x9b0f3a58365d8b21ULL, 0xac78cdfaadd22c15ULL, 0xbc95c7e28891a383ULL,
        0x6a927f5f65dab9c3ULL, 0xc3891d2c1ba0cb9eULL, 0xeaa92f9f50f8b507ULL,
        0xcf0d9426c9d6e87eULL, 0xca6e3baf1a7eb636ULL, 0xab25247059980786ULL,
        0x69b31ad3df4978fbULL, 0xe2512a93cc577c4cULL, 0xff278a0ea61364d9ULL,
        0x71a615c766a53e26ULL, 0x89dc764334fc716cULL, 0xf87a638452594f4aULL,
        0xf2bc208be914f3daULL, 0x8766b94ac1682757ULL, 0xbbc82e687cdb8810ULL,
        0x626a7a53f9757088ULL, 0xa2c202f358467a2eULL, 0x4d0882e5db169161ULL,
        0x09e7268301de7da8ULL, 0xe897699c771ac0dcULL, 0xc8507dac3d9cc3edULL,
        0xc0a878a0a1330aa6ULL, 0x978bb352e42ba8c1ULL, 0xe9884a13ea6b743fULL,
        0x279afdbabecc28a2ULL, 0x047c8c064ed9eaabULL, 0x507e2278b15289f4ULL,
        0x599904fbb08cf45cULL, 0xbd8ae46d15e01760ULL, 0x31353da7f2b43844ULL,
        0x8558ff49e68a528cULL, 0x76fbfc4d92ef15b5ULL, 0x3456922e211c660cULL,
        0x86799ac55c1993b4ULL, 0x3e90d1219a51da9cULL, 0x2d5cbeb505819432ULL,
        0x982e5fd48cce4a19ULL, 0xdb9c1238a24c8d43ULL, 0xd439febecaa96f9bULL,
        0x418c0bef0960b281ULL, 0x158ea591f6ebd1deULL, 0x1f48e69e4da66d4eULL,
        0x8afd13cf8e6fb054ULL, 0xf5e1c9011d5ed849ULL, 0xe34e091c5126c8afULL,
        0xad67ee7530a398f6ULL, 0x43b24dec2e82c75aULL, 0x75da99c1287cd48dULL,
        0x92e81cdb3783f689ULL, 0xa3dd217cc537cecdULL, 0x60543c50de970553ULL,
        0x93f73f54aaf2426aULL, 0xa91b62737e7a725dULL, 0xf19d4507538732e2ULL,
        0x77e4dfc20f9ea156ULL, 0x7d229ccdb4d31dc6ULL, 0x1b346a98037f87e5ULL,
        0xedf4c615a4b29e94ULL, 0x4093286094110662ULL, 0xb0114ee85ae78063ULL,
        0x6ff1d0d6b672e78bULL, 0x6dcf96d591909250ULL, 0xdfe09e3eec9567e8ULL,
        0x3214582b4827f97cULL, 0xb46dc2ee143e6ac8ULL, 0xf6c0ac8da7cd1971ULL,
        0xebb60c10cd8901e4ULL, 0xf7df8f023abcad92ULL, 0x9c52d3d2c217a0b2ULL,
        0x6b8d5cd0f8ab0d20ULL, 0x3777f7a29b8fa734ULL, 0x011f238f9d71b4e3ULL,
        0xc1b75b2f3c42be45ULL, 0x5de588fdfe551ef7ULL, 0x6eeef3592b035368ULL,
        0xaa3a07ffc4e9b365ULL, 0xecebe59a39c32a77ULL, 0x5ba742f8976e8187ULL,
        0x4b4a48e0b22d0e11ULL, 0xddded83dcb771233ULL, 0xa59feb79ac0c51bdULL,
        0xc7f5912a55792135ULL
    },
    {
        0x6d6ae04668a9b08aULL, 0x3ab3f04b0be8c743ULL, 0xe51e166b54b3c908ULL,
        0xbe90a9eb35c2f139ULL, 0xb2c7066637f2bec1ULL, 0xaa6945613392202cULL,
        0x9a28c36f3b5201ebULL, 0xddce5a93ab536994ULL, 0x0e34133ef6382827ULL,
        0x52a02ba1ec55048bULL, 0xa2f88f97c4b2a177ULL, 0x8640e513ca2251a5ULL,
        0xcdf1d36258137622ULL, 0xfe6cb708dedf8ddbULL, 0x8a174a9ec8121e5dULL,
        0x679896036b81560eULL, 0x59ed033395795feeULL, 0x1dd778ab8b74edafULL,
        0xee533ef92d9f926dULL, 0x2a8c79baf8a8d8f5ULL, 0x6bcf398e69b119f6ULL,
        0xe20491742fafdd95ULL, 0x276488e0809c2aecULL, 0xea955b82d88f5cceULL,
        0x7102c63a99d9e0c4ULL, 0xf9763017a5c39946ULL, 0x429fa2501f151b3dULL,
        0x4659c72bea05d59eULL, 0x984b7fdccf5a6634ULL, 0xf742232953fbb161ULL,
        0x3041860e08c021c7ULL, 0x747bfd9616cd9386ULL, 0x4bb1367192312787ULL,
        0x1b72a1638a6c44d3ULL, 0x4a0e68a6e8359a66ULL, 0x169a5039f258b6caULL,
        0xb98a2ef44edee5a4ULL, 0xd9083fe85e43a737ULL, 0x967f6ce239624e13ULL,
        0x8874f62d3c1a7982ULL, 0x3c1629830af06e3fULL, 0x9165ebfd427e5a8eULL,
        0xb5dd81794ceeaa5cULL, 0x0de8f15a7834f219ULL, 0x70bd98ede3dd5d25ULL,
        0xaccc9ca9328a8950ULL, 0x56664eda1945ca28ULL, 0x221db34c0f8859aeULL,
        0x26dbd637fa98970dULL, 0x1acdffb4f068f932ULL, 0x4585254f64090fa0ULL,
        0x72de245e17d53afaULL, 0x1546b25d7c546cf4ULL, 0x207e0ffffb803e71ULL,
        0xfaaad2732bcf4378ULL, 0xb462dfae36ea17bdULL, 0xcf926fd1ac1b11fdULL,
        0xe0672dc7dba7ba4aULL, 0xd3fa49ad5d6b41b3ULL, 0x8ba81449b216a3bcULL,
        0x14f9ec8a0650d115ULL, 0x40fc1ee3eb1d7ce2ULL, 0x23a2ed9b758ce44fULL,
        0x782c521b14fddc7eULL, 0x1c68267cf170504eULL, 0xbcf31558c1ca96e6ULL,
        0xa781b43b4ba6d235ULL, 0xf6fd7dfe29ff0c80ULL, 0xb0a4bad5c3fad91eULL,
        0xd199f51ea963266cULL, 0x414340349119c103ULL, 0x5405f269ed4dadf7ULL,
        0xabd61bb649969dcdULL, 0x6813dbeae7bdc3c8ULL, 0x65fb2ab09f8931d1ULL,
        0xf1e7fae152e3181dULL, 0xc1a67cef5a2339daULL, 0x7a4feea8e0f5bba1ULL,
        0x1e0b9acf05783791ULL, 0x5b8ebf8061713831ULL, 0x80e53cdbcb3af8d9ULL,
        0x7e898bd315e57502ULL, 0xc6bcfbf0213f2d47ULL, 0x95a38e86b76e942dULL,
        0x092e94218d243cbaULL, 0x8339debf453622e7ULL, 0xb11be402b9fe64ffULL,
        0x57d9100d634177c9ULL, 0xcc4e8db52217cbc3ULL, 0x3b0cae9c71ec7aa2ULL,
        0xfb158ca451cbfe99ULL, 0x2b33276d82ac6514ULL, 0x01bf5ed77a04bde1ULL,
        0xc5601994af33f779ULL, 0x75c4a3416cc92e67ULL, 0xf3844652a6eb7fc2ULL,
        0x3487e375fdd0ef64ULL, 0x18ae430704609eedULL, 0x4d14efb993298efbULL,
        0x815a620cb13e4538ULL, 0x125c354207487869ULL, 0x9eeea614ce42cf48ULL,
        0xce2d3106d61fac1cULL, 0xbbe99247bad6827bULL, 0x071a871f7b1c149dULL,
        0x2e4a1cc10db81656ULL, 0x77a71ff298c149b8ULL, 0x06a5d9c80118a97cULL,
        0xad73c27e488e34b1ULL, 0x443a7b981e0db241ULL, 0xe3bbcfa355ab6074ULL,
        0x0af276450328e684ULL, 0x73617a896dd1871bULL, 0x58525de4ef7de20fULL,
        0xb7be3dcab8e6cd83ULL, 0x19111dd07e64230cULL, 0x842359a03e2a367aULL,
        0x103f89f1f3401fb6ULL, 0xdc710444d157d475ULL, 0xb835702334da5845ULL,
        0x4320fc876511a6dcULL, 0xd026abc9d3679b8dULL, 0x17250eee885c0b2bULL,
        0x90dab52a387ae76fULL, 0x31fed8d972c49c26ULL, 0x89cba8fa461ec463ULL,
        0x2ff5421677bcabb7ULL, 0x396f122f85e41d7dULL, 0xa09b332430bac6a8ULL,
        0xc888e8ced7070560ULL, 0xaeaf201ac682ee8fULL, 0x1180d7268944a257ULL,
        0xf058a43628e7a5fcULL, 0xbd4c4b8fbbce2b07ULL, 0xa1246df34abe7b49ULL,
        0x7d5569b79be9af3cULL, 0xa9b5a705bd9efa12ULL, 0xdb6b835baa4bc0e8ULL,
        0x05793bac8f147342ULL, 0x21c1512881848390ULL, 0xfdb0556c50d357e5ULL,
        0x613d4fcb6a99ff72ULL, 0x03dce2648e0cda3eULL, 0xe949b9e6568386f0ULL,
        0xfc0f0bbb2ad7ea04ULL, 0x6a70675913b5a417ULL, 0x7f36d5046fe1c8e3ULL,
        0x0c57af8d02304ff8ULL, 0x32223abdfcc84618ULL, 0x0891caf6f720815bULL,
        0xa63eeaec31a26fd4ULL, 0x2507345374944d33ULL, 0x49d28ac266394058ULL,
        0xf5219f9aa7f3d6beULL, 0x2d96fea583b4cc68ULL, 0x5a31e1571b7585d0ULL,
        0x8ed12fe53d02d0feULL, 0xdfade6205f5b0e4bULL, 0x4cabb16ee92d331aULL,
        0x04c6657bf510cea3ULL, 0xd73c2cd6a87b8f10ULL, 0xe1d87310a1a307abULL,
        0x6cd5be9112ad0d6bULL, 0x97c032354366f3f2ULL, 0xd4e0ceb22677552eULL,
        0x0000000000000000ULL, 0x29509bde76a402cbULL, 0xc27a9e8bd42fe3e4ULL,
        0x5ef7842cee654b73ULL, 0xaf107ecdbc86536eULL, 0x3fcacbe784fcb401ULL,
        0xd55f90655c73e8cfULL, 0xe6c2f40fdabf1336ULL, 0xe8f6e7312c873b11ULL,
        0xeb2a0555a28be12fULL, 0xe4a148bc2eb774e9ULL, 0x9b979db84156bc0aULL,
        0x6eb60222e6a56ab4ULL, 0x87ffbbc4b026ec44ULL, 0xc703a5275b3b90a6ULL,
        0x47e699fc9001687fULL, 0x9c8d1aa73a4aa897ULL, 0x7cea3760e1ed12ddULL,
        0x4ec80ddd1d2554c5ULL, 0x13e36b957d4cc588ULL, 0x5d2b66486069914dULL,
        0x92b90999cc7280b0ULL, 0x517cc9c56259deb5ULL, 0xc937b619ad03b881ULL,
        0xec30824ad997f5b2ULL, 0xa45d565fc5aa080bULL, 0xd6837201d27f32f1ULL,
        0x635ef3789e9198adULL, 0x531f75769651b96aULL, 0x4f77530a6721e924ULL,
        0x486dd4151c3dfdb9ULL, 0x5f48dafb9461f692ULL, 0x375b011173dc355aULL,
        0x3da9775470f4d3deULL, 0x8d0dcd81b30e0ac0ULL, 0x36e45fc609d888bbULL,
        0x55baacbe97491016ULL, 0x8cb29356c90ab721ULL, 0x76184125e2c5f459ULL,
        0x99f4210bb55edbd5ULL, 0x6f095cf59ca1d755ULL, 0x9f51f8c3b44672a9ULL,
        0x3538bda287d45285ULL, 0x50c39712185d6354ULL, 0xf23b1885dcefc223ULL,
        0x79930ccc6ef9619fULL, 0xed8fdc9da3934853ULL, 0xcb540aaa590bdf5eULL,
        0x5c94389f1a6d2cacULL, 0xe77daad8a0bbaed7ULL, 0x28efc5090ca0bf2aULL,
        0xbf2ff73c4fc64cd8ULL, 0xb37858b14df60320ULL, 0xf8c96ec0dfc724a7ULL,
        0x828680683f329f06ULL, 0x941cd051cd6a29ccULL, 0xc3c5c05cae2b5e05ULL,
        0xb601631dc2e27062ULL, 0xc01922382027843bULL, 0x24b86a840e90f0d2ULL,
        0xd245177a276ffc52ULL, 0x0f8b4de98c3c95c6ULL, 0x3e759530fef809e0ULL,
        0x0b4d2892792c5b65ULL, 0xc4df4743d5374a98ULL, 0xa5e20888bfaeb5eaULL,
        0xba56cc90c0d23f9aULL, 0x38d04cf8ffe0a09cULL, 0x62e1adafe495254cULL,
        0x0263bcb3f40867dfULL, 0xcaeb547d230f62bfULL, 0x6082111c109d4293ULL,
        0xdad4dd8cd04f7d09ULL, 0xefec602e579b2f8cULL, 0x1fb4c4187f7c8a70ULL,
        0xffd3e9dfa4db303aULL, 0x7bf0b07f9af10640ULL, 0xf49ec14dddf76b5fULL,
        0x8f6e713247066d1fULL, 0x339d646a86ccfbf9ULL, 0x64447467e58d8c30ULL,
        0x2c29a072f9b07189ULL, 0xd8b7613f24471ad6ULL, 0x6627c8d41185ebefULL,
        0xa347d140beb61c96ULL, 0xde12b8f7255fb3aaULL, 0x9d324470404e1576ULL,
        0x9306574eb6763d51ULL, 0xa80af9d2c79a47f3ULL, 0x859c0777442e8b9bULL,
        0x69ac853d9db97e29ULL
    },
    {
        0xc3407dfc2de6377eULL, 0x5b9e93eea4256f77ULL, 0xadb58fdd50c845e0ULL,
        0x5219ff11a75bed86ULL, 0x356b61cfd90b1de9ULL, 0xfb8f406e25abe037ULL,
        0x7a5a0231c0f60796ULL, 0x9d3cd216e1f5020bULL, 0x0c6550fb6b48d8f3ULL,
        0xf57508c427ff1c62ULL, 0x4ad35ffa71cb407dULL, 0x6290a2da1666aa6dULL,
        0xe284ec2349355f9fULL, 0xb3c307c53d7c84ecULL, 0x05e23c0468365a02ULL,
        0x190bac4d6c9ebfa8ULL, 0x94bbbee9e28b80faULL, 0xa34fc777529cb9b5ULL,
        0xcc7b39f095bcd978ULL, 0x2426addb0ce532e3ULL, 0x7e79329312ce4fc7ULL,
        0xab09a72eebec2917ULL, 0xf8d15499f6b9d6c2ULL, 0x1a55b8babf8c895dULL,
        0xdb8add17fb769a85ULL, 0xb57f2f368658e81bULL, 0x8acd36f18f3f41f6ULL,
        0x5ce3b7bba50f11d3ULL, 0x114dcc14d5ee2f0aULL, 0xb91a7fcded1030e8ULL,
        0x81d5425fe55de7a1ULL, 0xb6213bc1554adeeeULL, 0x80144ef95f53f5f2ULL,
        0x1e7688186db4c10cULL, 0x3b912965db5fe1bcULL, 0xc281715a97e8252dULL,
        0x54a5d7e21c7f8171ULL, 0x4b12535ccbc5522eULL, 0x1d289cefbea6f7f9ULL,
        0x6ef5f2217d2e729eULL, 0xe6a7dc819b0d17ceULL, 0x1b94b41c05829b0eULL,
        0x33d7493c622f711eULL, 0xdcf7f942fa5ce421ULL, 0x600fba8b7f7a8ecbULL,
        0x46b60f011a83988eULL, 0x235b898e0dcf4c47ULL, 0x957ab24f588592a9ULL,
        0x4354330572b5c28cULL, 0xa5f3ef84e9b8d542ULL, 0x8c711e02341b2d01ULL,
        0x0b1874ae6a62a657ULL, 0x1213d8e306fc19ffULL, 0xfe6d7c6a4d9dba35ULL,
        0x65ed868f174cd4c9ULL, 0x88522ea0e6236550ULL, 0x899322065c2d7703ULL,
        0xc01e690bfef4018bULL, 0x915982ed8abddaf8ULL, 0xbe675b98ec3a4e4cULL,
        0xa996bf7f82f00db1ULL, 0xe1daf8d49a27696aULL, 0x2effd5d3dc8986e7ULL,
        0xd153a51f2b1a2e81ULL, 0x18caa0ebd690adfbULL, 0x390e3134b243c51aULL,
        0x2778b92cdff70416ULL, 0x029f1851691c24a6ULL, 0x5e7cafeacc133575ULL,
        0xfa4e4cc89fa5f264ULL, 0x5a5f9f481e2b7d24ULL, 0x484c47ab18d764dbULL,
        0x400a27f2a1a7f479ULL, 0xaeeb9b2a83da7315ULL, 0x721c626879869734ULL,
        0x042330a2d2384851ULL, 0x85f672fd3765aff0ULL, 0xba446b3a3e02061dULL,
        0x73dd6ecec3888567ULL, 0xffac70ccf793a866ULL, 0xdfa9edb5294ed2d4ULL,
        0x6c6aea7014325638ULL, 0x834a5a0e8c41c307ULL, 0xcdba35562fb2cb2bULL,
        0x0ad97808d06cb404ULL, 0x0f3b440cb85aee06ULL, 0xe5f9c876481f213bULL,
        0x98deee1289c35809ULL, 0x59018bbfcd394bd1ULL, 0xe01bf47220297b39ULL,
        0xde68e1139340c087ULL, 0x9fa3ca4788e926adULL, 0xbb85679c840c144eULL,
        0x53d8f3b71d55ffd5ULL, 0x0da45c5dd146caa0ULL, 0x6f34fe87c72060cdULL,
        0x57fbc315cf6db784ULL, 0xcee421a1fca0fddeULL, 0x3d2d0196607b8d4bULL,
        0x642c8a29ad42c69aULL, 0x14aff010bdd87508ULL, 0xac74837beac657b3ULL,
        0x3216459ad821634dULL, 0x3fb219c70967a9edULL, 0x06bc28f3bb246cf7ULL,
        0xf2082c9126d562c6ULL, 0x66b39278c45ee23cULL, 0xbd394f6f3f2878b9ULL,
        0xfd33689d9e8f8cc0ULL, 0x37f4799eb017394fULL, 0x108cc0b26fe03d59ULL,
        0xda4bd1b1417888d6ULL, 0xb09d1332ee6eb219ULL, 0x2f3ed975668794b4ULL,
        0x58c0871977375982ULL, 0x7561463d78ace990ULL, 0x09876cff037e82f1ULL,
        0x7fb83e35a8c05d94ULL, 0x26b9b58a65f91645ULL, 0xef20b07e9873953fULL,
        0x3148516d0b3355b8ULL, 0x41cb2b541ba9e62aULL, 0x790416c613e43163ULL,
        0xa011d380818e8f40ULL, 0x3a5025c36151f3efULL, 0xd57095bdf92266d0ULL,
        0x498d4b0da2d97688ULL, 0x8b0c3a57353153a5ULL, 0x21c491df64d368e1ULL,
        0x8f2f0af5e7091bf4ULL, 0x2da1c1240f9bb012ULL, 0xc43d59a92ccc49daULL,
        0xbfa6573e56345c1fULL, 0x828b56a8364fd154ULL, 0x9a41f643e0df7cafULL,
        0xbcf843c985266aeaULL, 0x2b1de9d7b4bfdce5ULL, 0x20059d79dedd7ab2ULL,
        0x6dabe6d6ae3c446bULL, 0x45e81bf6c991ae7bULL, 0x6351ae7cac68b83eULL,
        0xa432e32253b6c711ULL, 0xd092a9b991143cd2ULL, 0xcac711032e98b58fULL,
        0xd8d4c9e02864ac70ULL, 0xc5fc550f96c25b89ULL, 0xd7ef8dec903e4276ULL,
        0x67729ede7e50f06fULL, 0xeac28c7af045cf3dULL, 0xb15c1f945460a04aULL,
        0x9cfddeb05bfb1058ULL, 0x93c69abce3a1fe5eULL, 0xeb0380dc4a4bdd6eULL,
        0xd20db1e8f8081874ULL, 0x229a8528b7c15e14ULL, 0x44291750739fbc28ULL,
        0xd3ccbd4e42060a27ULL, 0xf62b1c33f4ed2a97ULL, 0x86a8660ae4779905ULL,
        0xd62e814a2a305025ULL, 0x477703a7a08d8addULL, 0x7b9b0e977af815c5ULL,
        0x78c51a60a9ea2330ULL, 0xa6adfb733aaae3b7ULL, 0x97e5aa1e3199b60fULL,
        0x0000000000000000ULL, 0xf4b404629df10e31ULL, 0x5564db44a6719322ULL,
        0x9207961a59afec0dULL, 0x9624a6b88b97a45cULL, 0x363575380a192b1cULL,
        0x2c60cd82b595a241ULL, 0x7d272664c1dc7932ULL, 0x7142769faa94a1c1ULL,
        0xa1d0df263b809d13ULL, 0x1630e841d4c451aeULL, 0xc1df65ad44fa13d8ULL,
        0x13d2d445bcf20bacULL, 0xd915c546926abe23ULL, 0x38cf3d92084dd749ULL,
        0xe766d0272103059dULL, 0xc7634d5effde7f2fULL, 0x077d2455012a7ea4ULL,
        0xedbfa82ff16fb199ULL, 0xaf2a978c39d46146ULL, 0x42953fa3c8bbd0dfULL,
        0xcb061da59496a7dcULL, 0x25e7a17db6eb20b0ULL, 0x34aa6d6963050fbaULL,
        0xa76cf7d580a4f1e4ULL, 0xf7ea10954ee338c4ULL, 0xfcf2643b24819e93ULL,
        0xcf252d0746aeef8dULL, 0x4ef06f58a3f3082cULL, 0x563acfb37563a5d7ULL,
        0x5086e740ce47c920ULL, 0x2982f186dda3f843ULL, 0x87696aac5e798b56ULL,
        0x5d22bb1d1f010380ULL, 0x035e14f7d31236f5ULL, 0x3cec0d30da759f18ULL,
        0xf3c920379cdb7095ULL, 0xb8db736b571e22bbULL, 0xdd36f5e44052f672ULL,
        0xaac8ab8851e23b44ULL, 0xa857b3d938fe1fe2ULL, 0x17f1e4e76eca43fdULL,
        0xec7ea4894b61a3caULL, 0x9e62c6e132e734feULL, 0xd4b1991b432c7483ULL,
        0x6ad6c283af163acfULL, 0x1ce9904904a8e5aaULL, 0x5fbda34c761d2726ULL,
        0xf910583f4cb7c491ULL, 0xc6a241f845d06d7cULL, 0x4f3163fe19fd1a7fULL,
        0xe99c988d2357f9c8ULL, 0x8eee06535d0709a7ULL, 0x0efa48aa0254fc55ULL,
        0xb4be23903c56fa48ULL, 0x763f52caabbedf65ULL, 0xeee1bcd8227d876cULL,
        0xe345e085f33b4dccULL, 0x3e731561b369bbbeULL, 0x2843fd2067adea10ULL,
        0x2adce5710eb1ceb6ULL, 0xb7e03767ef44ccbdULL, 0x8db012a48e153f52ULL,
        0x61ceb62dc5749c98ULL, 0xe85d942b9959eb9bULL, 0x4c6f7709caef2c8aULL,
        0x84377e5b8d6bbda3ULL, 0x30895dcbb13d47ebULL, 0x74a04a9bc2a2fbc3ULL,
        0x6b17ce251518289cULL, 0xe438c4d0f2113368ULL, 0x1fb784bed7bad35fULL,
        0x9b80fae55ad16efcULL, 0x77fe5e6c11b0cd36ULL, 0xc858095247849129ULL,
        0x08466059b97090a2ULL, 0x01c10ca6ba0e1253ULL, 0x6988d6747c040c3aULL,
        0x6849dad2c60a1e69ULL, 0x5147ebe67449db73ULL, 0xc99905f4fd8a837aULL,
        0x991fe2b433cd4a5aULL, 0xf09734c04fc94660ULL, 0xa28ecbd1e892abe6ULL,
        0xf1563866f5c75433ULL, 0x4dae7baf70e13ed9ULL, 0x7ce62ac27bd26b61ULL,
        0x70837a39109ab392ULL, 0x90988e4b30b3c8abULL, 0xb2020b63877296bfULL,
        0x156efcb607d6675bULL
    },
    {
        0xe63f55ce97c331d0ULL, 0x25b506b0015bba16ULL, 0xc8706e29e6ad9ba8ULL,
        0x5b43d3775d521f6aULL, 0x0bfa3d577035106eULL, 0xab95fc172afb0e66ULL,
        0xf64b63979e7a3276ULL, 0xf58b4562649dad4bULL, 0x48f7c3dbae0c83f1ULL,
        0xff31916642f5c8c5ULL, 0xcbb048dc1c4a0495ULL, 0x66b8f83cdf622989ULL,
        0x35c130e908e2b9b0ULL, 0x7c761a61f0b34fa1ULL, 0x3601161cf205268dULL,
        0x9e54ccfe2219b7d6ULL, 0x8b7d90a538940837ULL, 0x9cd403588ea35d0bULL,
        0xbc3c6fea9ccc5b5aULL, 0xe5ff733b6d24aeedULL, 0xceed22de0f7eb8d2ULL,
        0xec8581cab1ab545eULL, 0xb96105e88ff8e71dULL, 0x8ca03501871a5eadULL,
        0x76ccce65d6db2a2fULL, 0x5883f582a7b58057ULL, 0x3f7be4ed2e8adc3eULL,
        0x0fe7be06355cd9c9ULL, 0xee054e6c1d11be83ULL, 0x1074365909b903a6ULL,
        0x5dde9f80b4813c10ULL, 0x4a770c7d02b6692cULL, 0x5379c8d5d7809039ULL,
        0xb4067448161ed409ULL, 0x5f5e5026183bd6cdULL, 0xe898029bf4c29df9ULL,
        0x7fb63c940a54d09cULL, 0xc5171f897f4ba8bcULL, 0xa6f28db7b31d3d72ULL,
        0x2e4f3be7716eaa78ULL, 0x0d6771a099e63314ULL, 0x82076254e41bf284ULL,
        0x2f0fd2b42733df98ULL, 0x5c9e76d3e2dc49f0ULL, 0x7aeb569619606cdbULL,
        0x83478b07b2468764ULL, 0xcfadcb8d5923cd32ULL, 0x85dac7f05b95a41eULL,
        0xb5469d1b4043a1e9ULL, 0xb821ecbbd9a592fdULL, 0x1b8e0b0e798c13c8ULL,
        0x62a57b6d9a0be02eULL, 0xfcf1b793b81257f8ULL, 0x9d94ea0bd8fe28ebULL,
        0x4cea408aeb654a56ULL, 0x23284a47e888996cULL, 0x2d8f1d128b893545ULL,
        0xf4cbac3132c0d8abULL, 0xbd7c86b9ca912ebaULL, 0x3a268eef3dbe6079ULL,
        0xf0d62f6077a9110cULL, 0x2735c916ade150cbULL, 0x89fd5f03942ee2eaULL,
        0x1acee25d2fd16628ULL, 0x90f39bab41181bffULL, 0x430dfe8cde39939fULL,
        0xf70b8ac4c8274796ULL, 0x1c53aeaac6024552ULL, 0x13b410acf35e9c9bULL,
        0xa532ab4249faa24fULL, 0x2b1251e5625a163fULL, 0xd7e3e676da4841c7ULL,
        0xa7b264e4e5404892ULL, 0xda8497d643ae72d3ULL, 0x861ae105a1723b23ULL,
        0x38a6414991048aa4ULL, 0x6578dec92585b6b4ULL, 0x0280cfa6acbaeaddULL,
        0x88bdb650c273970aULL, 0x9333bd5ebbff84c2ULL, 0x4e6a8f2c47dfa08bULL,
        0x321c954db76cef2aULL, 0x418d312a72837942ULL, 0xb29b38bfffcdf773ULL,
        0x6c022c38f90a4c07ULL, 0x5a033a240b0f6a8aULL, 0x1f93885f3ce5da6fULL,
        0xc38a537e96988bc6ULL, 0x39e6a81ac759ff44ULL, 0x29929e43cee0fce2ULL,
        0x40cdd87924de0ca2ULL, 0xe9d8ebc8a29fe819ULL, 0x0c2798f3cfbb46f4ULL,
        0x55e484223e53b343ULL, 0x4650948ecd0d2fd8ULL, 0x20e86cb2126f0651ULL,
        0x6d42c56baf5739e7ULL, 0xa06fc1405ace1e08ULL, 0x7babbfc54f3d193bULL,
        0x424d17df8864e67fULL, 0xd8045870ef14980eULL, 0xc6d7397c85ac3781ULL,
        0x21a885e1443273b1ULL, 0x67f8116f893f5c69ULL, 0x24f5efe35706cff6ULL,
        0xd56329d076f2ab1aULL, 0x5e1eb9754e66a32dULL, 0x28d2771098bd8902ULL,
        0x8f6013f47dfdc190ULL, 0x17a993fdb637553cULL, 0xe0a219397e1012aaULL,
        0x786b9930b5da8606ULL, 0x6e82e39e55b0a6daULL, 0x875a0856f72f4ec3ULL,
        0x3741ff4fa458536dULL, 0xac4859b3957558fcULL, 0x7ef6d5c75c09a57cULL,
        0xc04a758b6c7f14fbULL, 0xf9acdd91ab26ebbfULL, 0x7391a467c5ef9668ULL,
        0x335c7c1ee1319acaULL, 0xa91533b18641e4bbULL, 0xe4bf9a683b79db0dULL,
        0x8e20faa72ba0b470ULL, 0x51f907737b3a7ae4ULL, 0x2268a314bed5ec8cULL,
        0xd944b123b949edeeULL, 0x31dcb3b84d8b7017ULL, 0xd3fe65279f218860ULL,
        0x097af2f1dc8ffab3ULL, 0x9b09a6fc312d0b91ULL, 0xcc6ded78a3c4520fULL,
        0x3481d9ba5ebfcc50ULL, 0x4f2a667f1182d56bULL, 0xdfd9fdd4509ace94ULL,
        0x26752045fbbc252bULL, 0xbffc491f662bc467ULL, 0xdd593272fc202449ULL,
        0x3cbbc218d46d4303ULL, 0x91b372f817456e1fULL, 0x681faf69bc6385a0ULL,
        0xb686bbeebaa43ed4ULL, 0x1469b5084cd0ca01ULL, 0x98c98009cbca94acULL,
        0x6438379a73d8c354ULL, 0xc2caba2dc0c5fe26ULL, 0x3e3b0dbe78d7a9deULL,
        0x50b9ee202d670f04ULL, 0x4590b27b37eab0e5ULL, 0x6025b4cb36b10af3ULL,
        0xfb2c1237079c0162ULL, 0xa12f28130c936be8ULL, 0x4b37e52e54eb1cccULL,
        0x083a1ba28ad28f53ULL, 0xc10a9cd83a22611bULL, 0x9f1425ad7444c236ULL,
        0x069d4cf7e9d3237aULL, 0xedc56899e7f621beULL, 0x778c273680865fcfULL,
        0x309c5aeb1bd605f7ULL, 0x8de0dc52d1472b4dULL, 0xf8ec34c2fd7b9e5fULL,
        0xea18cd3d58787724ULL, 0xaad515447ca67b86ULL, 0x9989695a9d97e14cULL,
        0x0000000000000000ULL, 0xf196c63321f464ecULL, 0x71116bc169557cb5ULL,
        0xaf887f466f92c7c1ULL, 0x972e3e0ffe964d65ULL, 0x190ec4a8d536f915ULL,
        0x95aef1a9522ca7b8ULL, 0xdc19db21aa7d51a9ULL, 0x94ee18fa0471d258ULL,
        0x8087adf248a11859ULL, 0xc457f6da2916dd5cULL, 0xfa6cfb6451c17482ULL,
        0xf256e0c6db13fbd1ULL, 0x6a9f60cf10d96f7dULL, 0x4daaa9d9bd383fb6ULL,
        0x03c026f5fae79f3dULL, 0xde99148706c7bb74ULL, 0x2a52b8b6340763dfULL,
        0x6fc20acd03edd33aULL, 0xd423c08320afdefaULL, 0xbbe1ca4e23420dc0ULL,
        0x966ed75ca8cb3885ULL, 0xeb58246e0e2502c4ULL, 0x055d6a021334bc47ULL,
        0xa47242111fa7d7afULL, 0xe3623fcc84f78d97ULL, 0x81c744a11efc6db9ULL,
        0xaec8961539cfb221ULL, 0xf31609958d4e8e31ULL, 0x63e5923ecc5695ceULL,
        0x47107ddd9b505a38ULL, 0xa3afe7b5a0298135ULL, 0x792b7063e387f3e6ULL,
        0x0140e953565d75e0ULL, 0x12f4f9ffa503e97bULL, 0x750ce8902c3cb512ULL,
        0xdbc47e8515f30733ULL, 0x1ed3610c6ab8af8fULL, 0x5239218681dde5d9ULL,
        0xe222d69fd2aaf877ULL, 0xfe71783514a8bd25ULL, 0xcaf0a18f4a177175ULL,
        0x61655d9860ec7f13ULL, 0xe77fbc9dc19e4430ULL, 0x2ccff441ddd440a5ULL,
        0x16e97aaee06a20dcULL, 0xa855dae2d01c915bULL, 0x1d1347f9905f30b2ULL,
        0xb7c652bdecf94b34ULL, 0xd03e43d265c6175dULL, 0xfdb15ec0ee4f2218ULL,
        0x57644b8492e9599eULL, 0x07dda5a4bf8e569aULL, 0x54a46d71680ec6a3ULL,
        0x5624a2d7c4b42c7eULL, 0xbebca04c3076b187ULL, 0x7d36f332a6ee3a41ULL,
        0x3b6667bc6be31599ULL, 0x695f463aea3ef040ULL, 0xad08b0e0c3282d1cULL,
        0xb15b1e4a052a684eULL, 0x44d05b2861b7c505ULL, 0x15295c5b1a8dbfe1ULL,
        0x744c01c37a61c0f2ULL, 0x59c31cd1f1e8f5b7ULL, 0xef45a73f4b4ccb63ULL,
        0x6bdf899c46841a9dULL, 0x3dfb2b4b823036e3ULL, 0xa2ef0ee6f674f4d5ULL,
        0x184e2dfb836b8cf5ULL, 0x1134df0a5fe47646ULL, 0xbaa1231d751f7820ULL,
        0xd17eaa81339b62bdULL, 0xb01bf71953771daeULL, 0x849a2ea30dc8d1feULL,
        0x705182923f080955ULL, 0x0ea757556301ac29ULL, 0x041d83514569c9a7ULL,
        0x0abad4042668658eULL, 0x49b72a88f851f611ULL, 0x8a3d79f66ec97dd7ULL,
        0xcd2d042bf59927efULL, 0xc930877ab0f0ee48ULL, 0x9273540deda2f122ULL,
        0xc797d02fd3f14261ULL, 0xe1e2f06a284d674aULL, 0xd2be8c74c97cfd80ULL,
        0x9a494faf67707e71ULL, 0xb3dbd1eca9908293ULL, 0x72d14d3493b2e388ULL,
        0xd6a30f258c153427ULL
    }
};
#else
ALIGN(16) static const unsigned long long Ax[8][256] =
{
    {
        0xe6f87e5c5b711fd0ULL, 0x258377800924fa16ULL, 0xc849e07e852ea4a8ULL,
        0x5b4686a18f06c16aULL, 0x0b32e9a2d77b416eULL, 0xabda37a467815c66ULL,
        0xf61796a81a686676ULL, 0xf5dc0b706391954bULL, 0x4862f38db7e64bf1ULL,
        0xff5c629a68bd85c5ULL, 0xcb827da6fcd75795ULL, 0x66d36daf69b9f089ULL,
        0x356c9f74483d83b0ULL, 0x7cbcecb1238c99a1ULL, 0x36a702ac31c4708dULL,
        0x9eb6a8d02fbcdfd6ULL, 0x8b19fa51e5b3ae37ULL, 0x9ccfb5408a127d0bULL,
        0xbc0c78b508208f5aULL, 0xe533e3842288ecedULL, 0xcec2c7d377c15fd2ULL,
        0xec7817b6505d0f5eULL, 0xb94cc2c08336871dULL, 0x8c205db4cb0b04adULL,
        0x763c855b28a0892fULL, 0x588d1b79f6ff3257ULL, 0x3fecf69e4311933eULL,
        0x0fc0d39f803a18c9ULL, 0xee010a26f5f3ad83ULL, 0x10efe8f4411979a6ULL,
        0x5dcda10c7de93a10ULL, 0x4a1bee1d1248e92cULL, 0x53bff2db21847339ULL,
        0xb4f50ccfa6a23d09ULL, 0x5fb4bc9cd84798cdULL, 0xe88a2d8b071c56f9ULL,
        0x7f7771695a756a9cULL, 0xc5f02e71a0ba1ebcULL, 0xa663f9ab4215e672ULL,
        0x2eb19e22de5fbb78ULL, 0x0db9ce0f2594ba14ULL, 0x82520e6397664d84ULL,
        0x2f031e6a0208ea98ULL, 0x5c7f2144a1be6bf0ULL, 0x7a37cb1cd16362dbULL,
        0x83e08e2b4b311c64ULL, 0xcf70479bab960e32ULL, 0x856ba986b9dee71eULL,
        0xb5478c877af56ce9ULL, 0xb8fe42885f61d6fdULL, 0x1bdd0156966238c8ULL,
        0x622157923ef8a92eULL, 0xfc97ff42114476f8ULL, 0x9d7d350856452cebULL,
        0x4c90c9b0e0a71256ULL, 0x2308502dfbcb016cULL, 0x2d7a03faa7a64845ULL,
        0xf46e8b38bfc6c4abULL, 0xbdbef8fdd477debaULL, 0x3aac4cebc8079b79ULL,
        0xf09cb105e8879d0cULL, 0x27fa6a10ac8a58cbULL, 0x8960e7c1401d0ceaULL,
        0x1a6f811e4a356928ULL, 0x90c4fb0773d196ffULL, 0x43501a2f609d0a9fULL,
        0xf7a516e0c63f3796ULL, 0x1ce4a6b3b8da9252ULL, 0x1324752c38e08a9bULL,
        0xa5a864733bec154fULL, 0x2bf124575549b33fULL, 0xd766db15440dc5c7ULL,
        0xa7d179e39e42b792ULL, 0xdadf151a61997fd3ULL, 0x86a0345ec0271423ULL,
        0x38d5517b6da939a4ULL, 0x6518f077104003b4ULL, 0x02791d90a5aea2ddULL,
        0x88d267899c4a5d0aULL, 0x930f66df0a2865c2ULL, 0x4ee9d4204509b08bULL,
        0x325538916685292aULL, 0x412907bfc533a842ULL, 0xb27e2b62544dc673ULL,
        0x6c5304456295e007ULL, 0x5af406e95351908aULL, 0x1f2f3b6bc123616fULL,
        0xc37b09dc5255e5c6ULL, 0x3967d133b1fe6844ULL, 0x298839c7f0e711e2ULL,
        0x409b87f71964f9a2ULL, 0xe938adc3db4b0719ULL, 0x0c0b4e47f9c3ebf4ULL,
        0x5534d576d36b8843ULL, 0x4610a05aeb8b02d8ULL, 0x20c3cdf58232f251ULL,
        0x6de1840dbec2b1e7ULL, 0xa0e8de06b0fa1d08ULL, 0x7b854b540d34333bULL,
        0x42e29a67bcca5b7fULL, 0xd8a6088ac437dd0eULL, 0xc63bb3a9d943ed81ULL,
        0x21714dbd5e65a3b1ULL, 0x6761ede7b5eea169ULL, 0x2431f7c8d573abf6ULL,
        0xd51fc685e1a3671aULL, 0x5e063cd40410c92dULL, 0x283ab98f2cb04002ULL,
        0x8febc06cb2f2f790ULL, 0x17d64f116fa1d33cULL, 0xe07359f1a99ee4aaULL,
        0x784ed68c74cdc006ULL, 0x6e2a19d5c73b42daULL, 0x8712b4161c7045c3ULL,
        0x371582e4ed93216dULL, 0xace390414939f6fcULL, 0x7ec5f12186223b7cULL,
        0xc0b094042bac16fbULL, 0xf9d745379a527ebfULL, 0x737c3f2ea3b68168ULL,
        0x33e7b8d9bad278caULL, 0xa9a32a34c22ffebbULL, 0xe48163ccfedfbd0dULL,
        0x8e5940246ea5a670ULL, 0x51c6ef4b842ad1e4ULL, 0x22bad065279c508cULL,
        0xd91488c218608ceeULL, 0x319ea5491f7cda17ULL, 0xd394e128134c9c60ULL,
        0x094bf43272d5e3b3ULL, 0x9bf612a5a4aad791ULL, 0xccbbda43d26ffd0fULL,
        0x34de1f3c946ad250ULL, 0x4f5b5468995ee16bULL, 0xdf9faf6fea8f7794ULL,
        0x2648ea5870dd092bULL, 0xbfc7e56d71d97c67ULL, 0xdde6b2ff4f21d549ULL,
        0x3c276b463ae86003ULL, 0x91767b4faf86c71fULL, 0x68a13e7835d4b9a0ULL,
        0xb68c115f030c9fd4ULL, 0x141dd2c916582001ULL, 0x983d8f7ddd5324acULL,
        0x64aa703fcc175254ULL, 0xc2c989948e02b426ULL, 0x3e5e76d69f46c2deULL,
        0x50746f03587d8004ULL, 0x45db3d829272f1e5ULL, 0x60584a029b560bf3ULL,
        0xfbae58a73ffcdc62ULL, 0xa15a5e4e6cad4ce8ULL, 0x4ba96e55ce1fb8ccULL,
        0x08f9747aae82b253ULL, 0xc102144cf7fb471bULL, 0x9f042898f3eb8e36ULL,
        0x068b27adf2effb7aULL, 0xedca97fe8c0a5ebeULL, 0x778e0513f4f7d8cfULL,
        0x302c2501c32b8bf7ULL, 0x8d92ddfc175c554dULL, 0xf865c57f46052f5fULL,
        0xeaf3301ba2b2f424ULL, 0xaa68b7ecbbd60d86ULL, 0x998f0f350104754cULL,
        0x0000000000000000ULL, 0xf12e314d34d0ccecULL, 0x710522be061823b5ULL,
        0xaf280d9930c005c1ULL, 0x97fd5ce25d693c65ULL, 0x19a41cc633cc9a15ULL,
        0x95844172f8c79eb8ULL, 0xdc5432b7937684a9ULL, 0x9436c13a2490cf58ULL,
        0x802b13f332c8ef59ULL, 0xc442ae397ced4f5cULL, 0xfa1cd8efe3ab8d82ULL,
        0xf2e5ac954d293fd1ULL, 0x6ad823e8907a1b7dULL, 0x4d2249f83cf043b6ULL,
        0x03cb9dd879f9f33dULL, 0xde2d2f2736d82674ULL, 0x2a43a41f891ee2dfULL,
        0x6f98999d1b6c133aULL, 0xd4ad46cd3df436faULL, 0xbb35df50269825c0ULL,
        0x964fdcaa813e6d85ULL, 0xeb41b0537ee5a5c4ULL, 0x0540ba758b160847ULL,
        0xa41ae43be7bb44afULL, 0xe3b8c429d0671797ULL, 0x819993bbee9fbeb9ULL,
        0xae9a8dd1ec975421ULL, 0xf3572cdd917e6e31ULL, 0x6393d7dae2aff8ceULL,
        0x47a2201237dc5338ULL, 0xa32343dec903ee35ULL, 0x79fc56c4a89a91e6ULL,
        0x01b28048dc5751e0ULL, 0x1296f564e4b7db7bULL, 0x75f7188351597a12ULL,
        0xdb6d9552bdce2e33ULL, 0x1e9dbb231d74308fULL, 0x520d7293fdd322d9ULL,
        0xe20a44610c304677ULL, 0xfeeee2d2b4ead425ULL, 0xca30fdee20800675ULL,
        0x61eaca4a47015a13ULL, 0xe74afe1487264e30ULL, 0x2cc883b27bf119a5ULL,
        0x1664cf59b3f682dcULL, 0xa811aa7c1e78af5bULL, 0x1d5626fb648dc3b2ULL,
        0xb73e9117df5bce34ULL, 0xd05f7cf06ab56f5dULL, 0xfd257f0acd132718ULL,
        0x574dc8e676c52a9eULL, 0x0739a7e52eb8aa9aULL, 0x5486553e0f3cd9a3ULL,
        0x56ff48aeaa927b7eULL, 0xbe756525ad8e2d87ULL, 0x7d0e6cf9ffdbc841ULL,
        0x3b1ecca31450ca99ULL, 0x6913be30e983e840ULL, 0xad511009956ea71cULL,
        0xb1b5b6ba2db4354eULL, 0x4469bdca4e25a005ULL, 0x15af5281ca0f71e1ULL,
        0x744598cb8d0e2bf2ULL, 0x593f9b312aa863b7ULL, 0xefb38a6e29a4fc63ULL,
        0x6b6aa3a04c2d4a9dULL, 0x3d95eb0ee6bf31e3ULL, 0xa291c3961554bfd5ULL,
        0x18169c8eef9bcbf5ULL, 0x115d68bc9d4e2846ULL, 0xba875f18facf7420ULL,
        0xd1edfcb8b6e23ebdULL, 0xb00736f2f1e364aeULL, 0x84d929ce6589b6feULL,
        0x70b7a2f6da4f7255ULL, 0x0e7253d75c6d4929ULL, 0x04f23a3d574159a7ULL,
        0x0a8069ea0b2c108eULL, 0x49d073c56bb11a11ULL, 0x8aab7a1939e4ffd7ULL,
        0xcd095a0b0e38acefULL, 0xc9fb60365979f548ULL, 0x92bde697d67f3422ULL,
        0xc78933e10514bc61ULL, 0xe1c1d9b975c9b54aULL, 0xd2266160cf1bcd80ULL,
        0x9a4492ed78fd8671ULL, 0xb3ccab2a881a9793ULL, 0x72cebf667fe1d088ULL,
        0xd6d45b5d985a9427ULL
    },
    {
        0xc811a8058c3f55deULL, 0x65f5b43196b50619ULL, 0xf74f96b1d6706e43ULL,
        0x859d1e8bcb43d336ULL, 0x5aab8a85ccfa3d84ULL, 0xf9c7bf99c295fcfdULL,
        0xa21fd5a1de4b630fULL, 0xcdb3ef763b8b456dULL, 0x803f59f87cf7c385ULL,
        0xb27c73be5f31913cULL, 0x98e3ac6633b04821ULL, 0xbf61674c26b8f818ULL,
        0x0ffbc995c4c130c8ULL, 0xaaa0862010761a98ULL, 0x6057f342210116aaULL,
        0xf63c760c0654cc35ULL, 0x2ddb45cc667d9042ULL, 0xbcf45a964bd40382ULL,
        0x68e8a0c3ef3c6f3dULL, 0xa7bd92d269ff73bcULL, 0x290ae20201ed2287ULL,
        0xb7de34cde885818fULL, 0xd901eea7dd61059bULL, 0xd6fa273219a03553ULL,
        0xd56f1ae874cccec9ULL, 0xea31245c2e83f554ULL, 0x7034555da07be499ULL,
        0xce26d2ac56e7bef7ULL, 0xfd161857a5054e38ULL, 0x6a0e7da4527436d1ULL,
        0x5bd86a381cde9ff2ULL, 0xcaf7756231770c32ULL, 0xb09aaed9e279c8d0ULL,
        0x5def1091c60674dbULL, 0x111046a2515e5045ULL, 0x23536ce4729802fcULL,
        0xc50cbcf7f5b63cfaULL, 0x73a16887cd171f03ULL, 0x7d2941afd9f28dbdULL,
        0x3f5e3eb45a4f3b9dULL, 0x84eefe361b677140ULL, 0x3db8e3d3e7076271ULL,
        0x1a3a28f9f20fd248ULL, 0x7ebc7c75b49e7627ULL, 0x74e5f293c7eb565cULL,
        0x18dcf59e4f478ba4ULL, 0x0c6ef44fa9adcb52ULL, 0xc699812d98dac760ULL,
        0x788b06dc6e469d0eULL, 0xfc65f8ea7521ec4eULL, 0x30a5f7219e8e0b55ULL,
        0x2bec3f65bca57b6bULL, 0xddd04969baf1b75eULL, 0x99904cdbe394ea57ULL,
        0x14b201d1e6ea40f6ULL, 0xbbb0c08241284addULL, 0x50f20463bf8f1dffULL,
        0xe8d7f93b93cbacb8ULL, 0x4d8cb68e477c86e8ULL, 0xc1dd1b3992268e3fULL,
        0x7c5aa11209d62fcbULL, 0x2f3d98abdb35c9aeULL, 0x671369562bfd5ff5ULL,
        0x15c1e16c36cee280ULL, 0x1d7eb2edf8f39b17ULL, 0xda94d37db00dfe01ULL,
        0x877bc3ec760b8adaULL, 0xcb8495dfe153ae44ULL, 0x05a24773b7b410b3ULL,
        0x12857b783c32abdfULL, 0x8eb770d06812513bULL, 0x536739b9d2e3e665ULL,
        0x584d57e271b26468ULL, 0xd789c78fc9849725ULL, 0xa935bbfa7d1ae102ULL,
        0x8b1537a3dfa64188ULL, 0xd0cd5d9bc378de7aULL, 0x4ac82c9a4d80cfb7ULL,
        0x42777f1b83bdb620ULL, 0x72d2883a1d33bd75ULL, 0x5e7a2d4bab6a8f41ULL,
        0xf4daab6bbb1c95d9ULL, 0x905cffe7fd8d31b6ULL, 0x83aa6422119b381fULL,
        0xc0aefb8442022c49ULL, 0xa0f908c663033ae3ULL, 0xa428af0804938826ULL,
        0xade41c341a8a53c7ULL, 0xae7121ee77e6a85dULL, 0xc47f5c4a25929e8cULL,
        0xb538e9aa55cdd863ULL, 0x06377aa9dad8eb29ULL, 0xa18ae87bb3279895ULL,
        0x6edfda6a35e48414ULL, 0x6b7d9d19825094a7ULL, 0xd41cfa55a4e86cbfULL,
        0xe5caedc9ea42c59cULL, 0xa36c351c0e6fc179ULL, 0x5181e4de6fabbf89ULL,
        0xfff0c530184d17d4ULL, 0x9d41eb1584045892ULL, 0x1c0d525028d73961ULL,
        0xf178ec180ca8856aULL, 0x9a0571018ef811cdULL, 0x4091a27c3ef5efccULL,
        0x19af15239f6329d2ULL, 0x347450eff91eb990ULL, 0xe11b4a078dd27759ULL,
        0xb9561de5fc601331ULL, 0x912f1f5a2da993c0ULL, 0x1654dcb65ba2191aULL,
        0x3e2dde098a6b99ebULL, 0x8a66d71e0f82e3feULL, 0x8c51adb7d55a08d7ULL,
        0x4533e50f8941ff7fULL, 0x02e6dd67bd4859ecULL, 0xe068aaba5df6d52fULL,
        0xc24826e3ff4a75a5ULL, 0x6c39070d88acddf8ULL, 0x6486548c4691a46fULL,
        0xd1bebd26135c7c0cULL, 0xb30f93038f15334aULL, 0x82d9849fc1bf9a69ULL,
        0x9c320ba85420fae4ULL, 0xfa528243aff90767ULL, 0x9ed4d6cfe968a308ULL,
        0xb825fd582c44b147ULL, 0x9b7691bc5edcb3bbULL, 0xc7ea619048fe6516ULL,
        0x1063a61f817af233ULL, 0x47d538683409a693ULL, 0x63c2ce984c6ded30ULL,
        0x2a9fdfd86c81d91dULL, 0x7b1e3b06032a6694ULL, 0x666089ebfbd9fd83ULL,
        0x0a598ee67375207bULL, 0x07449a140afc495fULL, 0x2ca8a571b6593234ULL,
        0x1f986f8a45bbc2fbULL, 0x381aa4a050b372c2ULL, 0x5423a3add81faf3aULL,
        0x17273c0b8b86bb6cULL, 0xfe83258dc869b5a2ULL, 0x287902bfd1c980f1ULL,
        0xf5a94bd66b3837afULL, 0x88800a79b2caba12ULL, 0x55504310083b0d4cULL,
        0xdf36940e07b9eeb2ULL, 0x04d1a7ce6790b2c5ULL, 0x612413fff125b4dcULL,
        0x26f12b97c52c124fULL, 0x86082351a62f28acULL, 0xef93632f9937e5e7ULL,
        0x3507b052293a1be6ULL, 0xe72c30ae570a9c70ULL, 0xd3586041ae1425e0ULL,
        0xde4574b3d79d4cc4ULL, 0x92ba228040c5685aULL, 0xf00b0ca5dc8c271cULL,
        0xbe1287f1f69c5a6eULL, 0xf39e317fb1e0dc86ULL, 0x495d114020ec342dULL,
        0x699b407e3f18cd4bULL, 0xdca3a9d46ad51528ULL, 0x0d1d14f279896924ULL,
        0x0000000000000000ULL, 0x593eb75fa196c61eULL, 0x2e4e78160b116bd8ULL,
        0x6d4ae7b058887f8eULL, 0xe65fd013872e3e06ULL, 0x7a6ddbbbd30ec4e2ULL,
        0xac97fc89caaef1b1ULL, 0x09ccb33c1e19dbe1ULL, 0x89f3eac462ee1864ULL,
        0x7770cf49aa87adc6ULL, 0x56c57eca6557f6d6ULL, 0x03953dda6d6cfb9aULL,
        0x36928d884456e07cULL, 0x1eeb8f37959f608dULL, 0x31d6179c4eaaa923ULL,
        0x6fac3ad7e5c02662ULL, 0x43049fa653991456ULL, 0xabd3669dc052b8eeULL,
        0xaf02c153a7c20a2bULL, 0x3ccb036e3723c007ULL, 0x93c9c23d90e1ca2cULL,
        0xc33bc65e2f6ed7d3ULL, 0x4cff56339758249eULL, 0xb1e94e64325d6aa6ULL,
        0x37e16d359472420aULL, 0x79f8e661be623f78ULL, 0x5214d90402c74413ULL,
        0x482ef1fdf0c8965bULL, 0x13f69bc5ec1609a9ULL, 0x0e88292814e592beULL,
        0x4e198b542a107d72ULL, 0xccc00fcbebafe71bULL, 0x1b49c844222b703eULL,
        0x2564164da840e9d5ULL, 0x20c6513e1ff4f966ULL, 0xbac3203f910ce8abULL,
        0xf2edd1c261c47ef0ULL, 0x814cb945acd361f3ULL, 0x95feb8944a392105ULL,
        0x5c9cf02c1622d6adULL, 0x971865f3f77178e9ULL, 0xbd87ba2b9bf0a1f4ULL,
        0x444005b259655d09ULL, 0xed75be48247fbc0bULL, 0x7596122e17cff42aULL,
        0xb44b091785e97a15ULL, 0x966b854e2755da9fULL, 0xeee0839249134791ULL,
        0x32432a4623c652b9ULL, 0xa8465b47ad3e4374ULL, 0xf8b45f2412b15e8bULL,
        0x2417f6f078644ba3ULL, 0xfb2162fe7fdda511ULL, 0x4bbbcc279da46dc1ULL,
        0x0173e0bdd024a276ULL, 0x22208c59a2bca08aULL, 0x8fc4906db836f34dULL,
        0xe4b90d743a6667eaULL, 0x7147b5e0705f46efULL, 0x2782cb2a1508b039ULL,
        0xec065ef5f45b1e7dULL, 0x21b5b183cfd05b10ULL, 0xdbe733c060295c77ULL,
        0x9fa73672394c017eULL, 0xcf55321186c31c81ULL, 0xd8720e1a0d45a7edULL,
        0x3b8f997a3ddf8958ULL, 0x3afc79c7edfb2b2eULL, 0xe9a4198643ef0eceULL,
        0x5f09cdf67b4e2d37ULL, 0x4f6a6be9fa34df04ULL, 0xb6add47038a123f9ULL,
        0x8d224d0a057eaaa1ULL, 0xc96248b85c1bf7a8ULL, 0xe3fd9760309a2eb5ULL,
        0x0b2a6e5ba351820dULL, 0xeb42c4e1fea75722ULL, 0x948d58299a1d8373ULL,
        0x7fcf9cc864bad451ULL, 0xa55b4fb5d4b72a50ULL, 0x08bf5381ce3d7997ULL,
        0x46a6d8d5e42d04e5ULL, 0xd22b80fc7e308796ULL, 0x57b69e77b57354a0ULL,
        0x3969441d8097d0b4ULL, 0x3330cafbf3e2f0cfULL, 0xe28e77dde0be8cc3ULL,
        0x62b12e259c494f46ULL, 0xa6ce726fb9dbd1caULL, 0x41e242c1eed14dbaULL,
        0x76032ff47aa30fb0ULL
    },
    {
        0x45b268a93acde4ccULL, 0xaf7f0be884549d08ULL, 0x048354b3c1468263ULL,
        0x925435c2c80efed2ULL, 0xee4e37f27fdffba7ULL, 0x167a33920c60f14dULL,
        0xfb123b52ea03e584ULL, 0x4a0cab53fdbb9007ULL, 0x9deaf6380f788a19ULL,
        0xcb48ec558f0cb32aULL, 0xb59dc4b2d6fef7e0ULL, 0xdcdbca22f4f3ecb6ULL,
        0x11df5813549a9c40ULL, 0xe33fdedf568aced3ULL, 0xa0c1c8124322e9c3ULL,
        0x07a56b8158fa6d0dULL, 0x77279579b1e1f3ddULL, 0xd9b18b74422ac004ULL,
        0xb8ec2d9fffabc294ULL, 0xf4acf8a82d75914fULL, 0x7bbf69b1ef2b6878ULL,
        0xc4f62faf487ac7e1ULL, 0x76ce809cc67e5d0cULL, 0x6711d88f92e4c14cULL,
        0x627b99d9243dedfeULL, 0x234aa5c3dfb68b51ULL, 0x909b1f15262dbf6dULL,
        0x4f66ea054b62bcb5ULL, 0x1ae2cf5a52aa6ae8ULL, 0xbea053fbd0ce0148ULL,
        0xed6808c0e66314c9ULL, 0x43fe16cd15a82710ULL, 0xcd049231a06970f6ULL,
        0xe7bc8a6c97cc4cb0ULL, 0x337ce835fcb3b9c0ULL, 0x65def2587cc780f3ULL,
        0x52214ede4132bb50ULL, 0x95f15e4390f493dfULL, 0x870839625dd2e0f1ULL,
        0x41313c1afb8b66afULL, 0x91720af051b211bcULL, 0x477d427ed4eea573ULL,
        0x2e3b4ceef6e3be25ULL, 0x82627834eb0bcc43ULL, 0x9c03e3dd78e724c8ULL,
        0x2877328ad9867df9ULL, 0x14b51945e243b0f2ULL, 0x574b0f88f7eb97e2ULL,
        0x88b6fa989aa4943aULL, 0x19c4f068cb168586ULL, 0x50ee6409af11faefULL,
        0x7df317d5c04eaba4ULL, 0x7a567c5498b4c6a9ULL, 0xb6bbfb804f42188eULL,
        0x3cc22bcf3bc5cd0bULL, 0xd04336eaaa397713ULL, 0xf02fac1bec33132cULL,
        0x2506dba7f0d3488dULL, 0xd7e65d6bf2c31a1eULL, 0x5eb9b2161ff820f5ULL,
        0x842e0650c46e0f9fULL, 0x716beb1d9e843001ULL, 0xa933758cab315ed4ULL,
        0x3fe414fda2792265ULL, 0x27c9f1701ef00932ULL, 0x73a4c1ca70a771beULL,
        0x94184ba6e76b3d0eULL, 0x40d829ff8c14c87eULL, 0x0fbec3fac77674cbULL,
        0x3616a9634a6a9572ULL, 0x8f139119c25ef937ULL, 0xf545ed4d5aea3f9eULL,
        0xe802499650ba387bULL, 0x6437e7bd0b582e22ULL, 0xe6559f89e053e261ULL,
        0x80ad52e305288dfcULL, 0x6dc55a23e34b9935ULL, 0xde14e0f51ad0ad09ULL,
        0xc6390578a659865eULL, 0x96d7617109487cb1ULL, 0xe2d6cb3a21156002ULL,
        0x01e915e5779faed1ULL, 0xadb0213f6a77dcb7ULL, 0x9880b76eb9a1a6abULL,
        0x5d9f8d248644cf9bULL, 0xfd5e4536c5662658ULL, 0xf1c6b9fe9bacbdfdULL,
        0xeacd6341be9979c4ULL, 0xefa7221708405576ULL, 0x510771ecd88e543eULL,
        0xc2ba51cb671f043dULL, 0x0ad482ac71af5879ULL, 0xfe787a045cdac936ULL,
        0xb238af338e049aedULL, 0xbd866cc94972ee26ULL, 0x615da6ebbd810290ULL,
        0x3295fdd08b2c1711ULL, 0xf834046073bf0aeaULL, 0xf3099329758ffc42ULL,
        0x1caeb13e7dcfa934ULL, 0xba2307481188832bULL, 0x24efce42874ce65cULL,
        0x0e57d61fb0e9da1aULL, 0xb3d1bad6f99b343cULL, 0xc0757b1c893c4582ULL,
        0x2b510db8403a9297ULL, 0x5c7698c1f1db614aULL, 0x3e0d0118d5e68cb4ULL,
        0xd60f488e855cb4cfULL, 0xae961e0df3cb33d9ULL, 0x3a8e55ab14a00ed7ULL,
        0x42170328623789c1ULL, 0x838b6dd19c946292ULL, 0x895fef7ded3b3aebULL,
        0xcfcbb8e64e4a3149ULL, 0x064c7e642f65c3dcULL, 0x3d2b3e2a4c5a63daULL,
        0x5bd3f340a9210c47ULL, 0xb474d157a1615931ULL, 0xac5934da1de87266ULL,
        0x6ee365117af7765bULL, 0xc86ed36716b05c44ULL, 0x9ba6885c201d49c5ULL,
        0xb905387a88346c45ULL, 0x131072c4bab9ddffULL, 0xbf49461ea751af99ULL,
        0xd52977bc1ce05ba1ULL, 0xb0f785e46027db52ULL, 0x546d30ba6e57788cULL,
        0x305ad707650f56aeULL, 0xc987c682612ff295ULL, 0xa5ab8944f5fbc571ULL,
        0x7ed528e759f244caULL, 0x8ddcbbce2c7db888ULL, 0xaa154abe328db1baULL,
        0x1e619be993ece88bULL, 0x09f2bd9ee813b717ULL, 0x7401aa4b285d1cb3ULL,
        0x21858f143195caeeULL, 0x48c381841398d1b8ULL, 0xfcb750d3b2f98889ULL,
        0x39a86a998d1ce1b9ULL, 0x1f888e0ce473465aULL, 0x7899568376978716ULL,
        0x02cf2ad7ee2341bfULL, 0x85c713b5b3f1a14eULL, 0xff916fe12b4567e7ULL,
        0x7c1a0230b7d10575ULL, 0x0c98fcc85eca9ba5ULL, 0xa3e7f720da9e06adULL,
        0x6a6031a2bbb1f438ULL, 0x973e74947ed7d260ULL, 0x2cf4663918c0ff9aULL,
        0x5f50a7f368678e24ULL, 0x34d983b4a449d4cdULL, 0x68af1b755592b587ULL,
        0x7f3c3d022e6dea1bULL, 0xabfc5f5b45121f6bULL, 0x0d71e92d29553574ULL,
        0xdffdf5106d4f03d8ULL, 0x081ba87b9f8c19c6ULL, 0xdb7ea1a3ac0981bbULL,
        0xbbca12ad66172dfaULL, 0x79704366010829c7ULL, 0x179326777bff5f9cULL,
        0x0000000000000000ULL, 0xeb2476a4c906d715ULL, 0x724dd42f0738df6fULL,
        0xb752ee6538ddb65fULL, 0x37ffbc863df53ba3ULL, 0x8efa84fcb5c157e6ULL,
        0xe9eb5c73272596aaULL, 0x1b0bdabf2535c439ULL, 0x86e12c872a4d4e20ULL,
        0x9969a28bce3e087aULL, 0xfafb2eb79d9c4b55ULL, 0x056a4156b6d92cb2ULL,
        0x5a3ae6a5debea296ULL, 0x22a3b026a8292580ULL, 0x53c85b3b36ad1581ULL,
        0xb11e900117b87583ULL, 0xc51f3a4a3fe56930ULL, 0xe019e1edcf3621bdULL,
        0xec811d2591fcba18ULL, 0x445b7d4c4d524a1dULL, 0xa8da6069dcaef005ULL,
        0x58f5cc72309de329ULL, 0xd4c062596b7ff570ULL, 0xce22ad0339d59f98ULL,
        0x591cd99747024df8ULL, 0x8b90c5aa03187b54ULL, 0xf663d27fc356d0f0ULL,
        0xd8589e9135b56ed5ULL, 0x35309651d3d67a1cULL, 0x12f96721cd26732eULL,
        0xd28c1c3d441a36acULL, 0x492a946164077f69ULL, 0x2d1d73dc6f5f514bULL,
        0x6f0a70f40d68d88aULL, 0x60b4b30eca1eac41ULL, 0xd36509d83385987dULL,
        0x0b3d97490630f6a8ULL, 0x9eccc90a96c46577ULL, 0xa20ee2c5ad01a87cULL,
        0xe49ab55e0e70a3deULL, 0xa4429ca182646ba0ULL, 0xda97b446db962f6aULL,
        0xcced87d4d7f6de27ULL, 0x2ab8185d37a53c46ULL, 0x9f25dcefe15bcba6ULL,
        0xc19c6ef9fea3eb53ULL, 0xa764a3931bd884ceULL, 0x2fd2590b817c10f4ULL,
        0x56a21a6d80743933ULL, 0xe573a0bb79ef0d0fULL, 0x155c0ca095dc1e23ULL,
        0x6c2c4fc694d437e4ULL, 0x10364df623053291ULL, 0xdd32dfc7836c4267ULL,
        0x03263f3299bcef6eULL, 0x66f8cd6ae57b6f9dULL, 0x8c35ae2b5be21659ULL,
        0x31b3c2e21290f87fULL, 0x93bd2027bf915003ULL, 0x69460e90220d1b56ULL,
        0x299e276fae19d328ULL, 0x63928c3c53a2432fULL, 0x7082fef8e91b9ed0ULL,
        0xbc6f792c3eed40f7ULL, 0x4c40d537d2de53dbULL, 0x75e8bfae5fc2b262ULL,
        0x4da9c0d2a541fd0aULL, 0x4e8fffe03cfd1264ULL, 0x2620e495696fa7e3ULL,
        0xe1f0f408b8a98f6cULL, 0xd1aa230fdda6d9c2ULL, 0xc7d0109dd1c6288fULL,
        0x8a79d04f7487d585ULL, 0x4694579ba3710ba2ULL, 0x38417f7cfa834f68ULL,
        0x1d47a4db0a5007e5ULL, 0x206c9af1460a643fULL, 0xa128ddf734bd4712ULL,
        0x8144470672b7232dULL, 0xf2e086cc02105293ULL, 0x182de58dbc892b57ULL,
        0xcaa1f9b0f8931dfbULL, 0x6b892447cc2e5ae9ULL, 0xf9dd11850420a43bULL,
        0x4be5beb68a243ed6ULL, 0x5584255f19c8d65dULL, 0x3b67404e633fa006ULL,
        0xa68db6766c472a1fULL, 0xf78ac79ab4c97e21ULL, 0xc353442e1080aaecULL,
        0x9a4f9db95782e714ULL
    },
    {
        0x05ba7bc82c9b3220ULL, 0x31a54665f8b65e4fULL, 0xb1b651f77547f4d4ULL,
        0x8bfa0d857ba46682ULL, 0x85a96c5aa16a98bbULL, 0x990faef908eb79c9ULL,
        0xa15e37a247f4a62dULL, 0x76857dcd5d27741eULL, 0xf8c50b800a1820bcULL,
        0xbe65dcb201f7a2b4ULL, 0x666d1b986f9426e7ULL, 0x4cc921bf53c4e648ULL,
        0x95410a0f93d9ca42ULL, 0x20cdccaa647ba4efULL, 0x429a4060890a1871ULL,
        0x0c4ea4f69b32b38bULL, 0xccda362dde354cd3ULL, 0x96dc23bc7c5b2fa9ULL,
        0xc309bb68aa851ab3ULL, 0xd26131a73648e013ULL, 0x021dc52941fc4db2ULL,
        0xcd5adab7704be48aULL, 0xa77965d984ed71e6ULL, 0x32386fd61734bba4ULL,
        0xe82d6dd538ab7245ULL, 0x5c2147ea6177b4b1ULL, 0x5da1ab70cf091ce8ULL,
        0xac907fce72b8bdffULL, 0x57c85dfd972278a8ULL, 0xa4e44c6a6b6f940dULL,
        0x3851995b4f1fdfe4ULL, 0x62578ccaed71bc9eULL, 0xd9882bb0c01d2c0aULL,
        0x917b9d5d113c503bULL, 0xa2c31e11a87643c6ULL, 0xe463c923a399c1ceULL,
        0xf71686c57ea876dcULL, 0x87b4a973e096d509ULL, 0xaf0d567d9d3a5814ULL,
        0xb40c2a3f59dcc6f4ULL, 0x3602f88495d121ddULL, 0xd3e1dd3d9836484aULL,
        0xf945e71aa46688e5ULL, 0x7518547eb2a591f5ULL, 0x9366587450c01d89ULL,
        0x9ea81018658c065bULL, 0x4f54080cbc4603a3ULL, 0x2d0384c65137bf3dULL,
        0xdc325078ec861e2aULL, 0xea30a8fc79573ff7ULL, 0x214d2030ca050cb6ULL,
        0x65f0322b8016c30cULL, 0x69be96dd1b247087ULL, 0xdb95ee9981e161b8ULL,
        0xd1fc1814d9ca05f8ULL, 0x820ed2bbcc0de729ULL, 0x63d76050430f14c7ULL,
        0x3bccb0e8a09d3a0fULL, 0x8e40764d573f54a2ULL, 0x39d175c1e16177bdULL,
        0x12f5a37c734f1f4bULL, 0xab37c12f1fdfc26dULL, 0x5648b167395cd0f1ULL,
        0x6c04ed1537bf42a7ULL, 0xed97161d14304065ULL, 0x7d6c67daab72b807ULL,
        0xec17fa87ba4ee83cULL, 0xdfaf79cb0304fbc1ULL, 0x733f060571bc463eULL,
        0x78d61c1287e98a27ULL, 0xd07cf48e77b4ada1ULL, 0xb9c262536c90dd26ULL,
        0xe2449b5860801605ULL, 0x8fc09ad7f941fcfbULL, 0xfad8cea94be46d0eULL,
        0xa343f28b0608eb9fULL, 0x9b126bd04917347bULL, 0x9a92874ae7699c22ULL,
        0x1b017c42c4e69ee0ULL, 0x3a4c5c720ee39256ULL, 0x4b6e9f5e3ea399daULL,
        0x6ba353f45ad83d35ULL, 0xe7fee0904c1b2425ULL, 0x22d009832587e95dULL,
        0x842980c00f1430e2ULL, 0xc6b3c0a0861e2893ULL, 0x087433a419d729f2ULL,
        0x341f3dadd42d6c6fULL, 0xee0a3faefbb2a58eULL, 0x4aee73c490dd3183ULL,
        0xaab72db5b1a16a34ULL, 0xa92a04065e238fdfULL, 0x7b4b35a1686b6fccULL,
        0x6a23bf6ef4a6956cULL, 0x191cb96b851ad352ULL, 0x55d598d4d6de351aULL,
        0xc9604de5f2ae7ef3ULL, 0x1ca6c2a3a981e172ULL, 0xde2f9551ad7a5398ULL,
        0x3025aaff56c8f616ULL, 0x15521d9d1e2860d9ULL, 0x506fe31cfa45073aULL,
        0x189c55f12b647b0bULL, 0x0180ec9aae7ea859ULL, 0x7cec8b40050c105eULL,
        0x2350e5198bf94104ULL, 0xef8ad33455cc0dd7ULL, 0x07a7bee16d677f92ULL,
        0xe5e325b90de76997ULL, 0x5a061591a26e637aULL, 0xb611ef1618208b46ULL,
        0x09f4df3eb7a981abULL, 0x1ebb078ae87dacc0ULL, 0xb791038cb65e231fULL,
        0x0fd38d4574b05660ULL, 0x67edf702c1ea8ebeULL, 0xba5f4be0831238cdULL,
        0xe3c477c2cefebe5cULL, 0x0dce486c354c1bd2ULL, 0x8c5db36416c31910ULL,
        0x26ea9ed1a7627324ULL, 0x039d29b3ef82e5ebULL, 0x9f28fc82cbf2ae02ULL,
        0xa8aae89cf05d2786ULL, 0x431aacfa2774b028ULL, 0xcf471f9e31b7a938ULL,
        0x581bd0b8e3922ec8ULL, 0xbc78199b400bef06ULL, 0x90fb71c7bf42f862ULL,
        0x1f3beb1046030499ULL, 0x683e7a47b55ad8deULL, 0x988f4263a695d190ULL,
        0xd808c72a6e638453ULL, 0x0627527bc319d7cbULL, 0xebb04466d72997aeULL,
        0xe67e0c0ae2658c7cULL, 0x14d2f107b056c880ULL, 0x7122c32c30400b8cULL,
        0x8a7ae11fd5dacedbULL, 0xa0dedb38e98a0e74ULL, 0xad109354dcc615a6ULL,
        0x0be91a17f655cc19ULL, 0x8ddd5ffeb8bdb149ULL, 0xbfe53028af890aedULL,
        0xd65ba6f5b4ad7a6aULL, 0x7956f0882997227eULL, 0x10e8665532b352f9ULL,
        0x0e5361dfdacefe39ULL, 0xcec7f3049fc90161ULL, 0xff62b561677f5f2eULL,
        0x975ccf26d22587f0ULL, 0x51ef0f86543baf63ULL, 0x2f1e41ef10cbf28fULL,
        0x52722635bbb94a88ULL, 0xae8dbae73344f04dULL, 0x410769d36688fd9aULL,
        0xb3ab94de34bbb966ULL, 0x801317928df1aa9bULL, 0xa564a0f0c5113c54ULL,
        0xf131d4bebdb1a117ULL, 0x7f71a2f3ea8ef5b5ULL, 0x40878549c8f655c3ULL,
        0x7ef14e6944f05decULL, 0xd44663dcf55137d8ULL, 0xf2acfd0d523344fcULL,
        0x0000000000000000ULL, 0x5fbc6e598ef5515aULL, 0x16cf342ef1aa8532ULL,
        0xb036bd6ddb395c8dULL, 0x13754fe6dd31b712ULL, 0xbbdfa77a2d6c9094ULL,
        0x89e7c8ac3a582b30ULL, 0x3c6b0e09cdfa459dULL, 0xc4ae0589c7e26521ULL,
        0x49735a777f5fd468ULL, 0xcafd64561d2c9b18ULL, 0xda1502032f9fc9e1ULL,
        0x8867243694268369ULL, 0x3782141e3baf8984ULL, 0x9cb5d53124704be9ULL,
        0xd7db4a6f1ad3d233ULL, 0xa6f989432a93d9bfULL, 0x9d3539ab8a0ee3b0ULL,
        0x53f2caaf15c7e2d1ULL, 0x6e19283c76430f15ULL, 0x3debe2936384edc4ULL,
        0x5e3c82c3208bf903ULL, 0x33b8834cb94a13fdULL, 0x6470deb12e686b55ULL,
        0x359fd1377a53c436ULL, 0x61caa57902f35975ULL, 0x043a975282e59a79ULL,
        0xfd7f70482683129cULL, 0xc52ee913699ccd78ULL, 0x28b9ff0e7dac8d1dULL,
        0x5455744e78a09d43ULL, 0xcb7d88ccb3523341ULL, 0x44bd121b4a13cfbaULL,
        0x4d49cd25fdba4e11ULL, 0x3e76cb208c06082fULL, 0x3ff627ba2278a076ULL,
        0xc28957f204fbb2eaULL, 0x453dfe81e46d67e3ULL, 0x94c1e6953da7621bULL,
        0x2c83685cff491764ULL, 0xf32c1197fc4deca5ULL, 0x2b24d6bd922e68f6ULL,
        0xb22b78449ac5113fULL, 0x48f3b6edd1217c31ULL, 0x2e9ead75beb55ad6ULL,
        0x174fd8b45fd42d6bULL, 0x4ed4e4961238abfaULL, 0x92e6b4eefebeb5d0ULL,
        0x46a0d7320bef8208ULL, 0x47203ba8a5912a51ULL, 0x24f75bf8e69e3e96ULL,
        0xf0b1382413cf094eULL, 0xfee259fbc901f777ULL, 0x276a724b091cdb7dULL,
        0xbdf8f501ee75475fULL, 0x599b3c224dec8691ULL, 0x6d84018f99c1eafeULL,
        0x7498b8e41cdb39acULL, 0xe0595e71217c5bb7ULL, 0x2aa43a273c50c0afULL,
        0xf50b43ec3f543b6eULL, 0x838e3e2162734f70ULL, 0xc09492db4507ff58ULL,
        0x72bfea9fdfc2ee67ULL, 0x11688acf9ccdfaa0ULL, 0x1a8190d86a9836b9ULL,
        0x7acbd93bc615c795ULL, 0xc7332c3a286080caULL, 0x863445e94ee87d50ULL,
        0xf6966a5fd0d6de85ULL, 0xe9ad814f96d5da1cULL, 0x70a22fb69e3ea3d5ULL,
        0x0a69f68d582b6440ULL, 0xb8428ec9c2ee757fULL, 0x604a49e3ac8df12cULL,
        0x5b86f90b0c10cb23ULL, 0xe1d9b2eb8f02f3eeULL, 0x29391394d3d22544ULL,
        0xc8e0a17f5cd0d6aaULL, 0xb58cc6a5f7a26eadULL, 0x8193fb08238f02c2ULL,
        0xd5c68f465b2f9f81ULL, 0xfcff9cd288fdbac5ULL, 0x77059157f359dc47ULL,
        0x1d262e3907ff492bULL, 0xfb582233e59ac557ULL, 0xddb2bce242f8b673ULL,
        0x2577b76248e096cfULL, 0x6f99c4a6d83da74cULL, 0xc1147e41eb795701ULL,
        0xf48baf76912a9337ULL
    },
    {
        0x3ef29d249b2c0a19ULL, 0xe9e16322b6f8622fULL, 0x5536994047757f7aULL,
        0x9f4d56d5a47b0b33ULL, 0x822567466aa1174cULL, 0xb8f5057deb082fb2ULL,
        0xcc48c10bf4475f53ULL, 0x373088d4275dec3aULL, 0x968f4325180aed10ULL,
        0x173d232cf7016151ULL, 0xae4ed09f946fcc13ULL, 0xfd4b4741c4539873ULL,
        0x1b5b3f0dd9933765ULL, 0x2ffcb0967b644052ULL, 0xe02376d20a89840cULL,
        0xa3ae3a70329b18d7ULL, 0x419cbd2335de8526ULL, 0xfafebf115b7c3199ULL,
        0x0397074f85aa9b0dULL, 0xc58ad4fb4836b970ULL, 0xbec60be3fc4104a8ULL,
        0x1eff36dc4b708772ULL, 0x131fdc33ed8453b6ULL, 0x0844e33e341764d3ULL,
        0x0ff11b6eab38cd39ULL, 0x64351f0a7761b85aULL, 0x3b5694f509cfba0eULL,
        0x30857084b87245d0ULL, 0x47afb3bd2297ae3cULL, 0xf2ba5c2f6f6b554aULL,
        0x74bdc4761f4f70e1ULL, 0xcfdfc64471edc45eULL, 0xe610784c1dc0af16ULL,
        0x7aca29d63c113f28ULL, 0x2ded411776a859afULL, 0xac5f211e99a3d5eeULL,
        0xd484f949a87ef33bULL, 0x3ce36ca596e013e4ULL, 0xd120f0983a9d432cULL,
        0x6bc40464dc597563ULL, 0x69d5f5e5d1956c9eULL, 0x9ae95f043698bb24ULL,
        0xc9ecc8da66a4ef44ULL, 0xd69508c8a5b2eac6ULL, 0xc40c2235c0503b80ULL,
        0x38c193ba8c652103ULL, 0x1ceec75d46bc9e8fULL, 0xd331011937515ad1ULL,
        0xd8e2e56886eca50fULL, 0xb137108d5779c991ULL, 0x709f3b6905ca4206ULL,
        0x4feb50831680caefULL, 0xec456af3241bd238ULL, 0x58d673afe181abbeULL,
        0x242f54e7cad9bf8cULL, 0x0211f1810dcc19fdULL, 0x90bc4dbb0f43c60aULL,
        0x9518446a9da0761dULL, 0xa1bfcbf13f57012aULL, 0x2bde4f8961e172b5ULL,
        0x27b853a84f732481ULL, 0xb0b1e643df1f4b61ULL, 0x18cc38425c39ac68ULL,
        0xd2b7f7d7bf37d821ULL, 0x3103864a3014c720ULL, 0x14aa246372abfa5cULL,
        0x6e600db54ebac574ULL, 0x394765740403a3f3ULL, 0x09c215f0bc71e623ULL,
        0x2a58b947e987f045ULL, 0x7b4cdf18b477bdd8ULL, 0x9709b5eb906c6fe0ULL,
        0x73083c268060d90bULL, 0xfedc400e41f9037eULL, 0x284948c6e44be9b8ULL,
        0x728ecae808065bfbULL, 0x06330e9e17492b1aULL, 0x5950856169e7294eULL,
        0xbae4f4fce6c4364fULL, 0xca7bcf95e30e7449ULL, 0x7d7fd186a33e96c2ULL,
        0x52836110d85ad690ULL, 0x4dfaa1021b4cd312ULL, 0x913abb75872544faULL,
        0xdd46ecb9140f1518ULL, 0x3d659a6b1e869114ULL, 0xc23f2cabd719109aULL,
        0xd713fe062dd46836ULL, 0xd0a60656b2fbc1dcULL, 0x221c5a79dd909496ULL,
        0xefd26dbca1b14935ULL, 0x0e77eda0235e4fc9ULL, 0xcbfd395b6b68f6b9ULL,
        0x0de0eaefa6f4d4c4ULL, 0x0422ff1f1a8532e7ULL, 0xf969b85eded6aa94ULL,
        0x7f6e2007aef28f3fULL, 0x3ad0623b81a938feULL, 0x6624ee8b7aada1a7ULL,
        0xb682e8ddc856607bULL, 0xa78cc56f281e2a30ULL, 0xc79b257a45faa08dULL,
        0x5b4174e0642b30b3ULL, 0x5f638bff7eae0254ULL, 0x4bc9af9c0c05f808ULL,
        0xce59308af98b46aeULL, 0x8fc58da9cc55c388ULL, 0x803496c7676d0eb1ULL,
        0xf33caae1e70dd7baULL, 0xbb6202326ea2b4bfULL, 0xd5020f87201871cbULL,
        0x9d5ca754a9b712ceULL, 0x841669d87de83c56ULL, 0x8a6184785eb6739fULL,
        0x420bba6cb0741e2bULL, 0xf12d5b60eac1ce47ULL, 0x76ac35f71283691cULL,
        0x2c6bb7d9fecedb5fULL, 0xfccdb18f4c351a83ULL, 0x1f79c012c3160582ULL,
        0xf0abadae62a74cb7ULL, 0xe1a5801c82ef06fcULL, 0x67a21845f2cb2357ULL,
        0x5114665f5df04d9dULL, 0xbf40fd2d74278658ULL, 0xa0393d3fb73183daULL,
        0x05a409d192e3b017ULL, 0xa9fb28cf0b4065f9ULL, 0x25a9a22942bf3d7cULL,
        0xdb75e22703463e02ULL, 0xb326e10c5ab5d06cULL, 0xe7968e8295a62de6ULL,
        0xb973f3b3636ead42ULL, 0xdf571d3819c30ce5ULL, 0xee549b7229d7cbc5ULL,
        0x12992afd65e2d146ULL, 0xf8ef4e9056b02864ULL, 0xb7041e134030e28bULL,
        0xc02edd2adad50967ULL, 0x932b4af48ae95d07ULL, 0x6fe6fb7bc6dc4784ULL,
        0x239aacb755f61666ULL, 0x401a4bedbdb807d6ULL, 0x485ea8d389af6305ULL,
        0xa41bc220adb4b13dULL, 0x753b32b89729f211ULL, 0x997e584bb3322029ULL,
        0x1d683193ceda1c7fULL, 0xff5ab6c0c99f818eULL, 0x16bbd5e27f67e3a1ULL,
        0xa59d34ee25d233cdULL, 0x98f8ae853b54a2d9ULL, 0x6df70afacb105e79ULL,
        0x795d2e99b9bba425ULL, 0x8e437b6744334178ULL, 0x0186f6ce886682f0ULL,
        0xebf092a3bb347bd2ULL, 0xbcd7fa62f18d1d55ULL, 0xadd9d7d011c5571eULL,
        0x0bd3e471b1bdffdeULL, 0xaa6c2f808eeafef4ULL, 0x5ee57d31f6c880a4ULL,
        0xf50fa47ff044fca0ULL, 0x1addc9c351f5b595ULL, 0xea76646d3352f922ULL,
        0x0000000000000000ULL, 0x85909f16f58ebea6ULL, 0x46294573aaf12cccULL,
        0x0a5512bf39db7d2eULL, 0x78dbd85731dd26d5ULL, 0x29cfbe086c2d6b48ULL,
        0x218b5d36583a0f9bULL, 0x152cd2adfacd78acULL, 0x83a39188e2c795bcULL,
        0xc3b9da655f7f926aULL, 0x9ecba01b2c1d89c3ULL, 0x07b5f8509f2fa9eaULL,
        0x7ee8d6c926940dcfULL, 0x36b67e1aaf3b6ecaULL, 0x86079859702425abULL,
        0xfb7849dfd31ab369ULL, 0x4c7c57cc932a51e2ULL, 0xd96413a60e8a27ffULL,
        0x263ea566c715a671ULL, 0x6c71fc344376dc89ULL, 0x4a4f595284637af8ULL,
        0xdaf314e98b20bcf2ULL, 0x572768c14ab96687ULL, 0x1088db7c682ec8bbULL,
        0x887075f9537a6a62ULL, 0x2e7a4658f302c2a2ULL, 0x619116dbe582084dULL,
        0xa87dde018326e709ULL, 0xdcc01a779c6997e8ULL, 0xedc39c3dac7d50c8ULL,
        0xa60a33a1a078a8c0ULL, 0xc1a82be452b38b97ULL, 0x3f746bea134a88e9ULL,
        0xa228ccbebafd9a27ULL, 0xabead94e068c7c04ULL, 0xf48952b178227e50ULL,
        0x5cf48cb0fb049959ULL, 0x6017e0156de48abdULL, 0x4438b4f2a73d3531ULL,
        0x8c528ae649ff5885ULL, 0xb515ef924dfcfb76ULL, 0x0c661c212e925634ULL,
        0xb493195cc59a7986ULL, 0x9cda519a21d1903eULL, 0x32948105b5be5c2dULL,
        0x194ace8cd45f2e98ULL, 0x438d4ca238129cdbULL, 0x9b6fa9cabefe39d4ULL,
        0x81b26009ef0b8c41ULL, 0xded1ebf691a58e15ULL, 0x4e6da64d9ee6481fULL,
        0x54b06f8ecf13fd8aULL, 0x49d85e1d01c9e1f5ULL, 0xafc826511c094ee3ULL,
        0xf698a33075ee67adULL, 0x5ac7822eec4db243ULL, 0x8dd47c28c199da75ULL,
        0x89f68337db1ce892ULL, 0xcdce37c57c21dda3ULL, 0x530597de503c5460ULL,
        0x6a42f2aa543ff793ULL, 0x5d727a7e73621ba9ULL, 0xe232875307459df1ULL,
        0x56a19e0fc2dfe477ULL, 0xc61dd3b4cd9c227dULL, 0xe5877f03986a341bULL,
        0x949eb2a415c6f4edULL, 0x6206119460289340ULL, 0x6380e75ae84e11b0ULL,
        0x8be772b6d6d0f16fULL, 0x50929091d596cf6dULL, 0xe86795ec3e9ee0dfULL,
        0x7cf927482b581432ULL, 0xc86a3e14eec26db4ULL, 0x7119cda78dacc0f6ULL,
        0xe40189cd100cb6ebULL, 0x92adbc3a028fdff7ULL, 0xb2a017c2d2d3529cULL,
        0x200dabf8d05c8d6bULL, 0x34a78f9ba2f77737ULL, 0xe3b4719d8f231f01ULL,
        0x45be423c2f5bb7c1ULL, 0xf71e55fefd88e55dULL, 0x6853032b59f3ee6eULL,
        0x65b3e9c4ff073aaaULL, 0x772ac3399ae5ebecULL, 0x87816e97f842a75bULL,
        0x110e2db2e0484a4bULL, 0x331277cb3dd8deddULL, 0xbd510cac79eb9fa5ULL,
        0x352179552a91f5c7ULL
    },
    {
        0x8ab0a96846e06a6dULL, 0x43c7e80b4bf0b33aULL, 0x08c9b3546b161ee5ULL,
        0x39f1c235eba990beULL, 0xc1bef2376606c7b2ULL, 0x2c209233614569aaULL,
        0xeb01523b6fc3289aULL, 0x946953ab935aceddULL, 0x272838f63e13340eULL,
        0x8b0455eca12ba052ULL, 0x77a1b2c4978ff8a2ULL, 0xa55122ca13e54086ULL,
        0x2276135862d3f1cdULL, 0xdb8ddfde08b76cfeULL, 0x5d1e12c89e4a178aULL,
        0x0e56816b03969867ULL, 0xee5f79953303ed59ULL, 0xafed748bab78d71dULL,
        0x6d929f2df93e53eeULL, 0xf5d8a8f8ba798c2aULL, 0xf619b1698e39cf6bULL,
        0x95ddaf2f749104e2ULL, 0xec2a9c80e0886427ULL, 0xce5c8fd8825b95eaULL,
        0xc4e0d9993ac60271ULL, 0x4699c3a5173076f9ULL, 0x3d1b151f50a29f42ULL,
        0x9ed505ea2bc75946ULL, 0x34665acfdc7f4b98ULL, 0x61b1fb53292342f7ULL,
        0xc721c0080e864130ULL, 0x8693cd1696fd7b74ULL, 0x872731927136b14bULL,
        0xd3446c8a63a1721bULL, 0x669a35e8a6680e4aULL, 0xcab658f239509a16ULL,
        0xa4e5de4ef42e8ab9ULL, 0x37a7435ee83f08d9ULL, 0x134e6239e26c7f96ULL,
        0x82791a3c2df67488ULL, 0x3f6ef00a8329163cULL, 0x8e5a7e42fdeb6591ULL,
        0x5caaee4c7981ddb5ULL, 0x19f234785af1e80dULL, 0x255ddde3ed98bd70ULL,
        0x50898a32a99cccacULL, 0x28ca4519da4e6656ULL, 0xae59880f4cb31d22ULL,
        0x0d9798fa37d6db26ULL, 0x32f968f0b4ffcd1aULL, 0xa00f09644f258545ULL,
        0xfa3ad5175e24de72ULL, 0xf46c547c5db24615ULL, 0x713e80fbff0f7e20ULL,
        0x7843cf2b73d2aafaULL, 0xbd17ea36aedf62b4ULL, 0xfd111bacd16f92cfULL,
        0x4abaa7dbc72d67e0ULL, 0xb3416b5dad49fad3ULL, 0xbca316b24914a88bULL,
        0x15d150068aecf914ULL, 0xe27c1debe31efc40ULL, 0x4fe48c759beda223ULL,
        0x7edcfd141b522c78ULL, 0x4e5070f17c26681cULL, 0xe696cac15815f3bcULL,
        0x35d2a64b3bb481a7ULL, 0x800cff29fe7dfdf6ULL, 0x1ed9fac3d5baa4b0ULL,
        0x6c2663a91ef599d1ULL, 0x03c1199134404341ULL, 0xf7ad4ded69f20554ULL,
        0xcd9d9649b61bd6abULL, 0xc8c3bde7eadb1368ULL, 0xd131899fb02afb65ULL,
        0x1d18e352e1fae7f1ULL, 0xda39235aef7ca6c1ULL, 0xa1bbf5e0a8ee4f7aULL,
        0x91377805cf9a0b1eULL, 0x3138716180bf8e5bULL, 0xd9f83acbdb3ce580ULL,
        0x0275e515d38b897eULL, 0x472d3f21f0fbbcc6ULL, 0x2d946eb7868ea395ULL,
        0xba3c248d21942e09ULL, 0xe7223645bfde3983ULL, 0xff64feb902e41bb1ULL,
        0xc97741630d10d957ULL, 0xc3cb1722b58d4eccULL, 0xa27aec719cae0c3bULL,
        0x99fecb51a48c15fbULL, 0x1465ac826d27332bULL, 0xe1bd047ad75ebf01ULL,
        0x79f733af941960c5ULL, 0x672ec96c41a3c475ULL, 0xc27feba6524684f3ULL,
        0x64efd0fd75e38734ULL, 0xed9e60040743ae18ULL, 0xfb8e2993b9ef144dULL,
        0x38453eb10c625a81ULL, 0x6978480742355c12ULL, 0x48cf42ce14a6ee9eULL,
        0x1cac1fd606312dceULL, 0x7b82d6ba4792e9bbULL, 0x9d141c7b1f871a07ULL,
        0x5616b80dc11c4a2eULL, 0xb849c198f21fa777ULL, 0x7ca91801c8d9a506ULL,
        0xb1348e487ec273adULL, 0x41b20d1e987b3a44ULL, 0x7460ab55a3cfbbe3ULL,
        0x84e628034576f20aULL, 0x1b87d16d897a6173ULL, 0x0fe27defe45d5258ULL,
        0x83cde6b8ca3dbeb7ULL, 0x0c23647ed01d1119ULL, 0x7a362a3ea0592384ULL,
        0xb61f40f3f1893f10ULL, 0x75d457d1440471dcULL, 0x4558da34237035b8ULL,
        0xdca6116587fc2043ULL, 0x8d9b67d3c9ab26d0ULL, 0x2b0b5c88ee0e2517ULL,
        0x6fe77a382ab5da90ULL, 0x269cc472d9d8fe31ULL, 0x63c41e46faa8cb89ULL,
        0xb7abbc771642f52fULL, 0x7d1de4852f126f39ULL, 0xa8c6ba3024339ba0ULL,
        0x600507d7cee888c8ULL, 0x8fee82c61a20afaeULL, 0x57a2448926d78011ULL,
        0xfca5e72836a458f0ULL, 0x072bcebb8f4b4cbdULL, 0x497bbe4af36d24a1ULL,
        0x3cafe99bb769557dULL, 0x12fa9ebd05a7b5a9ULL, 0xe8c04baa5b836bdbULL,
        0x4273148fac3b7905ULL, 0x908384812851c121ULL, 0xe557d3506c55b0fdULL,
        0x72ff996acb4f3d61ULL, 0x3eda0c8e64e2dc03ULL, 0xf0868356e6b949e9ULL,
        0x04ead72abb0b0ffcULL, 0x17a4b5135967706aULL, 0xe3c8e16f04d5367fULL,
        0xf84f30028daf570cULL, 0x1846c8fcbd3a2232ULL, 0x5b8120f7f6ca9108ULL,
        0xd46fa231ecea3ea6ULL, 0x334d947453340725ULL, 0x58403966c28ad249ULL,
        0xbed6f3a79a9f21f5ULL, 0x68ccb483a5fe962dULL, 0xd085751b57e1315aULL,
        0xfed0023de52fd18eULL, 0x4b0e5b5f20e6addfULL, 0x1a332de96eb1ab4cULL,
        0xa3ce10f57b65c604ULL, 0x108f7ba8d62c3cd7ULL, 0xab07a3a11073d8e1ULL,
        0x6b0dad1291bed56cULL, 0xf2f366433532c097ULL, 0x2e557726b2cee0d4ULL,
        0x0000000000000000ULL, 0xcb02a476de9b5029ULL, 0xe4e32fd48b9e7ac2ULL,
        0x734b65ee2c84f75eULL, 0x6e5386bccd7e10afULL, 0x01b4fc84e7cbca3fULL,
        0xcfe8735c65905fd5ULL, 0x3613bfda0ff4c2e6ULL, 0x113b872c31e7f6e8ULL,
        0x2fe18ba255052aebULL, 0xe974b72ebc48a1e4ULL, 0x0abc5641b89d979bULL,
        0xb46aa5e62202b66eULL, 0x44ec26b0c4bbff87ULL, 0xa6903b5b27a503c7ULL,
        0x7f680190fc99e647ULL, 0x97a84a3aa71a8d9cULL, 0xdd12ede16037ea7cULL,
        0xc554251ddd0dc84eULL, 0x88c54c7d956be313ULL, 0x4d91696048662b5dULL,
        0xb08072cc9909b992ULL, 0xb5de5962c5c97c51ULL, 0x81b803ad19b637c9ULL,
        0xb2f597d94a8230ecULL, 0x0b08aac55f565da4ULL, 0xf1327fd2017283d6ULL,
        0xad98919e78f35e63ULL, 0x6ab9519676751f53ULL, 0x24e921670a53774fULL,
        0xb9fd3d1c15d46d48ULL, 0x92f66194fbda485fULL, 0x5a35dc7311015b37ULL,
        0xded3f4705477a93dULL, 0xc00a0eb381cd0d8dULL, 0xbb88d809c65fe436ULL,
        0x16104997beacba55ULL, 0x21b70ac95693b28cULL, 0x59f4c5e225411876ULL,
        0xd5db5eb50b21f499ULL, 0x55d7a19cf55c096fULL, 0xa97246b4c3f8519fULL,
        0x8552d487a2bd3835ULL, 0x54635d181297c350ULL, 0x23c2efdc85183bf2ULL,
        0x9f61f96ecc0c9379ULL, 0x534893a39ddc8fedULL, 0x5edf0b59aa0a54cbULL,
        0xac2c6d1a9f38945cULL, 0xd7aebba0d8aa7de7ULL, 0x2abfa00c09c5ef28ULL,
        0xd84cc64f3cf72fbfULL, 0x2003f64db15878b3ULL, 0xa724c7dfc06ec9f8ULL,
        0x069f323f68808682ULL, 0xcc296acd51d01c94ULL, 0x055e2bae5cc0c5c3ULL,
        0x6270e2c21d6301b6ULL, 0x3b842720382219c0ULL, 0xd2f0900e846ab824ULL,
        0x52fc6f277a1745d2ULL, 0xc6953c8ce94d8b0fULL, 0xe009f8fe3095753eULL,
        0x655b2c7992284d0bULL, 0x984a37d54347dfc4ULL, 0xeab5aebf8808e2a5ULL,
        0x9a3fd2c090cc56baULL, 0x9ca0e0fff84cd038ULL, 0x4c2595e4afade162ULL,
        0xdf6708f4b3bc6302ULL, 0xbf620f237d54ebcaULL, 0x93429d101c118260ULL,
        0x097d4fd08cddd4daULL, 0x8c2f9b572e60ecefULL, 0x708a7c7f18c4b41fULL,
        0x3a30dba4dfe9d3ffULL, 0x4006f19a7fb0f07bULL, 0x5f6bf7dd4dc19ef4ULL,
        0x1f6d064732716e8fULL, 0xf9fbcc866a649d33ULL, 0x308c8de567744464ULL,
        0x8971b0f972a0292cULL, 0xd61a47243f61b7d8ULL, 0xefeb8511d4c82766ULL,
        0x961cb6be40d147a3ULL, 0xaab35f25f7b812deULL, 0x76154e407044329dULL,
        0x513d76b64e570693ULL, 0xf3479ac7d2f90aa8ULL, 0x9b8b2e4477079c85ULL,
        0x297eb99d3d85ac69ULL
    },
    {
        0x7e37e62dfc7d40c3ULL, 0x776f25a4ee939e5bULL, 0xe045c850dd8fb5adULL,
        0x86ed5ba711ff1952ULL, 0xe91d0bd9cf616b35ULL, 0x37e0ab256e408ffbULL,
        0x9607f6c031025a7aULL, 0x0b02f5e116d23c9dULL, 0xf3d8486bfb50650cULL,
        0x621cff27c40875f5ULL, 0x7d40cb71fa5fd34aULL, 0x6daa6616daa29062ULL,
        0x9f5f354923ec84e2ULL, 0xec847c3dc507c3b3ULL, 0x025a3668043ce205ULL,
        0xa8bf9e6c4dac0b19ULL, 0xfa808be2e9bebb94ULL, 0xb5b99c5277c74fa3ULL,
        0x78d9bc95f0397bccULL, 0xe332e50cdbad2624ULL, 0xc74fce129332797eULL,
        0x1729eceb2ea709abULL, 0xc2d6b9f69954d1f8ULL, 0x5d898cbfbab8551aULL,
        0x859a76fb17dd8adbULL, 0x1be85886362f7fb5ULL, 0xf6413f8ff136cd8aULL,
        0xd3110fa5bbb7e35cULL, 0x0a2feed514cc4d11ULL, 0xe83010edcd7f1ab9ULL,
        0xa1e75de55f42d581ULL, 0xeede4a55c13b21b6ULL, 0xf2f5535ff94e1480ULL,
        0x0cc1b46d1888761eULL, 0xbce15fdb6529913bULL, 0x2d25e8975a7181c2ULL,
        0x71817f1ce2d7a554ULL, 0x2e52c5cb5c53124bULL, 0xf9f7a6beef9c281dULL,
        0x9e722e7d21f2f56eULL, 0xce170d9b81dca7e6ULL, 0x0e9b82051cb4941bULL,
        0x1e712f623c49d733ULL, 0x21e45cfa42f9f7dcULL, 0xcb8e7a7f8bba0f60ULL,
        0x8e98831a010fb646ULL, 0x474ccf0d8e895b23ULL, 0xa99285584fb27a95ULL,
        0x8cc2b57205335443ULL, 0x42d5b8e984eff3a5ULL, 0x012d1b34021e718cULL,
        0x57a6626aae74180bULL, 0xff19fc06e3d81312ULL, 0x35ba9d4d6a7c6dfeULL,
        0xc9d44c178f86ed65ULL, 0x506523e6a02e5288ULL, 0x03772d5c06229389ULL,
        0x8b01f4fe0b691ec0ULL, 0xf8dabd8aed825991ULL, 0x4c4e3aec985b67beULL,
        0xb10df0827fbf96a9ULL, 0x6a69279ad4f8dae1ULL, 0xe78689dcd3d5ff2eULL,
        0x812e1a2b1fa553d1ULL, 0xfbad90d6eba0ca18ULL, 0x1ac543b234310e39ULL,
        0x1604f7df2cb97827ULL, 0xa6241c6951189f02ULL, 0x753513cceaaf7c5eULL,
        0x64f2a59fc84c4efaULL, 0x247d2b1e489f5f5aULL, 0xdb64d718ab474c48ULL,
        0x79f4a7a1f2270a40ULL, 0x1573da832a9bebaeULL, 0x3497867968621c72ULL,
        0x514838d2a2302304ULL, 0xf0af6537fd72f685ULL, 0x1d06023e3a6b44baULL,
        0x678588c3ce6edd73ULL, 0x66a893f7cc70acffULL, 0xd4d24e29b5eda9dfULL,
        0x3856321470ea6a6cULL, 0x07c3418c0e5a4a83ULL, 0x2bcbb22f5635bacdULL,
        0x04b46cd00878d90aULL, 0x06ee5ab80c443b0fULL, 0x3b211f4876c8f9e5ULL,
        0x0958c38912eede98ULL, 0xd14b39cdbf8b0159ULL, 0x397b292072f41be0ULL,
        0x87c0409313e168deULL, 0xad26e98847caa39fULL, 0x4e140c849c6785bbULL,
        0xd5ff551db7f3d853ULL, 0xa0ca46d15d5ca40dULL, 0xcd6020c787fe346fULL,
        0x84b76dcf15c3fb57ULL, 0xdefda0fca121e4ceULL, 0x4b8d7b6096012d3dULL,
        0x9ac642ad298a2c64ULL, 0x0875d8bd10f0af14ULL, 0xb357c6ea7b8374acULL,
        0x4d6321d89a451632ULL, 0xeda96709c719b23fULL, 0xf76c24bbf328bc06ULL,
        0xc662d526912c08f2ULL, 0x3ce25ec47892b366ULL, 0xb978283f6f4f39bdULL,
        0xc08c8f9e9d6833fdULL, 0x4f3917b09e79f437ULL, 0x593de06fb2c08c10ULL,
        0xd6887841b1d14bdaULL, 0x19b26eee32139db0ULL, 0xb494876675d93e2fULL,
        0x825937771987c058ULL, 0x90e9ac783d466175ULL, 0xf1827e03ff6c8709ULL,
        0x945dc0a8353eb87fULL, 0x4516f9658ab5b926ULL, 0x3f9573987eb020efULL,
        0xb855330b6d514831ULL, 0x2ae6a91b542bcb41ULL, 0x6331e413c6160479ULL,
        0x408f8e8180d311a0ULL, 0xeff35161c325503aULL, 0xd06622f9bd9570d5ULL,
        0x8876d9a20d4b8d49ULL, 0xa5533135573a0c8bULL, 0xe168d364df91c421ULL,
        0xf41b09e7f50a2f8fULL, 0x12b09b0f24c1a12dULL, 0xda49cc2ca9593dc4ULL,
        0x1f5c34563e57a6bfULL, 0x54d14f36a8568b82ULL, 0xaf7cdfe043f6419aULL,
        0xea6a2685c943f8bcULL, 0xe5dcbfb4d7e91d2bULL, 0xb27addde799d0520ULL,
        0x6b443caed6e6ab6dULL, 0x7bae91c9f61be845ULL, 0x3eb868ac7cae5163ULL,
        0x11c7b65322e332a4ULL, 0xd23c1491b9a992d0ULL, 0x8fb5982e0311c7caULL,
        0x70ac6428e0c9d4d8ULL, 0x895bc2960f55fcc5ULL, 0x76423e90ec8defd7ULL,
        0x6ff0507ede9e7267ULL, 0x3dcf45f07a8cc2eaULL, 0x4aa06054941f5cb1ULL,
        0x5810fb5bb0defd9cULL, 0x5efea1e3bc9ac693ULL, 0x6edd4b4adc8003ebULL,
        0x741808f8e8b10dd2ULL, 0x145ec1b728859a22ULL, 0x28bc9f7350172944ULL,
        0x270a06424ebdccd3ULL, 0x972aedf4331c2bf6ULL, 0x059977e40a66a886ULL,
        0x2550302a4a812ed6ULL, 0xdd8a8da0a7037747ULL, 0xc515f87a970e9b7bULL,
        0x3023eaa9601ac578ULL, 0xb7e3aa3a73fbada6ULL, 0x0fb699311eaae597ULL,
        0x0000000000000000ULL, 0x310ef19d6204b4f4ULL, 0x229371a644db6455ULL,
        0x0decaf591a960792ULL, 0x5ca4978bb8a62496ULL, 0x1c2b190a38753536ULL,
        0x41a295b582cd602cULL, 0x3279dcc16426277dULL, 0xc1a194aa9f764271ULL,
        0x139d803b26dfd0a1ULL, 0xae51c4d441e83016ULL, 0xd813fa44ad65dfc1ULL,
        0xac0bf2bc45d4d213ULL, 0x23be6a9246c515d9ULL, 0x49d74d08923dcf38ULL,
        0x9d05032127d066e7ULL, 0x2f7fdeff5e4d63c7ULL, 0xa47e2a0155247d07ULL,
        0x99b16ff12fa8bfedULL, 0x4661d4398c972aafULL, 0xdfd0bbc8a33f9542ULL,
        0xdca79694a51d06cbULL, 0xb020ebb67da1e725ULL, 0xba0f0563696daa34ULL,
        0xe4f1a480d5f76ca7ULL, 0xc438e34e9510eaf7ULL, 0x939e81243b64f2fcULL,
        0x8defae46072d25cfULL, 0x2c08f3a3586ff04eULL, 0xd7a56375b3cf3a56ULL,
        0x20c947ce40e78650ULL, 0x43f8a3dd86f18229ULL, 0x568b795eac6a6987ULL,
        0x8003011f1dbb225dULL, 0xf53612d3f7145e03ULL, 0x189f75da300dec3cULL,
        0x9570db9c3720c9f3ULL, 0xbb221e576b73dbb8ULL, 0x72f65240e4f536ddULL,
        0x443be25188abc8aaULL, 0xe21ffe38d9b357a8ULL, 0xfd43ca6ee7e4f117ULL,
        0xcaa3614b89a47eecULL, 0xfe34e732e1c6629eULL, 0x83742c431b99b1d4ULL,
        0xcf3a16af83c2d66aULL, 0xaae5a8044990e91cULL, 0x26271d764ca3bd5fULL,
        0x91c4b74c3f5810f9ULL, 0x7c6dd045f841a2c6ULL, 0x7f1afd19fe63314fULL,
        0xc8f957238d989ce9ULL, 0xa709075d5306ee8eULL, 0x55fc5402aa48fa0eULL,
        0x48fa563c9023beb4ULL, 0x65dfbeabca523f76ULL, 0x6c877d22d8bce1eeULL,
        0xcc4d3bf385e045e3ULL, 0xbebb69b36115733eULL, 0x10eaad6720fd4328ULL,
        0xb6ceb10e71e5dc2aULL, 0xbdcc44ef6737e0b7ULL, 0x523f158ea412b08dULL,
        0x989c74c52db6ce61ULL, 0x9beb59992b945de8ULL, 0x8a2cefca09776f4cULL,
        0xa3bd6b8d5b7e3784ULL, 0xeb473db1cb5d8930ULL, 0xc3fba2c29b4aa074ULL,
        0x9c28181525ce176bULL, 0x683311f2d0c438e4ULL, 0x5fd3bad7be84b71fULL,
        0xfc6ed15ae5fa809bULL, 0x36cdb0116c5efe77ULL, 0x29918447520958c8ULL,
        0xa29070b959604608ULL, 0x53120ebaa60cc101ULL, 0x3a0c047c74d68869ULL,
        0x691e0ac6d2da4968ULL, 0x73db4974e6eb4751ULL, 0x7a838afdf40599c9ULL,
        0x5a4acd33b4e21f99ULL, 0x6046c94fc03497f0ULL, 0xe6ab92e8d1cb8ea2ULL,
        0x3354c7f5663856f1ULL, 0xd93ee170af7bae4dULL, 0x616bd27bc22ae67cULL,
        0x92b39a10397a8370ULL, 0xabc8b3304b8e9890ULL, 0xbf967287630b02b2ULL,
        0x5b67d607b6fc6e15ULL
    },
    {
        0xd031c397ce553fe6ULL, 0x16ba5b01b006b525ULL, 0xa89bade6296e70c8ULL,
        0x6a1f525d77d3435bULL, 0x6e103570573dfa0bULL, 0x660efb2a17fc95abULL,
        0x76327a9e97634bf6ULL, 0x4bad9d6462458bf5ULL, 0xf1830caedbc3f748ULL,
        0xc5c8f542669131ffULL, 0x95044a1cdc48b0cbULL, 0x892962df3cf8b866ULL,
        0xb0b9e208e930c135ULL, 0xa14fb3f0611a767cULL, 0x8d2605f21c160136ULL,
        0xd6b71922fecc549eULL, 0x37089438a5907d8bULL, 0x0b5da38e5803d49cULL,
        0x5a5bcc9cea6f3cbcULL, 0xedae246d3b73ffe5ULL, 0xd2b87e0fde22edceULL,
        0x5e54abb1ca8185ecULL, 0x1de7f88fe80561b9ULL, 0xad5e1a870135a08cULL,
        0x2f2adbd665cecc76ULL, 0x5780b5a782f58358ULL, 0x3edc8a2eede47b3fULL,
        0xc9d95c3506bee70fULL, 0x83be111d6c4e05eeULL, 0xa603b90959367410ULL,
        0x103c81b4809fde5dULL, 0x2c69b6027d0c774aULL, 0x399080d7d5c87953ULL,
        0x09d41e16487406b4ULL, 0xcdd63b1826505e5fULL, 0xf99dc2f49b0298e8ULL,
        0x9cd0540a943cb67fULL, 0xbca84b7f891f17c5ULL, 0x723d1db3b78df2a6ULL,
        0x78aa6e71e73b4f2eULL, 0x1433e699a071670dULL, 0x84f21be454620782ULL,
        0x98df3327b4d20f2fULL, 0xf049dce2d3769e5cULL, 0xdb6c60199656eb7aULL,
        0x648746b2078b4783ULL, 0x32cd23598dcbadcfULL, 0x1ea4955bf0c7da85ULL,
        0xe9a143401b9d46b5ULL, 0xfd92a5d9bbec21b8ULL, 0xc8138c790e0b8e1bULL,
        0x2ee00b9a6d7ba562ULL, 0xf85712b893b7f1fcULL, 0xeb28fed80bea949dULL,
        0x564a65eb8a40ea4cULL, 0x6c9988e8474a2823ULL, 0x4535898b121d8f2dULL,
        0xabd8c03231accbf4ULL, 0xba2e91cab9867cbdULL, 0x7960be3def8e263aULL,
        0x0c11a977602fd6f0ULL, 0xcb50e1ad16c93527ULL, 0xeae22e94035ffd89ULL,
        0x2866d12f5de2ce1aULL, 0xff1b1841ab9bf390ULL, 0x9f9339de8cfe0d43ULL,
        0x964727c8c48a0bf7ULL, 0x524502c6aaae531cULL, 0x9b9c5ef3ac10b413ULL,
        0x4fa2fa4942ab32a5ULL, 0x3f165a62e551122bULL, 0xc74148da76e6e3d7ULL,
        0x924840e5e464b2a7ULL, 0xd372ae43d69784daULL, 0x233b72a105e11a86ULL,
        0xa48a04914941a638ULL, 0xb4b68525c9de7865ULL, 0xddeabaaca6cf8002ULL,
        0x0a9773c250b6bd88ULL, 0xc284ffbb5ebd3393ULL, 0x8ba0df472c8f6a4eULL,
        0x2aef6cb74d951c32ULL, 0x427983722a318d41ULL, 0x73f7cdffbf389bb2ULL,
        0x074c0af9382c026cULL, 0x8a6a0f0b243a035aULL, 0x6fdae53c5f88931fULL,
        0xc68b98967e538ac3ULL, 0x44ff59c71aa8e639ULL, 0xe2fce0ce439e9229ULL,
        0xa20cde2479d8cd40ULL, 0x19e89fa2c8ebd8e9ULL, 0xf446bbcff398270cULL,
        0x43b3533e2284e455ULL, 0xd82f0dcd8e945046ULL, 0x51066f12b26ce820ULL,
        0xe73957af6bc5426dULL, 0x081ece5a40c16fa0ULL, 0x3b193d4fc5bfab7bULL,
        0x7fe66488df174d42ULL, 0x0e9814ef705804d8ULL, 0x8137ac857c39d7c6ULL,
        0xb1733244e185a821ULL, 0x695c3f896f11f867ULL, 0xf6cf0657e3eff524ULL,
        0x1aabf276d02963d5ULL, 0x2da3664e75b91e5eULL, 0x0289bd981077d228ULL,
        0x90c1fd7df413608fULL, 0x3c5537b6fd93a917ULL, 0xaa12107e3919a2e0ULL,
        0x0686dab530996b78ULL, 0xdaa6b0559ee3826eULL, 0xc34e2ff756085a87ULL,
        0x6d5358a44fff4137ULL, 0xfc587595b35948acULL, 0x7ca5095cc7d5f67eULL,
        0xfb147f6c8b754ac0ULL, 0xbfeb26ab91ddacf9ULL, 0x6896efc567a49173ULL,
        0xca9a31e11e7c5c33ULL, 0xbbe44186b13315a9ULL, 0x0ddb793b689abfe4ULL,
        0x70b4a02ba7fa208eULL, 0xe47a3a7b7307f951ULL, 0x8cecd5be14a36822ULL,
        0xeeed49b923b144d9ULL, 0x17708b4db8b3dc31ULL, 0x6088219f2765fed3ULL,
        0xb3fa8fdcf1f27a09ULL, 0x910b2d31fca6099bULL, 0x0f52c4a378ed6dccULL,
        0x50ccbf5ebad98134ULL, 0x6bd582117f662a4fULL, 0x94ce9a50d4fdd9dfULL,
        0x2b25bcfb45207526ULL, 0x67c42b661f49fcbfULL, 0x492420fc723259ddULL,
        0x03436dd418c2bb3cULL, 0x1f6e4517f872b391ULL, 0xa08563bc69af1f68ULL,
        0xd43ea4baeebb86b6ULL, 0x01cad04c08b56914ULL, 0xac94cacb0980c998ULL,
        0x54c3d8739a373864ULL, 0x26fec5c02dbacac2ULL, 0xdea9d778be0d3b3eULL,
        0x040f672d20eeb950ULL, 0xe5b0ea377bb29045ULL, 0xf30ab136cbb42560ULL,
        0x62019c0737122cfbULL, 0xe86b930c13282fa1ULL, 0xcc1ceb542ee5374bULL,
        0x538fd28aa21b3a08ULL, 0x1b61223ad89c0ac1ULL, 0x36c24474ad25149fULL,
        0x7a23d3e9f74c9d06ULL, 0xbe21f6e79968c5edULL, 0xcf5f868036278c77ULL,
        0xf705d61beb5a9c30ULL, 0x4d2b47d152dce08dULL, 0x5f9e7bfdc234ecf8ULL,
        0x247778583dcd18eaULL, 0x867ba67c4415d5aaULL, 0x4ce1979d5a698999ULL,
        0x0000000000000000ULL, 0xec64f42133c696f1ULL, 0xb57c5569c16b1171ULL,
        0xc1c7926f467f88afULL, 0x654d96fe0f3e2e97ULL, 0x15f936d5a8c40e19ULL,
        0xb8a72c52a9f1ae95ULL, 0xa9517daa21db19dcULL, 0x58d27104fa18ee94ULL,
        0x5918a148f2ad8780ULL, 0x5cdd1629daf657c4ULL, 0x8274c15164fb6cfaULL,
        0xd1fb13dbc6e056f2ULL, 0x7d6fd910cf609f6aULL, 0xb63f38bdd9a9aa4dULL,
        0x3d9fe7faf526c003ULL, 0x74bbc706871499deULL, 0xdf630734b6b8522aULL,
        0x3ad3ed03cd0ac26fULL, 0xfadeaf2083c023d4ULL, 0xc00d42234ecae1bbULL,
        0x8538cba85cd76e96ULL, 0xc402250e6e2458ebULL, 0x47bc3413026a5d05ULL,
        0xafd7a71f114272a4ULL, 0x978df784cc3f62e3ULL, 0xb96dfc1ea144c781ULL,
        0x21b2cf391596c8aeULL, 0x318e4e8d950916f3ULL, 0xce9556cc3e92e563ULL,
        0x385a509bdd7d1047ULL, 0x358129a0b5e7afa3ULL, 0xe6f387e363702b79ULL,
        0xe0755d5653e94001ULL, 0x7be903a5fff9f412ULL, 0x12b53c2c90e80c75ULL,
        0x3307f315857ec4dbULL, 0x8fafb86a0c61d31eULL, 0xd9e5dd8186213952ULL,
        0x77f8aad29fd622e2ULL, 0x25bda814357871feULL, 0x7571174a8fa1f0caULL,
        0x137fec60985d6561ULL, 0x30449ec19dbc7fe7ULL, 0xa540d4dd41f4cf2cULL,
        0xdc206ae0ae7ae916ULL, 0x5b911cd0e2da55a8ULL, 0xb2305f90f947131dULL,
        0x344bf9ecbd52c6b7ULL, 0x5d17c665d2433ed0ULL, 0x18224feec05eb1fdULL,
        0x9e59e992844b6457ULL, 0x9a568ebfa4a5dd07ULL, 0xa3c60e68716da454ULL,
        0x7e2cb4c4d7a22456ULL, 0x87b176304ca0bcbeULL, 0x413aeea632f3367dULL,
        0x9915e36bbc67663bULL, 0x40f03eea3a465f69ULL, 0x1c2d28c3e0b008adULL,
        0x4e682a054a1e5bb1ULL, 0x05c5b761285bd044ULL, 0xe1bf8d1a5b5c2915ULL,
        0xf2c0617ac3014c74ULL, 0xb7f5e8f1d11cc359ULL, 0x63cb4c4b3fa745efULL,
        0x9d1a84469c89df6bULL, 0xe33630824b2bfb3dULL, 0xd5f474f6e60eefa2ULL,
        0xf58c6b83fb2d4e18ULL, 0x4676e45f0adf3411ULL, 0x20781f751d23a1baULL,
        0xbd629b3381aa7ed1ULL, 0xae1d775319f71bb0ULL, 0xfed1c80da32e9a84ULL,
        0x5509083f92825170ULL, 0x29ac01635557a70eULL, 0xa7c9694551831d04ULL,
        0x8e65682604d4ba0aULL, 0x11f651f8882ab749ULL, 0xd77dc96ef6793d8aULL,
        0xef2799f52b042dcdULL, 0x48eef0b07a8730c9ULL, 0x22f1a2ed0d547392ULL,
        0x6142f1d32fd097c7ULL, 0x4a674d286af0e2e1ULL, 0x80fd7cc9748cbed2ULL,
        0x717e7067af4f499aULL, 0x938290a9ecd1dbb3ULL, 0x88e3b293344dd172ULL,
        0x2734158c250fa3d6ULL
    }
};
#endif
