"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const base_command_1 = require("./base-command");
const InteropService_1 = require("@joplin/lib/services/interop/InteropService");
const BaseModel_1 = require("@joplin/lib/BaseModel");
const app_1 = require("./app");
const locale_1 = require("@joplin/lib/locale");
class Command extends base_command_1.default {
    usage() {
        return 'export <path>';
    }
    description() {
        return (0, locale_1._)('Exports Joplin data to the given path. By default, it will export the complete database including notebooks, notes, tags and resources.');
    }
    options() {
        const service = InteropService_1.default.instance();
        const formats = service
            .modules()
            .filter(m => m.type === 'exporter' && m.format !== 'html')
            .map(m => m.format + (m.description ? ` (${m.description})` : ''));
        return [['--format <format>', (0, locale_1._)('Destination format: %s', formats.join(', '))], ['--note <note>', (0, locale_1._)('Exports only the given note.')], ['--notebook <notebook>', (0, locale_1._)('Exports only the given notebook.')]];
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    async action(args) {
        const exportOptions = {};
        exportOptions.path = args.path;
        exportOptions.format = args.options.format ? args.options.format : 'jex';
        if (exportOptions.format === 'html')
            throw new Error('HTML export is not supported. Please use the desktop application.');
        if (args.options.note) {
            const notes = await (0, app_1.default)().loadItems(BaseModel_1.default.TYPE_NOTE, args.options.note, { parent: (0, app_1.default)().currentFolder() });
            if (!notes.length)
                throw new Error((0, locale_1._)('Cannot find "%s".', args.options.note));
            // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
            exportOptions.sourceNoteIds = notes.map((n) => n.id);
        }
        else if (args.options.notebook) {
            const folders = await (0, app_1.default)().loadItems(BaseModel_1.default.TYPE_FOLDER, args.options.notebook);
            if (!folders.length)
                throw new Error((0, locale_1._)('Cannot find "%s".', args.options.notebook));
            // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
            exportOptions.sourceFolderIds = folders.map((n) => n.id);
        }
        const service = InteropService_1.default.instance();
        const result = await service.export(exportOptions);
        result.warnings.map(w => this.stdout(w));
    }
}
module.exports = Command;
//# sourceMappingURL=command-export.js.map