"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const BaseCommand = require('./base-command').default;
const registry_1 = require("@joplin/lib/registry");
const Note_1 = require("@joplin/lib/models/Note");
const uuid_1 = require("@joplin/lib/uuid");
const populateDatabase_1 = require("@joplin/lib/services/debug/populateDatabase");
const credentialFiles_1 = require("@joplin/lib/utils/credentialFiles");
const JoplinServerApi_1 = require("@joplin/lib/JoplinServerApi");
// eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
function randomElement(array) {
    if (!array.length)
        return null;
    return array[Math.floor(Math.random() * array.length)];
}
// eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
function itemCount(args) {
    const count = Number(args.arg0);
    if (!count || isNaN(count))
        throw new Error('Note count must be specified');
    return count;
}
class Command extends BaseCommand {
    usage() {
        return 'testing <command> [arg0]';
    }
    description() {
        return 'testing';
    }
    enabled() {
        return false;
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    options() {
        return [
            ['--folder-count <count>', 'Folders to create'],
            ['--note-count <count>', 'Notes to create'],
            ['--tag-count <count>', 'Tags to create'],
            ['--tags-per-note <count>', 'Tags per note'],
            ['--silent', 'Silent'],
        ];
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    async action(args) {
        const { command, options } = args;
        if (command === 'populate') {
            await (0, populateDatabase_1.default)(registry_1.reg.db(), {
                folderCount: options['folder-count'],
                noteCount: options['note-count'],
                tagCount: options['tag-count'],
                tagsPerNote: options['tags-per-note'],
                silent: options['silent'],
            });
        }
        // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
        const promises = [];
        if (command === 'createRandomNotes') {
            const noteCount = itemCount(args);
            for (let i = 0; i < noteCount; i++) {
                promises.push(Note_1.default.save({
                    title: `Note ${uuid_1.default.createNano()}`,
                }));
            }
        }
        if (command === 'updateRandomNotes') {
            const noteCount = itemCount(args);
            const noteIds = await Note_1.default.allIds();
            for (let i = 0; i < noteCount; i++) {
                const noteId = randomElement(noteIds);
                promises.push(Note_1.default.save({
                    id: noteId,
                    title: `Note ${uuid_1.default.createNano()}`,
                }));
            }
        }
        if (command === 'deleteRandomNotes') {
            const noteCount = itemCount(args);
            const noteIds = await Note_1.default.allIds();
            for (let i = 0; i < noteCount; i++) {
                const noteId = randomElement(noteIds);
                promises.push(Note_1.default.delete(noteId, { sourceDescription: 'command-testing' }));
            }
        }
        if (command === 'joplinServerParallelItemUpdate') {
            const randomContent = () => {
                const charCount = Math.random() * 1000;
                return 'a'.repeat(charCount);
            };
            const joplinServerAuth = JSON.parse(await (0, credentialFiles_1.readCredentialFile)('joplin-server-test.json'));
            const api = new JoplinServerApi_1.default({
                baseUrl: () => joplinServerAuth.baseUrl,
                userContentBaseUrl: () => joplinServerAuth.userContentBaseUrl,
                username: () => joplinServerAuth.email,
                password: () => joplinServerAuth.password,
                session: () => null,
            });
            const apiPut = async () => {
                await api.exec('PUT', 'api/items/root:/testing:/content', {}, randomContent(), {
                    'Content-Type': 'application/octet-stream',
                });
            };
            await apiPut();
            const promises = [];
            for (let i = 0; i < 100; i++) {
                promises.push(void apiPut());
            }
            await Promise.all(promises);
            // eslint-disable-next-line no-console
            console.info(await api.exec('GET', 'api/items/root:/testing:'));
        }
        await Promise.all(promises);
    }
}
module.exports = Command;
//# sourceMappingURL=command-testing.js.map