"use strict";
// On mobile all the setTimeout and setInterval should go through this class
// as it will either use the native timeout/interval for short intervals or
// the custom one for long intervals.
Object.defineProperty(exports, "__esModule", { value: true });
// For custom intervals, they are triggered
// whenever the update() function is called, and in mobile it's called for
// example on the Redux action middleware or when the app gets focus.
const time_1 = require("@joplin/utils/time");
const time_2 = require("./time");
class PoorManIntervals {
    // eslint-disable-next-line @typescript-eslint/ban-types -- Old code before rule was applied
    static setInterval(callback, interval) {
        if (interval <= this.maxNativeTimerDuration_)
            return setInterval(callback, interval);
        this.intervalId_++;
        const id = this.intervalId_;
        this.intervals_[id] = {
            id: id,
            callback: callback,
            interval: interval,
            lastIntervalTime: time_2.default.unixMs(),
            isTimeout: false,
        };
        return id;
    }
    // eslint-disable-next-line @typescript-eslint/ban-types -- Old code before rule was applied
    static setTimeout(callback, interval) {
        if (interval <= this.maxNativeTimerDuration_)
            return setTimeout(callback, interval);
        this.intervalId_++;
        const id = this.intervalId_;
        this.intervals_[id] = {
            id: id,
            callback: callback,
            interval: interval,
            lastIntervalTime: time_2.default.unixMs(),
            isTimeout: true,
        };
        return id;
    }
    static clearInterval(id) {
        const r = this.intervals_[id];
        if (!r) {
            clearInterval(id);
        }
        else {
            delete this.intervals_[id];
        }
    }
    static clearTimeout(id) {
        const r = this.intervals_[id];
        if (!r) {
            clearTimeout(id);
        }
        else {
            delete this.intervals_[id];
        }
    }
    static update() {
        // Don't update more than once a second
        if (this.lastUpdateTime_ + 1000 > time_2.default.unixMs())
            return;
        for (const id in this.intervals_) {
            const interval = this.intervals_[id];
            const now = time_2.default.unixMs();
            if (now - interval.lastIntervalTime >= interval.interval) {
                interval.lastIntervalTime = now;
                interval.callback();
                if (interval.isTimeout) {
                    this.clearTimeout(interval.id);
                }
            }
        }
        this.lastUpdateTime_ = time_2.default.unixMs();
    }
}
// We disable the custom logic since React Native no longer emit a warning for long timer, and
// using long timers is fine as long as we are fine with it not being triggered while the app is
// in the background:
// https://github.com/facebook/react-native/issues/12981#issuecomment-652745831
PoorManIntervals.maxNativeTimerDuration_ = 24 * time_1.Hour; // 10 * 1000;
PoorManIntervals.lastUpdateTime_ = 0;
PoorManIntervals.intervalId_ = 0;
PoorManIntervals.intervals_ = {};
exports.default = PoorManIntervals;
//# sourceMappingURL=PoorManIntervals.js.map