"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shim_1 = require("./shim");
class RotatingLogs {
    constructor(logFilesDir, maxFileSize = null, inactiveMaxAge = null) {
        this.maxFileSize = 1024 * 1024 * 100;
        this.inactiveMaxAge = 90 * 24 * 60 * 60 * 1000;
        this.logFilesDir = logFilesDir;
        if (maxFileSize)
            this.maxFileSize = maxFileSize;
        if (inactiveMaxAge)
            this.inactiveMaxAge = inactiveMaxAge;
    }
    async cleanActiveLogFile() {
        const stats = await this.fsDriver().stat(this.logFileFullpath());
        if (stats.size >= this.maxFileSize) {
            const newLogFile = this.logFileFullpath(this.getNameToNonActiveLogFile());
            await this.fsDriver().move(this.logFileFullpath(), newLogFile);
        }
    }
    getNameToNonActiveLogFile() {
        return `log-${Date.now()}.txt`;
    }
    async deleteNonActiveLogFiles() {
        const files = await this.fsDriver().readDirStats(this.logFilesDir);
        for (const file of files) {
            if (!file.path.match(/^log-[0-9]+.txt$/gi))
                continue;
            const timestamp = parseInt(file.path.match(/[0-9]+/g)[0], 10);
            const ageOfTheFile = Date.now() - timestamp;
            if (ageOfTheFile >= this.inactiveMaxAge) {
                await this.fsDriver().remove(this.logFileFullpath(file.path));
            }
        }
    }
    logFileFullpath(fileName = 'log.txt') {
        return `${this.logFilesDir}/${fileName}`;
    }
    fsDriver() {
        return shim_1.default.fsDriver();
    }
}
exports.default = RotatingLogs;
//# sourceMappingURL=RotatingLogs.js.map