"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const BaseSyncTarget_1 = require("./BaseSyncTarget");
const locale_1 = require("./locale");
const Setting_1 = require("./models/Setting");
const file_api_1 = require("./file-api");
const file_api_driver_local_1 = require("./file-api-driver-local");
const Synchronizer_1 = require("./Synchronizer");
class SyncTargetFilesystem extends BaseSyncTarget_1.default {
    static id() {
        return 2;
    }
    static targetName() {
        return 'filesystem';
    }
    static label() {
        return (0, locale_1._)('File system');
    }
    static unsupportedPlatforms() {
        return ['ios'];
    }
    async isAuthenticated() {
        return true;
    }
    syncPath_() {
        return Setting_1.default.value('sync.2.path');
    }
    async initFileApi() {
        const driver = new file_api_driver_local_1.default();
        const fileApi = new file_api_1.FileApi(() => {
            // The sync path can be set by the user after startup, so needs to be
            // determined dynamically.
            return this.syncPath_();
        }, driver);
        fileApi.setLogger(this.logger());
        fileApi.setSyncTargetId(SyncTargetFilesystem.id());
        const syncPath = this.syncPath_();
        await driver.mkdir(syncPath);
        return fileApi;
    }
    async initSynchronizer() {
        const api = await this.fileApi();
        return new Synchronizer_1.default(this.db(), api, Setting_1.default.value('appType'));
    }
}
exports.default = SyncTargetFilesystem;
//# sourceMappingURL=SyncTargetFilesystem.js.map