"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const locale_1 = require("../../../locale");
const Revision_1 = require("../../../models/Revision");
const shim_1 = require("../../../shim");
const { useCallback } = shim_1.default.react();
const useDeleteHistoryClick = ({ noteId, setDeleting, resetScreenState, }) => {
    return useCallback(async () => {
        if (!noteId)
            return;
        const response = await shim_1.default.showMessageBox((0, locale_1._)('Are you sure you want to delete all history for this note? This cannot be undone.'), {
            title: (0, locale_1._)('Warning'),
            buttons: [(0, locale_1._)('Yes'), (0, locale_1._)('No')],
            type: shim_1.MessageBoxType.Confirm,
        });
        if (response === 0) {
            setDeleting(true);
            try {
                await Revision_1.default.deleteHistoryForNote(noteId);
                await shim_1.default.showMessageBox((0, locale_1._)('Note history has been deleted.'), { type: shim_1.MessageBoxType.Info });
            }
            finally {
                setDeleting(false);
            }
            resetScreenState();
        }
    }, [noteId, setDeleting, resetScreenState]);
};
exports.default = useDeleteHistoryClick;
//# sourceMappingURL=useDeleteHistoryClick.js.map