"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const Setting_1 = require("../../models/Setting");
const shim_1 = require("../../shim");
const SyncTargetJoplinServerSAML_1 = require("../../SyncTargetJoplinServerSAML");
const prefixWithHttps_1 = require("../../utils/prefixWithHttps");
class SamlShared {
    openLoginPage() {
        shim_1.default.openUrl(`${(0, prefixWithHttps_1.default)(Setting_1.default.value('sync.11.path'))}/login/sso-saml-app`);
        return Promise.resolve();
    }
    processLoginCode(code) {
        if (this.isLoginCodeValid(code)) {
            return (0, SyncTargetJoplinServerSAML_1.authenticateWithCode)(this.cleanCode(code));
        }
        else {
            return Promise.resolve(false);
        }
    }
    isLoginCodeValid(code) {
        const cleanedCode = this.cleanCode(code);
        return !isNaN(+cleanedCode) && cleanedCode.length === 9;
    }
    cleanCode(code) {
        return code.replace(/\s|-/gi, '');
    }
}
exports.default = SamlShared;
//# sourceMappingURL=SamlShared.js.map