"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const Setting_1 = require("../models/Setting");
const SyncTargetJoplinServer_1 = require("../SyncTargetJoplinServer");
class DebugService {
    constructor(db) {
        this.db_ = db;
    }
    get db() {
        return this.db_;
    }
    async clearSyncState() {
        const tableNames = [
            'item_changes',
            'deleted_items',
            'sync_items',
            'key_values',
        ];
        const queries = [];
        for (const n of tableNames) {
            queries.push(`DELETE FROM ${n}`);
            queries.push(`DELETE FROM sqlite_sequence WHERE name="${n}"`); // Reset autoincremented IDs
        }
        for (let i = 0; i < 20; i++) {
            queries.push(`DELETE FROM settings WHERE key="sync.${i}.context"`);
            queries.push(`DELETE FROM settings WHERE key="sync.${i}.auth"`);
        }
        await this.db.transactionExecBatch(queries);
    }
    async setupJoplinServerUser(num) {
        const id = SyncTargetJoplinServer_1.default.id();
        Setting_1.default.setValue('sync.target', id);
        Setting_1.default.setValue(`sync.${id}.path`, 'http://localhost:22300');
        Setting_1.default.setValue(`sync.${id}.username`, `user${num}@example.com`);
        Setting_1.default.setValue(`sync.${id}.password`, '123456');
    }
}
exports.default = DebugService;
//# sourceMappingURL=DebugService.js.map