"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const getActivePluginEditorViews_1 = require("../../services/plugins/utils/getActivePluginEditorViews");
const shim_1 = require("../../shim");
const { useMemo } = shim_1.default.react();
const useVisiblePluginEditorViewIds = (plugins, windowId) => {
    return useMemo(() => {
        const visibleViews = (0, getActivePluginEditorViews_1.default)(plugins, windowId, { mustBeVisible: true });
        return visibleViews.flatMap(({ editorView }) => editorView.id);
    }, [plugins, windowId]);
};
exports.default = useVisiblePluginEditorViewIds;
//# sourceMappingURL=useVisiblePluginEditorViewIds.js.map