"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.defaultState = void 0;
const immer_1 = require("immer");
const reducer_1 = require("../../reducer");
exports.defaultState = {
    watchedResources: {},
};
// eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
const reducer = (0, immer_1.produce)((draft, action) => {
    var _a;
    if (action.type.indexOf('RESOURCE_EDIT_WATCHER_') !== 0)
        return;
    try {
        switch (action.type) {
            case 'RESOURCE_EDIT_WATCHER_SET':
                draft.watchedResources[action.id] = {
                    id: action.id,
                    title: action.title,
                };
                break;
            case 'RESOURCE_EDIT_WATCHER_REMOVE':
                // RESOURCE_EDIT_WATCHER_REMOVE signals that a resource is no longer being watched.
                // As such, it should be removed from all windows' resource lists:
                for (const windowId in draft.backgroundWindows) {
                    // watchedResources is per-window only on desktop:
                    if ('watchedResources' in draft.backgroundWindows[windowId]) {
                        delete draft.backgroundWindows[windowId].watchedResources[action.id];
                    }
                }
                delete draft.watchedResources[action.id];
                break;
            case 'RESOURCE_EDIT_WATCHER_CLEAR': {
                const windowState = reducer_1.stateUtils.windowStateById(draft, (_a = action.windowId) !== null && _a !== void 0 ? _a : reducer_1.defaultWindowId);
                // The window may have already been closed.
                const windowExists = !!windowState;
                if (windowExists) {
                    windowState.watchedResources = {};
                }
                break;
            }
        }
    }
    catch (error) {
        error.message = `In plugin reducer: ${error.message} Action: ${JSON.stringify(action)}`;
        throw error;
    }
});
exports.default = reducer;
//# sourceMappingURL=reducer.js.map