"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const trash_1 = require("../trash");
const stateToWhenClauseContext_1 = require("./stateToWhenClauseContext");
describe('stateToWhenClauseContext', () => {
    it('should be in trash if selected note has been deleted and selected folder is trash', async () => {
        const applicationState = {
            selectedNoteIds: ['1'],
            selectedFolderId: (0, trash_1.getTrashFolderId)(),
            notes: [
                { id: '1', deleted_time: 1722567036580 },
            ],
            folders: [],
        };
        const resultingState = (0, stateToWhenClauseContext_1.default)(applicationState);
        expect(resultingState.inTrash).toBe(true);
    });
    it('should NOT be in trash if selected note has not been deleted', async () => {
        const applicationState = {
            selectedNoteIds: ['1'],
            selectedFolderId: (0, trash_1.getTrashFolderId)(),
            notes: [
                { id: '1', deleted_time: 0 },
            ],
            folders: [],
        };
        const resultingState = (0, stateToWhenClauseContext_1.default)(applicationState);
        expect(resultingState.inTrash).toBe(false);
    });
    it('should NOT be in trash if selected folder is not trash', async () => {
        const applicationState = {
            selectedNoteIds: ['1'],
            selectedFolderId: 'any-other-folder',
            notes: [
                { id: '1', deleted_time: 1722567036580 },
            ],
            folders: [],
        };
        const resultingState = (0, stateToWhenClauseContext_1.default)(applicationState);
        expect(resultingState.inTrash).toBe(false);
    });
    it('should be in trash if command folder is deleted', async () => {
        const applicationState = {
            notes: [],
            notesParentType: 'Folder',
            folders: [
                { id: '1', deleted_time: 1722567036580, share_id: '', parent_id: '' },
            ],
        };
        const resultingState = (0, stateToWhenClauseContext_1.default)(applicationState, { commandFolderId: '1' });
        expect(resultingState.inTrash).toBe(true);
    });
    it('should NOT be in trash if command folder is not deleted', async () => {
        const applicationState = {
            notes: [],
            folders: [
                { id: '1', deleted_time: 0, share_id: '', parent_id: '' },
            ],
        };
        const resultingState = (0, stateToWhenClauseContext_1.default)(applicationState, { commandFolderId: '1' });
        expect(resultingState.inTrash).toBe(false);
    });
    it('should not be in trash if viewing all notes', async () => {
        const applicationState = {
            selectedFolderId: 'folder',
            notesParentType: 'SmartFolder',
        };
        const resultingState = (0, stateToWhenClauseContext_1.default)(applicationState);
        expect(resultingState.inTrash).toBe(false);
    });
});
//# sourceMappingURL=stateToWhenClauseContext.test.js.map