"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.databaseSchema = exports.ResourceOcrDriverId = exports.ResourceOcrStatus = exports.defaultFolderIcon = exports.FolderIconType = void 0;
var FolderIconType;
(function (FolderIconType) {
    FolderIconType[FolderIconType["Emoji"] = 1] = "Emoji";
    FolderIconType[FolderIconType["DataUrl"] = 2] = "DataUrl";
    FolderIconType[FolderIconType["FontAwesome"] = 3] = "FontAwesome";
})(FolderIconType || (exports.FolderIconType = FolderIconType = {}));
const defaultFolderIcon = () => {
    const icon = {
        type: FolderIconType.Emoji,
        emoji: '',
        name: '',
        dataUrl: '',
    };
    return icon;
};
exports.defaultFolderIcon = defaultFolderIcon;
var ResourceOcrStatus;
(function (ResourceOcrStatus) {
    ResourceOcrStatus[ResourceOcrStatus["Todo"] = 0] = "Todo";
    ResourceOcrStatus[ResourceOcrStatus["Processing"] = 1] = "Processing";
    ResourceOcrStatus[ResourceOcrStatus["Done"] = 2] = "Done";
    ResourceOcrStatus[ResourceOcrStatus["Error"] = 3] = "Error";
})(ResourceOcrStatus || (exports.ResourceOcrStatus = ResourceOcrStatus = {}));
var ResourceOcrDriverId;
(function (ResourceOcrDriverId) {
    ResourceOcrDriverId[ResourceOcrDriverId["PrintedText"] = 1] = "PrintedText";
    ResourceOcrDriverId[ResourceOcrDriverId["HandwrittenText"] = 2] = "HandwrittenText";
})(ResourceOcrDriverId || (exports.ResourceOcrDriverId = ResourceOcrDriverId = {}));
exports.databaseSchema = {
    folders: {
        created_time: { type: 'number' },
        deleted_time: { type: 'number' },
        encryption_applied: { type: 'number' },
        encryption_cipher_text: { type: 'string' },
        icon: { type: 'string' },
        id: { type: 'string' },
        is_shared: { type: 'number' },
        master_key_id: { type: 'string' },
        parent_id: { type: 'string' },
        share_id: { type: 'string' },
        title: { type: 'string' },
        updated_time: { type: 'number' },
        user_created_time: { type: 'number' },
        user_data: { type: 'string' },
        user_updated_time: { type: 'number' },
        type_: { type: 'number' },
    },
    tags: {
        created_time: { type: 'number' },
        encryption_applied: { type: 'number' },
        encryption_cipher_text: { type: 'string' },
        id: { type: 'string' },
        is_shared: { type: 'number' },
        parent_id: { type: 'string' },
        title: { type: 'string' },
        updated_time: { type: 'number' },
        user_created_time: { type: 'number' },
        user_data: { type: 'string' },
        user_updated_time: { type: 'number' },
        type_: { type: 'number' },
    },
    note_tags: {
        created_time: { type: 'number' },
        encryption_applied: { type: 'number' },
        encryption_cipher_text: { type: 'string' },
        id: { type: 'string' },
        is_shared: { type: 'number' },
        note_id: { type: 'string' },
        tag_id: { type: 'string' },
        updated_time: { type: 'number' },
        user_created_time: { type: 'number' },
        user_updated_time: { type: 'number' },
        type_: { type: 'number' },
    },
    table_fields: {
        field_default: { type: 'string' },
        field_name: { type: 'string' },
        field_type: { type: 'number' },
        id: { type: 'number' },
        table_name: { type: 'string' },
        type_: { type: 'number' },
    },
    sync_items: {
        force_sync: { type: 'number' },
        id: { type: 'number' },
        item_id: { type: 'string' },
        item_location: { type: 'number' },
        item_type: { type: 'number' },
        sync_disabled: { type: 'number' },
        sync_disabled_reason: { type: 'string' },
        sync_target: { type: 'number' },
        sync_time: { type: 'number' },
        sync_warning_ignored: { type: 'number' },
        type_: { type: 'number' },
    },
    version: {
        table_fields_version: { type: 'number' },
        version: { type: 'number' },
        type_: { type: 'number' },
    },
    deleted_items: {
        deleted_time: { type: 'number' },
        id: { type: 'number' },
        item_id: { type: 'string' },
        item_type: { type: 'number' },
        sync_target: { type: 'number' },
        type_: { type: 'number' },
    },
    settings: {
        key: { type: 'string' },
        value: { type: 'string' },
        type_: { type: 'number' },
    },
    alarms: {
        id: { type: 'number' },
        note_id: { type: 'string' },
        trigger_time: { type: 'number' },
        type_: { type: 'number' },
    },
    item_changes: {
        before_change_item: { type: 'string' },
        created_time: { type: 'number' },
        id: { type: 'number' },
        item_id: { type: 'string' },
        item_type: { type: 'number' },
        source: { type: 'number' },
        type: { type: 'number' },
        type_: { type: 'number' },
    },
    note_resources: {
        id: { type: 'number' },
        is_associated: { type: 'number' },
        last_seen_time: { type: 'number' },
        note_id: { type: 'string' },
        resource_id: { type: 'string' },
        type_: { type: 'number' },
    },
    resource_local_states: {
        fetch_error: { type: 'string' },
        fetch_status: { type: 'number' },
        id: { type: 'number' },
        resource_id: { type: 'string' },
        type_: { type: 'number' },
    },
    resources: {
        blob_updated_time: { type: 'number' },
        created_time: { type: 'number' },
        encryption_applied: { type: 'number' },
        encryption_blob_encrypted: { type: 'number' },
        encryption_cipher_text: { type: 'string' },
        file_extension: { type: 'string' },
        filename: { type: 'string' },
        id: { type: 'string' },
        is_shared: { type: 'number' },
        master_key_id: { type: 'string' },
        mime: { type: 'string' },
        ocr_details: { type: 'string' },
        ocr_driver_id: { type: 'number' },
        ocr_error: { type: 'string' },
        ocr_status: { type: 'number' },
        ocr_text: { type: 'string' },
        share_id: { type: 'string' },
        size: { type: 'number' },
        title: { type: 'string' },
        updated_time: { type: 'number' },
        user_created_time: { type: 'number' },
        user_data: { type: 'string' },
        user_updated_time: { type: 'number' },
        type_: { type: 'number' },
    },
    revisions: {
        body_diff: { type: 'string' },
        created_time: { type: 'number' },
        encryption_applied: { type: 'number' },
        encryption_cipher_text: { type: 'string' },
        id: { type: 'string' },
        item_id: { type: 'string' },
        item_type: { type: 'number' },
        item_updated_time: { type: 'number' },
        metadata_diff: { type: 'string' },
        parent_id: { type: 'string' },
        title_diff: { type: 'string' },
        updated_time: { type: 'number' },
        type_: { type: 'number' },
    },
    migrations: {
        created_time: { type: 'number' },
        id: { type: 'number' },
        number: { type: 'number' },
        updated_time: { type: 'number' },
        type_: { type: 'number' },
    },
    resources_to_download: {
        created_time: { type: 'number' },
        id: { type: 'number' },
        resource_id: { type: 'string' },
        updated_time: { type: 'number' },
        type_: { type: 'number' },
    },
    key_values: {
        id: { type: 'number' },
        key: { type: 'string' },
        type: { type: 'number' },
        updated_time: { type: 'number' },
        value: { type: 'string' },
        type_: { type: 'number' },
    },
    notes: {
        altitude: { type: 'number' },
        application_data: { type: 'string' },
        author: { type: 'string' },
        body: { type: 'string' },
        conflict_original_id: { type: 'string' },
        created_time: { type: 'number' },
        deleted_time: { type: 'number' },
        encryption_applied: { type: 'number' },
        encryption_cipher_text: { type: 'string' },
        id: { type: 'string' },
        is_conflict: { type: 'number' },
        is_shared: { type: 'number' },
        is_todo: { type: 'number' },
        latitude: { type: 'number' },
        longitude: { type: 'number' },
        markup_language: { type: 'number' },
        master_key_id: { type: 'string' },
        order: { type: 'number' },
        parent_id: { type: 'string' },
        share_id: { type: 'string' },
        source: { type: 'string' },
        source_application: { type: 'string' },
        source_url: { type: 'string' },
        title: { type: 'string' },
        todo_completed: { type: 'number' },
        todo_due: { type: 'number' },
        updated_time: { type: 'number' },
        user_created_time: { type: 'number' },
        user_data: { type: 'string' },
        user_updated_time: { type: 'number' },
        type_: { type: 'number' },
    },
    notes_normalized: {
        altitude: { type: 'number' },
        body: { type: 'string' },
        id: { type: 'string' },
        is_todo: { type: 'number' },
        latitude: { type: 'number' },
        longitude: { type: 'number' },
        parent_id: { type: 'string' },
        source_url: { type: 'string' },
        title: { type: 'string' },
        todo_completed: { type: 'number' },
        todo_due: { type: 'number' },
        user_created_time: { type: 'number' },
        user_updated_time: { type: 'number' },
        type_: { type: 'number' },
    },
    items_normalized: {
        body: { type: 'string' },
        id: { type: 'number' },
        item_id: { type: 'string' },
        item_type: { type: 'number' },
        reserved1: { type: 'number' },
        reserved2: { type: 'number' },
        reserved3: { type: 'number' },
        reserved4: { type: 'number' },
        reserved5: { type: 'number' },
        reserved6: { type: 'number' },
        title: { type: 'string' },
        user_updated_time: { type: 'number' },
        type_: { type: 'number' },
    },
    items_fts: {
        body: { type: 'any' },
        id: { type: 'any' },
        item_id: { type: 'any' },
        item_type: { type: 'any' },
        reserved1: { type: 'any' },
        reserved2: { type: 'any' },
        reserved3: { type: 'any' },
        reserved4: { type: 'any' },
        reserved5: { type: 'any' },
        reserved6: { type: 'any' },
        title: { type: 'any' },
        user_updated_time: { type: 'any' },
        type_: { type: 'number' },
    },
    items_fts_segments: {
        block: { type: 'any' },
        blockid: { type: 'number' },
        type_: { type: 'number' },
    },
    items_fts_segdir: {
        end_block: { type: 'number' },
        idx: { type: 'number' },
        leaves_end_block: { type: 'number' },
        level: { type: 'number' },
        root: { type: 'any' },
        start_block: { type: 'number' },
        type_: { type: 'number' },
    },
    items_fts_docsize: {
        docid: { type: 'number' },
        size: { type: 'any' },
        type_: { type: 'number' },
    },
    items_fts_stat: {
        id: { type: 'number' },
        value: { type: 'any' },
        type_: { type: 'number' },
    },
    tags_with_note_count: {
        created_time: { type: 'number' },
        id: { type: 'string' },
        note_count: { type: 'any' },
        title: { type: 'string' },
        todo_completed_count: { type: 'any' },
        updated_time: { type: 'number' },
        type_: { type: 'number' },
    },
};
//# sourceMappingURL=types.js.map