"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const string_utils_1 = require("../../string-utils");
const Mustache = require("mustache");
const object_1 = require("@joplin/utils/object");
// eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
const valueToString = (value) => {
    if (value === undefined || value === null)
        return '';
    return value.toString();
};
exports.default = (columns, itemTemplate, itemValueTemplates, view) => {
    // `note.title` is special and has already been rendered to HTML at this point, so we need
    // to ensure the string is not going to be escaped.
    itemTemplate = itemTemplate.replace(/\{\{note.title\}\}/g, '{{{note.title}}}');
    if (!columns || !columns.length)
        return Mustache.render(itemTemplate, view);
    const cells = [];
    for (const column of columns) {
        const styleHtml = [];
        if (column.width) {
            styleHtml.push(`width: ${column.width}px`);
        }
        else {
            styleHtml.push('flex: 1');
        }
        cells.push({
            name: column.name,
            styleHtml: styleHtml.join('; '),
            value: (0, object_1.objectValueFromPath)(view, column.name) || '',
            contentHtml: function () {
                const name = this.name;
                if (itemValueTemplates[name]) {
                    return Mustache.render(itemValueTemplates[name], view);
                }
                return ['note.titleHtml', 'note.title'].includes(name) ? this.value : (0, string_utils_1.escapeHtml)(valueToString(this.value));
            },
        });
    }
    const finalView = Object.assign({ cells }, view);
    return Mustache.render(itemTemplate, finalView);
};
//# sourceMappingURL=renderTemplate.js.map