"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const Logger_1 = require("@joplin/utils/Logger");
const time_1 = require("../../time");
const time_2 = require("@joplin/utils/time");
const logger = Logger_1.default.create('renderViewProps');
// eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
const renderViewProp = (name, value, options) => {
    const renderers = {
        'note.user_updated_time': () => (0, time_2.formatMsToRelative)(value),
        'note.user_created_time': () => (0, time_2.formatMsToRelative)(value),
        'note.updated_time': () => (0, time_2.formatMsToRelative)(value),
        'note.created_time': () => (0, time_2.formatMsToRelative)(value),
        'note.todo_completed': () => value ? time_1.default.formatMsToLocal(value) : '',
        'note.todo_due': () => value ? time_1.default.formatMsToLocal(value) : '',
        'note.tags': () => value ? value.map((t) => t.title).join(', ') : '',
        'note.title': () => options.noteTitleHtml,
    };
    try {
        const renderer = renderers[name];
        if (renderer)
            return renderer();
    }
    catch (error) {
        // If the input value doesn't have the expected format, it may have been changed by the
        // user. In that case we return the value without rendering it.
        logger.warn('Could not render property:', name, 'With value:', value, 'Error:', error);
        return value;
    }
    return value;
};
const renderViewProps = async (view, parentPath, options) => {
    for (const [name, value] of Object.entries(view)) {
        const currentPath = parentPath.concat([name]);
        if (value && typeof value === 'object' && !Array.isArray(value)) {
            await renderViewProps(value, currentPath, options);
        }
        else {
            view[name] = renderViewProp(currentPath.join('.'), value, options);
        }
    }
};
exports.default = renderViewProps;
//# sourceMappingURL=renderViewProps.js.map