"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const Setting_1 = require("../../../models/Setting");
const shim_1 = require("../../../shim");
const getDefaultPluginsInfo = () => {
    const defaultPlugins = {
        'io.github.jackgruber.backup': {
            settings: {
                'path': `${Setting_1.default.value('homeDir')}`,
                'createSubfolderPerProfile': true,
                'backupRetention': 7,
            },
            // Joplin Portable is more likely to run on a device with low write speeds
            // and memory. Because Simple Backup has auto-backup enabled by default,
            // we disable it in Joplin Portable.
            enabled: !shim_1.default.isPortable(),
        },
        'io.github.personalizedrefrigerator.js-draw': {},
    };
    return defaultPlugins;
};
exports.default = getDefaultPluginsInfo;
//# sourceMappingURL=desktopDefaultPluginsInfo.js.map