"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const BasePluginRunner_1 = require("../../../services/plugins/BasePluginRunner");
// TODO: Merge this with the plugin runner in app-cli, which, at the time of this writing,
// was used only for tests.
class MockPluginRunner extends BasePluginRunner_1.default {
    constructor() {
        super(...arguments);
        this.runningPluginIds = [];
        this.onRunningPluginsChangedListeners_ = [() => { }];
        this.stopCalledTimes_ = 0;
    }
    waitForAllToBeRunning(expectedIds) {
        return new Promise(resolve => {
            const listener = () => {
                let missingIds = false;
                for (const id of expectedIds) {
                    if (!this.runningPluginIds.includes(id)) {
                        missingIds = true;
                        console.warn('Missing ID', id, 'in', this.runningPluginIds);
                        break;
                    }
                }
                if (!missingIds) {
                    this.onRunningPluginsChangedListeners_ = this.onRunningPluginsChangedListeners_.filter(l => l !== listener);
                    resolve();
                }
            };
            this.onRunningPluginsChangedListeners_.push(listener);
            listener();
        });
    }
    get stopCalledTimes() { return this.stopCalledTimes_; }
    async run(plugin) {
        this.runningPluginIds.push(plugin.manifest.id);
        for (const listener of this.onRunningPluginsChangedListeners_) {
            listener();
        }
    }
    async stop(plugin) {
        this.runningPluginIds = this.runningPluginIds.filter(id => id !== plugin.manifest.id);
        this.stopCalledTimes_++;
    }
    async waitForSandboxCalls() { }
}
exports.default = MockPluginRunner;
//# sourceMappingURL=MockPluginRunner.js.map