"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const test_utils_1 = require("../../testing/test-utils");
const Folder_1 = require("../../models/Folder");
const Note_1 = require("../../models/Note");
const Tag_1 = require("../../models/Tag");
const MasterKey_1 = require("../../models/MasterKey");
const syncInfoUtils_1 = require("../synchronizer/syncInfoUtils");
describe('Synchronizer.tags', () => {
    beforeEach(async () => {
        await (0, test_utils_1.setupDatabaseAndSynchronizer)(1);
        await (0, test_utils_1.setupDatabaseAndSynchronizer)(2);
        await (0, test_utils_1.switchClient)(1);
    });
    async function shouldSyncTagTest(withEncryption) {
        let masterKey = null;
        if (withEncryption) {
            (0, syncInfoUtils_1.setEncryptionEnabled)(true);
            masterKey = await (0, test_utils_1.loadEncryptionMasterKey)();
        }
        await Folder_1.default.save({ title: 'folder' });
        const n1 = await Note_1.default.save({ title: 'mynote' });
        const n2 = await Note_1.default.save({ title: 'mynote2' });
        const tag = await Tag_1.default.save({ title: 'mytag' });
        await (0, test_utils_1.synchronizerStart)();
        await (0, test_utils_1.switchClient)(2);
        await (0, test_utils_1.synchronizerStart)();
        if (withEncryption) {
            const masterKey_2 = await MasterKey_1.default.load(masterKey.id);
            await (0, test_utils_1.encryptionService)().loadMasterKey(masterKey_2, '123456', true);
            const t = await Tag_1.default.load(tag.id);
            await Tag_1.default.decrypt(t);
        }
        const remoteTag = await Tag_1.default.loadByTitle(tag.title);
        expect(!!remoteTag).toBe(true);
        expect(remoteTag.id).toBe(tag.id);
        await Tag_1.default.addNote(remoteTag.id, n1.id);
        await Tag_1.default.addNote(remoteTag.id, n2.id);
        let noteIds = await Tag_1.default.noteIds(tag.id);
        expect(noteIds.length).toBe(2);
        await (0, test_utils_1.synchronizerStart)();
        await (0, test_utils_1.switchClient)(1);
        await (0, test_utils_1.synchronizerStart)();
        let remoteNoteIds = await Tag_1.default.noteIds(tag.id);
        expect(remoteNoteIds.length).toBe(2);
        await Tag_1.default.removeNote(tag.id, n1.id);
        remoteNoteIds = await Tag_1.default.noteIds(tag.id);
        expect(remoteNoteIds.length).toBe(1);
        await (0, test_utils_1.synchronizerStart)();
        await (0, test_utils_1.switchClient)(2);
        await (0, test_utils_1.synchronizerStart)();
        noteIds = await Tag_1.default.noteIds(tag.id);
        expect(noteIds.length).toBe(1);
        expect(remoteNoteIds[0]).toBe(noteIds[0]);
    }
    it('should sync tags', (async () => {
        await shouldSyncTagTest(false);
    }));
    it('should sync encrypted tags', (async () => {
        await shouldSyncTagTest(true);
    }));
});
//# sourceMappingURL=Synchronizer.tags.test.js.map