"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const _1 = require(".");
const BaseModel_1 = require("../../BaseModel");
const Folder_1 = require("../../models/Folder");
describe('services/trash', () => {
    test.each([
        [
            {
                deleted_time: 0,
                parent_id: '1',
                id: 'a',
            },
            {
                deleted_time: 0,
                id: '1',
            },
            '1',
        ],
        [
            {
                deleted_time: 1000,
                parent_id: '1',
                id: 'b',
            },
            {
                deleted_time: 0,
                id: '1',
            },
            (0, _1.getTrashFolderId)(),
        ],
        [
            {
                deleted_time: 1000,
                parent_id: '1',
                id: 'a',
            },
            {
                deleted_time: 1000,
                id: '1',
            },
            '1',
        ],
        // should show non-deleted conflicts in the conflicts folder
        [
            {
                deleted_time: 0,
                is_conflict: 1,
                parent_id: Folder_1.default.conflictFolderId(),
                id: 'b',
            },
            Folder_1.default.conflictFolder(),
            Folder_1.default.conflictFolderId(),
        ],
        // should show deleted conflicts in the trash folder
        [
            {
                deleted_time: 1000,
                is_conflict: 1,
                parent_id: Folder_1.default.conflictFolderId(),
                id: 'someidhere',
            },
            Folder_1.default.conflictFolder(),
            (0, _1.getTrashFolderId)(),
        ],
    ])('should return the display parent ID (case %#)', (item, itemParent, expected) => {
        const defaultProps = { type_: BaseModel_1.ModelType.Folder };
        const actual = (0, _1.getDisplayParentId)(Object.assign(Object.assign({}, defaultProps), item), Object.assign(Object.assign({}, defaultProps), itemParent));
        expect(actual).toBe(expected);
    });
});
//# sourceMappingURL=index.test.js.map