"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const { shimInit } = require('./shim-init-node');
const shim_1 = require("./shim");
const test_utils_1 = require("./testing/test-utils");
const fs_extra_1 = require("fs-extra");
describe('shim-init-node', () => {
    beforeEach(async () => {
        await (0, test_utils_1.setupDatabaseAndSynchronizer)(1);
        shimInit();
    });
    test('should set the correct mime for a PDF file even if the extension is missing', async () => {
        const filePath = `${test_utils_1.supportDir}/valid_pdf_without_ext`;
        const resource = await shim_1.default.createResourceFromPath(filePath);
        expect(resource.mime).toBe('application/pdf');
    });
    test('should preserve the file extension if one is provided regardless of the mime type', async () => {
        const tempDir = await (0, test_utils_1.createTempDir)();
        const originalFilePath = `${test_utils_1.supportDir}/valid_pdf_without_ext`;
        const fileWithDifferentExtension = `${tempDir}/valid_pdf.mscz`;
        await (0, fs_extra_1.copyFile)(originalFilePath, fileWithDifferentExtension);
        const resource = await shim_1.default.createResourceFromPath(fileWithDifferentExtension);
        expect(resource.file_extension).toBe('mscz');
    });
});
//# sourceMappingURL=shim-init-node.test.js.map