"use strict";
/**
 * @jest-environment jsdom
 */
Object.defineProperty(exports, "__esModule", { value: true });
const createEventHandlingAttrs_1 = require("./createEventHandlingAttrs");
const globals_1 = require("@jest/globals");
(0, globals_1.describe)('createEventHandlingAttrs', () => {
    let lastMessage = undefined;
    const postMessageFn = (message) => {
        lastMessage = message;
    };
    (0, globals_1.beforeAll)(() => {
        lastMessage = undefined;
        globals_1.jest.useFakeTimers();
    });
    (0, globals_1.it)('should not create listeners to handle long-press when long press is disabled', () => {
        const options = {
            enableLongPress: false,
            postMessageSyntax: 'postMessageFn',
            enableEditPopup: false,
        };
        const listeners = (0, createEventHandlingAttrs_1.createEventHandlingListeners)('someresourceid', options, 'postMessage("click")');
        // Should not add touchstart/mouseenter/leave listeners when not creating
        // an edit popup or long-pressing.
        (0, globals_1.expect)(listeners.onmouseenter).toBe('');
        (0, globals_1.expect)(listeners.onmouseleave).toBe('');
        (0, globals_1.expect)(listeners.ontouchstart).toBe('');
        (0, globals_1.expect)(listeners.ontouchmove).toBe('');
        (0, globals_1.expect)(listeners.ontouchend).toBe('');
        (0, globals_1.expect)(listeners.ontouchcancel).toBe('');
    });
    (0, globals_1.it)('should create click listener for given click action', () => {
        const options = {
            enableLongPress: false,
            postMessageSyntax: 'postMessageFn',
            enableEditPopup: false,
        };
        const clickAction = 'postMessageFn("click")';
        const listeners = (0, createEventHandlingAttrs_1.createEventHandlingListeners)('someresourceid', options, clickAction);
        (0, globals_1.expect)(listeners.onclick).toContain(clickAction);
        postMessageFn('test');
        eval(listeners.onclick);
        (0, globals_1.expect)(lastMessage).toBe('click');
    });
    (0, globals_1.it)('should create ontouch listeners for long press', () => {
        const options = {
            enableLongPress: true,
            postMessageSyntax: 'postMessageFn',
            enableEditPopup: false,
        };
        const clickAction = null;
        const listeners = (0, createEventHandlingAttrs_1.createEventHandlingListeners)('resourceidhere', options, clickAction);
        (0, globals_1.expect)(listeners.onclick).toBe('');
        (0, globals_1.expect)(listeners.ontouchstart).not.toBe('');
        // Clear lastMessage
        postMessageFn('test');
        eval(listeners.ontouchstart);
        globals_1.jest.advanceTimersByTime(1000 * 4);
        (0, globals_1.expect)(lastMessage).toBe('longclick:resourceidhere');
    });
    (0, globals_1.it)('motion during a long press should cancel the timeout', () => {
        const options = {
            enableLongPress: true,
            postMessageSyntax: 'postMessageFn',
            enableEditPopup: false,
        };
        const listeners = (0, createEventHandlingAttrs_1.createEventHandlingListeners)('id', options, null);
        lastMessage = '';
        eval(listeners.ontouchstart);
        globals_1.jest.advanceTimersByTime(100);
        eval(listeners.ontouchmove);
        globals_1.jest.advanceTimersByTime(1000 * 100);
        // Message handler should not have been called.
        (0, globals_1.expect)(lastMessage).toBe('');
    });
});
//# sourceMappingURL=createEventHandlingAttrs.test.js.map