"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const defaultRule_1 = require("./utils/defaultRule");
exports.default = {
    // Make table horizontally scrollable by give table a div parent, so the width of the table is limited to the screen width.
    // see https://github.com/laurent22/joplin/pull/10161
    plugin: (markdownIt) => {
        const defaultTableOpen = (0, defaultRule_1.default)(markdownIt, 'table_open');
        markdownIt.renderer.rules.table_open = function (tokens, idx, options, env, renderer) {
            const current = defaultTableOpen(tokens, idx, options, env, renderer);
            // joplin-table-wrapper css is set in packages/renderer/noteStyle.ts
            return `<div class="joplin-table-wrapper">\n${current}`;
        };
        const defaultTableClose = (0, defaultRule_1.default)(markdownIt, 'table_close');
        markdownIt.renderer.rules.table_close = function (tokens, idx, options, env, renderer) {
            const current = defaultTableClose(tokens, idx, options, env, renderer);
            return `${current}</div>\n`;
        };
    },
};
//# sourceMappingURL=tableHorizontallyScrollable.js.map