"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setupApplication = exports.setupCommandForTesting = void 0;
const app_1 = require("../app");
const Folder_1 = require("@joplin/lib/models/Folder");
const setupCommand_1 = require("../setupCommand");
// eslint-disable-next-line @typescript-eslint/ban-types, @typescript-eslint/no-explicit-any -- Old code before rule was applied, Old code before rule was applied
const setupCommandForTesting = (CommandClass, stdout = null) => {
    const command = new CommandClass();
    (0, setupCommand_1.default)(command, stdout, null, null);
    return command;
};
exports.setupCommandForTesting = setupCommandForTesting;
const setupApplication = async () => {
    // We create a notebook and set it as default since most commands require
    // such notebook.
    await Folder_1.default.save({ title: 'default' });
    await (0, app_1.default)().refreshCurrentFolder();
    // Some tests also need access to the Redux store
    (0, app_1.default)().initRedux();
};
exports.setupApplication = setupApplication;
//# sourceMappingURL=testUtils.js.map