"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const Note_1 = require("@joplin/lib/models/Note");
const test_utils_1 = require("@joplin/lib/testing/test-utils");
const testUtils_1 = require("./utils/testUtils");
const Command = require('./command-done');
describe('command-done', () => {
    beforeEach(async () => {
        await (0, test_utils_1.setupDatabaseAndSynchronizer)(1);
        await (0, test_utils_1.switchClient)(1);
        await (0, testUtils_1.setupApplication)();
    });
    it('should make a note as "done"', async () => {
        const note = await Note_1.default.save({ title: 'hello', is_todo: 1, todo_completed: 0, parent_id: '' });
        const command = (0, testUtils_1.setupCommandForTesting)(Command);
        const now = Date.now();
        await command.action({ note: note.id });
        const checkNote = await Note_1.default.load(note.id);
        expect(checkNote.todo_completed).toBeGreaterThanOrEqual(now);
    });
});
//# sourceMappingURL=command-done.test.js.map