"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const base_command_1 = require("./base-command");
const app_1 = require("./app");
const locale_1 = require("@joplin/lib/locale");
const { cliUtils } = require('./cli-utils.js');
class Command extends base_command_1.default {
    usage() {
        return 'keymap';
    }
    description() {
        return (0, locale_1._)('Displays the configured keyboard shortcuts.');
    }
    compatibleUis() {
        return ['cli', 'gui'];
    }
    async action(_args) {
        const keymaps = await (0, app_1.default)().loadKeymaps();
        this.stdout((0, locale_1._)('Configured keyboard shortcuts:'));
        this.stdout('\n');
        const rows = [];
        const padding = '  ';
        rows.push([`${padding}${(0, locale_1._)('KEYS')}`, (0, locale_1._)('TYPE'), (0, locale_1._)('COMMAND')]);
        rows.push([`${padding}----`, '----', '-------']);
        for (const item of keymaps) {
            const formattedKeys = item.keys
                .map((k) => (k === ' ' ? `(${(0, locale_1._)('SPACE')})` : k))
                .join(', ');
            rows.push([padding + formattedKeys, item.type, item.command]);
        }
        cliUtils.printArray(this.stdout.bind(this), rows);
        if ((0, app_1.default)().gui() && !(0, app_1.default)().gui().isDummy()) {
            (0, app_1.default)().gui().showConsole();
            (0, app_1.default)().gui().maximizeConsole();
        }
    }
}
module.exports = Command;
//# sourceMappingURL=command-keymap.js.map