"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const base_command_1 = require("./base-command");
const app_1 = require("./app");
const locale_1 = require("@joplin/lib/locale");
const BaseModel_1 = require("@joplin/lib/BaseModel");
const database_1 = require("@joplin/lib/database");
const Note_1 = require("@joplin/lib/models/Note");
class Command extends base_command_1.default {
    usage() {
        return 'set <note> <name> [value]';
    }
    description() {
        const fields = Note_1.default.fields();
        const s = [];
        for (let i = 0; i < fields.length; i++) {
            const f = fields[i];
            if (f.name === 'id')
                continue;
            s.push(`${f.name} (${database_1.default.enumName('fieldType', f.type)})`);
        }
        return (0, locale_1._)('Sets the property <name> of the given <note> to the given [value]. Possible properties are:\n\n%s', s.join(', '));
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    async action(args) {
        const title = args['note'];
        const propName = args['name'];
        let propValue = args['value'];
        if (!propValue)
            propValue = '';
        const notes = await (0, app_1.default)().loadItems(BaseModel_1.default.TYPE_NOTE, title);
        if (!notes.length)
            throw new Error((0, locale_1._)('Cannot find "%s".', title));
        for (let i = 0; i < notes.length; i++) {
            this.encryptionCheck(notes[i]);
            const timestamp = Date.now();
            // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
            const newNote = {
                id: notes[i].id,
                type_: notes[i].type_,
                updated_time: timestamp,
            };
            newNote[propName] = propValue;
            if (!newNote.id)
                newNote.created_time = timestamp;
            await Note_1.default.save(newNote, {
                autoTimestamp: false, // No auto-timestamp because user may have provided them
            });
        }
    }
}
module.exports = Command;
//# sourceMappingURL=command-set.js.map