"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const base_command_1 = require("./base-command");
const { _ } = require('@joplin/lib/locale');
const versionInfo = require('@joplin/lib/versionInfo').default;
class Command extends base_command_1.default {
    usage() {
        return 'version';
    }
    description() {
        return _('Displays version information');
    }
    async action() {
        this.stdout(versionInfo(require('../package.json'), {}).message);
    }
}
module.exports = Command;
//# sourceMappingURL=command-version.js.map