"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.runtime = exports.declaration = void 0;
const HtmlToMd_1 = require("../HtmlToMd");
exports.declaration = {
    name: 'convertHtmlToMarkdown',
};
const runtime = () => {
    return {
        execute: async (_context, html) => {
            const htmlToMdParser = new HtmlToMd_1.default();
            const markdown = await htmlToMdParser.parse(`<div>${html}</div>`, {
                baseUrl: '',
                anchorNames: [],
                convertEmbeddedPdfsToLinks: true,
            });
            return markdown;
        },
    };
};
exports.runtime = runtime;
//# sourceMappingURL=convertHtmlToMarkdown.js.map