"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const SyncTargetRegistry_1 = require("../../../SyncTargetRegistry");
const shouldShowMissingPasswordWarning_1 = require("./shouldShowMissingPasswordWarning");
// Maps targets to whether each target requires a password.
// A subset of all sync targets.
const targetToRequiresPassword = {
    'nextcloud': true,
    'webdav': true,
    'amazon_s3': true,
    'joplinServer': true,
    'joplinCloud': false,
    'onedrive': false,
    'dropbox': false,
};
describe('shouldShowMissingPasswordWarning', () => {
    it('should return true when sync target requires a password and the password is missing', () => {
        for (const targetName in targetToRequiresPassword) {
            const targetId = SyncTargetRegistry_1.default.nameToId(targetName);
            const expected = targetToRequiresPassword[targetName];
            expect((0, shouldShowMissingPasswordWarning_1.default)(targetId, {})).toBe(expected);
            // Should also consider an empty string to be missing
            const settings = {
                [`sync.${targetId}.password`]: '',
            };
            expect((0, shouldShowMissingPasswordWarning_1.default)(targetId, settings)).toBe(expected);
        }
    });
    it('should return false when a password is present', () => {
        for (const targetName in targetToRequiresPassword) {
            const targetId = SyncTargetRegistry_1.default.nameToId(targetName);
            const settings = {
                [`sync.${targetId}.password`]: 'some nonempty',
            };
            expect((0, shouldShowMissingPasswordWarning_1.default)(targetId, settings)).toBe(false);
        }
    });
});
//# sourceMappingURL=shouldShowMissingPasswordWarning.test.js.map