"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderTags = exports.isTagSelected = exports.buildFolderTree = exports.renderFolders = exports.isFolderSelected = void 0;
const trash_1 = require("../../services/trash");
const getCollator_1 = require("../../models/utils/getCollator");
const isFolderSelected = (folder, context) => {
    return context.selectedFolderIds.includes(folder.id) && context.notesParentType === 'Folder';
};
exports.isFolderSelected = isFolderSelected;
function folderIsCollapsed(context, folderId) {
    if (!context.collapsedFolderIds || !context.collapsedFolderIds.length)
        return false;
    while (true) {
        const folder = context.folderTree.idToItem.get(folderId);
        const folderParentId = (0, trash_1.getDisplayParentId)(folder, context.folderTree.idToItem.get(folder.parent_id));
        if (!folderParentId)
            return false;
        if (context.collapsedFolderIds.includes(folderParentId))
            return true;
        folderId = folderParentId;
    }
}
function renderFoldersRecursive_(props, renderItem, items, parentId, depth, order) {
    var _a;
    const folders = (_a = props.folderTree.parentIdToChildren.get(parentId !== null && parentId !== void 0 ? parentId : '')) !== null && _a !== void 0 ? _a : [];
    const parentIdToChildren = props.folderTree.parentIdToChildren;
    for (const folder of folders) {
        if (folderIsCollapsed(props, folder.id))
            continue;
        const hasChildren = parentIdToChildren.has(folder.id);
        order.push(folder.id);
        items.push(renderItem(folder, hasChildren, depth));
        if (hasChildren) {
            const result = renderFoldersRecursive_(props, renderItem, items, folder.id, depth + 1, order);
            items = result.items;
            order = result.order;
        }
    }
    return {
        items: items,
        order: order,
    };
}
const renderFolders = (props, renderItem) => {
    return renderFoldersRecursive_(props, renderItem, [], '', 0, []);
};
exports.renderFolders = renderFolders;
const buildFolderTree = (folders) => {
    var _a;
    const idToItem = new Map();
    for (const folder of folders) {
        idToItem.set(folder.id, folder);
    }
    const parentIdToChildren = new Map();
    for (const folder of folders) {
        const displayParentId = (_a = (0, trash_1.getDisplayParentId)(folder, idToItem.get(folder.parent_id))) !== null && _a !== void 0 ? _a : '';
        if (!parentIdToChildren.has(displayParentId)) {
            parentIdToChildren.set(displayParentId, []);
        }
        parentIdToChildren.get(displayParentId).push(folder);
    }
    return { folders, parentIdToChildren, idToItem };
};
exports.buildFolderTree = buildFolderTree;
const sortTags = (tags) => {
    tags = tags.slice();
    const collator = (0, getCollator_1.getCollator)();
    tags.sort((a, b) => {
        // It seems title can sometimes be undefined (perhaps when syncing
        // and before tag has been decrypted?). It would be best to find
        // the root cause but for now that will do.
        //
        // Fixes https://github.com/laurent22/joplin/issues/4051
        if (!a || !a.title || !b || !b.title)
            return 0;
        // Note: while newly created tags are normalized and lowercase
        // imported tags might be any case, so we need to do case-insensitive
        // sort.
        return collator.compare(a.title, b.title);
    });
    return tags;
};
const isTagSelected = (tag, context) => {
    return context.selectedTagIds.includes(tag.id) && context.notesParentType === 'Tag';
};
exports.isTagSelected = isTagSelected;
const renderTags = (unsortedTags, renderItem) => {
    const tags = sortTags(unsortedTags);
    const tagItems = [];
    const order = [];
    for (let i = 0; i < tags.length; i++) {
        const tag = tags[i];
        order.push(tag.id);
        tagItems.push(renderItem(tag));
    }
    return {
        items: tagItems,
        order: order,
    };
};
exports.renderTags = renderTags;
//# sourceMappingURL=side-menu-shared.js.map