"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const path_1 = require("path");
const fs_driver_node_1 = require("./fs-driver-node");
const shim_1 = require("./shim");
const test_utils_1 = require("./testing/test-utils");
const windowsPartitionLetter = __filename[0];
// On Windows, path.resolve is going to convert a path such as
// /tmp/file.txt to {partition}:\tmp\file.txt
function platformPath(path) {
    if (shim_1.default.isWindows()) {
        return `${windowsPartitionLetter}:${path.replace(/\//g, '\\')}`;
    }
    else {
        return path;
    }
}
describe('fsDriver', () => {
    it('should resolveRelativePathWithinDir', async () => {
        const fsDriver = new fs_driver_node_1.default();
        expect(fsDriver.resolveRelativePathWithinDir('/test/temp', './my/file.txt').toLowerCase()).toBe(platformPath('/test/temp/my/file.txt'));
        expect(fsDriver.resolveRelativePathWithinDir('/', './test').toLowerCase()).toBe(platformPath('/test'));
        expect(fsDriver.resolveRelativePathWithinDir('/test', 'myfile.txt').toLowerCase()).toBe(platformPath('/test/myfile.txt'));
        expect(fsDriver.resolveRelativePathWithinDir('/test/temp', './mydir/../test.txt').toLowerCase()).toBe(platformPath('/test/temp/test.txt'));
        await (0, test_utils_1.expectThrow)(() => fsDriver.resolveRelativePathWithinDir('/test/temp', '../myfile.txt'));
        await (0, test_utils_1.expectThrow)(() => fsDriver.resolveRelativePathWithinDir('/test/temp', './mydir/../../test.txt'));
        await (0, test_utils_1.expectThrow)(() => fsDriver.resolveRelativePathWithinDir('/test/temp', '/var/local/no.txt'));
    });
    it('should compare reserved names in a case-insensitive way in findUniqueFilename', async () => {
        // Compare with filenames in the reserved list should be case insensitive
        expect(await shim_1.default.fsDriver().findUniqueFilename((0, path_1.join)(test_utils_1.supportDir, 'this-file-does-not-exist.txt'), [(0, path_1.join)(test_utils_1.supportDir, 'THIS-file-does-not-exist.txt'), (0, path_1.join)(test_utils_1.supportDir, 'THIS-file-DOES-not-exist (1).txt')])).toBe((0, path_1.join)(test_utils_1.supportDir, 'this-file-does-not-exist (2).txt'));
        // Should still not match reserved names that aren't equivalent.
        expect(await shim_1.default.fsDriver().findUniqueFilename((0, path_1.join)(test_utils_1.supportDir, 'this-file-does-not-exist.txt'), [(0, path_1.join)(test_utils_1.supportDir, 'some-other-file.txt')])).toBe((0, path_1.join)(test_utils_1.supportDir, 'this-file-does-not-exist.txt'));
    });
});
//# sourceMappingURL=fsDriver.test.js.map