"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shim_1 = require("../shim");
const { useCallback, useEffect, useState } = shim_1.default.react();
const useEventListener_1 = require("./useEventListener");
// eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
function useElementSize(elementRef) {
    const [size, setSize] = useState({
        width: 0,
        height: 0,
    });
    // Prevent too many rendering using useCallback
    const updateSize = useCallback(() => {
        const node = elementRef === null || elementRef === void 0 ? void 0 : elementRef.current;
        if (node) {
            setSize({
                width: node.offsetWidth || 0,
                height: node.offsetHeight || 0,
            });
        }
    }, [elementRef]);
    // Initial size on mount
    useEffect(() => {
        updateSize();
        // eslint-disable-next-line @seiyab/react-hooks/exhaustive-deps -- Old code before rule was applied
    }, []);
    (0, useEventListener_1.default)('resize', updateSize);
    return size;
}
exports.default = useElementSize;
//# sourceMappingURL=useElementSize.js.map