"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shim_1 = require("../shim");
const { useRef, useMemo, useEffect } = shim_1.default.react();
// Like useEffect, but runs as soon as possible.
const useNowEffect = (effect, dependencies) => {
    const lastCleanup = useRef(null);
    const cleanupCallback = useMemo(() => {
        var _a, _b;
        (_a = lastCleanup.current) === null || _a === void 0 ? void 0 : _a.call(lastCleanup);
        lastCleanup.current = null;
        return (_b = effect()) !== null && _b !== void 0 ? _b : null;
        // eslint-disable-next-line @seiyab/react-hooks/exhaustive-deps -- This is a custom hook
    }, dependencies);
    lastCleanup.current = cleanupCallback;
    useEffect(() => {
        return () => {
            var _a;
            (_a = lastCleanup.current) === null || _a === void 0 ? void 0 : _a.call(lastCleanup);
            lastCleanup.current = null;
        };
    }, []);
};
exports.default = useNowEffect;
//# sourceMappingURL=useNowEffect.js.map