"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shim_1 = require("../shim");
const { useRef, useEffect } = shim_1.default.react();
const usePrevious = (value, initialValue = null) => {
    const ref = useRef(initialValue);
    useEffect(() => {
        ref.current = value;
    });
    return ref.current;
};
exports.default = usePrevious;
//# sourceMappingURL=usePrevious.js.map