"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const SyncTargetRegistry_1 = require("../../SyncTargetRegistry");
const test_utils_1 = require("../../testing/test-utils");
const BaseItem_1 = require("../BaseItem");
const Folder_1 = require("../Folder");
const Setting_1 = require("../Setting");
const settingValidations_1 = require("./settingValidations");
describe('settingValidations', () => {
    beforeEach(async () => {
        await (0, test_utils_1.setupDatabaseAndSynchronizer)(1);
        await (0, test_utils_1.switchClient)(1);
    });
    test('sync disabled items should prevent switching sync targets unless ignored', async () => {
        const folder = await Folder_1.default.save({ title: 'Test' });
        const noteCount = 5;
        const testNotes = await (0, test_utils_1.createNTestNotes)(noteCount, folder);
        const syncTargetId = SyncTargetRegistry_1.default.nameToId('memory');
        Setting_1.default.setValue('sync.target', syncTargetId);
        for (const testNote of testNotes) {
            await BaseItem_1.default.saveSyncDisabled(syncTargetId, testNote, 'Disabled reason');
        }
        const newSyncTargetId = SyncTargetRegistry_1.default.nameToId('dropbox');
        // Validation should fail with some error message.
        expect(await (0, settingValidations_1.default)(['sync.target'], { 'sync.target': newSyncTargetId })).not.toBe('');
        // Should pass after dismissing all warnings
        for (const testNote of testNotes) {
            await BaseItem_1.default.ignoreItemSyncWarning(syncTargetId, testNote);
        }
        expect(await (0, settingValidations_1.default)(['sync.target'], { 'sync.target': newSyncTargetId })).toBe('');
    });
});
//# sourceMappingURL=settingValidations.test.js.map