"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const trash_1 = require("../../services/trash");
const Folder_1 = require("../Folder");
exports.default = (folders) => {
    const tree = Folder_1.default.buildTree(folders);
    const canBeCollapsedIds = [];
    const processTree = (folders) => {
        for (const folder of folders) {
            if (folder.children.length) {
                canBeCollapsedIds.push(folder.id);
                processTree(folder.children);
            }
        }
    };
    processTree(tree);
    // Logic to determine whether trash should be included in canBeCollapsedIds
    // Loops over all folders recursively in case in the future a deleted folder remains child of a not deleted folder (and hence there is no deleted folder in 'tree').
    const isTrashCollapsable = (folders) => {
        for (const folder of folders) {
            if (folder.deleted_time) {
                canBeCollapsedIds.push((0, trash_1.getTrashFolderId)());
                return;
            }
            if (folder.children.length) {
                isTrashCollapsable(folder.children);
            }
        }
    };
    // Future proofing: if TrashFolder is already in canBeCollapsedIds do not add it again.
    if (!((0, trash_1.getTrashFolderId)() in canBeCollapsedIds)) {
        isTrashCollapsable(tree);
    }
    return canBeCollapsedIds;
};
//# sourceMappingURL=getCanBeCollapsedFolderIds.js.map