"use strict";
/* eslint-disable import/prefer-default-export */
Object.defineProperty(exports, "__esModule", { value: true });
exports.openFileWithExternalEditor = void 0;
const utils_1 = require("@joplin/utils");
const child_process_1 = require("child_process");
const Logger_1 = require("@joplin/utils/Logger");
const Setting_1 = require("../../models/Setting");
const path_utils_1 = require("../../path-utils");
const shim_1 = require("../../shim");
const logger = Logger_1.default.create('ExternalEditWatcher/utils');
// eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
const spawnCommand = async (path, args, options) => {
    return new Promise((resolve, reject) => {
        // App bundles need to be opened using the `open` command.
        // Additional args can be specified after --args, and the
        // -n flag is needed to ensure that the app is always launched
        // with the arguments. Without it, if the app is already opened,
        // it will just bring it to the foreground without opening the file.
        // So the full command is:
        //
        // open -n /path/to/editor.app --args -app-flag -bla /path/to/file.md
        //
        if (shim_1.default.isMac() && (0, path_utils_1.fileExtension)(path) === 'app') {
            args = args.slice();
            args.splice(0, 0, '--args');
            args.splice(0, 0, path);
            args.splice(0, 0, '-n');
            path = 'open';
        }
        // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
        const wrapError = (error) => {
            if (!error)
                return error;
            const msg = error.message ? [error.message] : [];
            msg.push(`Command was: "${path}" ${args.join(' ')}`);
            error.message = msg.join('\n\n');
            return error;
        };
        try {
            const subProcess = (0, child_process_1.spawn)(path, args, options);
            const iid = shim_1.default.setInterval(() => {
                if (subProcess && subProcess.pid) {
                    logger.debug(`Started editor with PID ${subProcess.pid}`);
                    shim_1.default.clearInterval(iid);
                    resolve(null);
                }
            }, 100);
            // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
            subProcess.on('error', (error) => {
                shim_1.default.clearInterval(iid);
                reject(wrapError(error));
            });
        }
        catch (error) {
            throw wrapError(error);
        }
    });
};
const textEditorCommand = () => {
    const editorCommand = Setting_1.default.value('editor');
    if (!editorCommand)
        return null;
    const s = (0, utils_1.splitCommandString)(editorCommand, { handleEscape: false });
    const path = s.splice(0, 1);
    if (!path.length)
        throw new Error(`Invalid editor command: ${editorCommand}`);
    return {
        path: path[0],
        args: s,
    };
};
// eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
const openFileWithExternalEditor = async (filePath, bridge) => {
    const cmd = textEditorCommand();
    if (!cmd) {
        bridge.openItem(filePath);
    }
    else {
        cmd.args.push(filePath);
        await spawnCommand(cmd.path, cmd.args, { detached: true });
    }
};
exports.openFileWithExternalEditor = openFileWithExternalEditor;
//# sourceMappingURL=utils.js.map