"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const BaseService_1 = require("./BaseService");
const Migration_1 = require("../models/Migration");
class MigrationService extends BaseService_1.default {
    static instance() {
        if (this.instance_)
            return this.instance_;
        this.instance_ = new MigrationService();
        return this.instance_;
    }
    async runScript(num) {
        const script = Migration_1.default.script(num);
        await script.exec();
    }
    async run() {
        const migrations = await Migration_1.default.migrationsToDo();
        for (const migration of migrations) {
            this.logger().info(`Running migration: ${migration.number}`);
            try {
                await this.runScript(migration.number);
                await Migration_1.default.delete(migration.id, { sourceDescription: 'MigrationService' });
            }
            catch (error) {
                this.logger().error(`Cannot run migration: ${migration.number}`, error);
                break;
            }
        }
    }
}
exports.default = MigrationService;
//# sourceMappingURL=MigrationService.js.map