"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const getPluginIssueReportUrl_1 = require("./getPluginIssueReportUrl");
describe('getPluginIssueReportUrl', () => {
    test.each([
        [{ repository_url: 'http://github.com/laurent22/joplin' }, 'https://github.com/laurent22/joplin/issues'],
        [{ repository_url: 'https://www.github.com/laurent22/joplin' }, 'https://github.com/laurent22/joplin/issues'],
        [{ repository_url: 'https://www.github.com/laurent22/joplin.git' }, 'https://github.com/laurent22/joplin/issues'],
        [{ homepage_url: 'https://www.github.com/laurent22/joplin' }, 'https://github.com/laurent22/joplin/issues'],
        [{ homepage_url: 'https://gitlab.com/laurent22/joplin' }, 'https://gitlab.com/laurent22/joplin/-/issues'],
        [{ homepage_url: 'https://www.gitlab.com/laurent22/joplin' }, 'https://gitlab.com/laurent22/joplin/-/issues'],
        [{ homepage_url: 'https://example.com/laurent22/joplin' }, null],
    ])('should return the issue URL (case %#)', async (manifest, expectedUrl) => {
        expect((0, getPluginIssueReportUrl_1.default)(manifest)).toBe(expectedUrl);
    });
});
//# sourceMappingURL=getPluginIssueReportUrl.test.js.map