"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const test_utils_js_1 = require("../../testing/test-utils.js");
const SearchEngine_js_1 = require("./SearchEngine.js");
const SearchEngineUtils_js_1 = require("./SearchEngineUtils.js");
const Setting_js_1 = require("../../models/Setting.js");
const Note = require('../../models/Note').default;
// eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
let searchEngine = null;
describe('SearchEngineUtils', () => {
    beforeEach(async () => {
        await (0, test_utils_js_1.setupDatabaseAndSynchronizer)(1);
        await (0, test_utils_js_1.switchClient)(1);
        searchEngine = new SearchEngine_js_1.default();
        searchEngine.setDb((0, test_utils_js_1.db)());
    });
    describe('filter todos based on showCompletedTodos', () => {
        it('show completed', (async () => {
            const note1 = await Note.save({ title: 'abcd', body: 'body 1' });
            const todo1 = await Note.save({ title: 'abcd', body: 'todo 1', is_todo: 1 });
            const todo2 = await Note.save({ title: 'abcd', body: 'todo 2', is_todo: 1, todo_completed: 1590085027710 });
            await Note.save({ title: 'qwer', body: 'body 2' });
            await searchEngine.syncTables();
            Setting_js_1.default.setValue('showCompletedTodos', true);
            const rows = (await SearchEngineUtils_js_1.default.notesForQuery('abcd', true, null, searchEngine)).notes;
            expect(rows.length).toBe(3);
            expect(rows.map(r => r.id)).toContain(note1.id);
            expect(rows.map(r => r.id)).toContain(todo1.id);
            expect(rows.map(r => r.id)).toContain(todo2.id);
            // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
            const options = {};
            options.fields = ['id', 'title'];
            const rows2 = (await SearchEngineUtils_js_1.default.notesForQuery('abcd', true, options, searchEngine)).notes;
            expect(rows2.length).toBe(3);
            expect(rows2.map(r => r.id)).toContain(note1.id);
            expect(rows2.map(r => r.id)).toContain(todo1.id);
            expect(rows2.map(r => r.id)).toContain(todo2.id);
        }));
        it('hide completed', (async () => {
            const note1 = await Note.save({ title: 'abcd', body: 'body 1' });
            const todo1 = await Note.save({ title: 'abcd', body: 'todo 1', is_todo: 1 });
            await Note.save({ title: 'qwer', body: 'body 2' });
            await Note.save({ title: 'abcd', body: 'todo 2', is_todo: 1, todo_completed: 1590085027710 });
            await searchEngine.syncTables();
            Setting_js_1.default.setValue('showCompletedTodos', false);
            const rows = (await SearchEngineUtils_js_1.default.notesForQuery('abcd', true, null, searchEngine)).notes;
            expect(rows.length).toBe(2);
            expect(rows.map(r => r.id)).toContain(note1.id);
            expect(rows.map(r => r.id)).toContain(todo1.id);
            // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
            const options = {};
            options.fields = ['id', 'title'];
            const rows2 = (await SearchEngineUtils_js_1.default.notesForQuery('abcd', true, options, searchEngine)).notes;
            expect(rows2.length).toBe(2);
            expect(rows2.map(r => r.id)).toContain(note1.id);
            expect(rows2.map(r => r.id)).toContain(todo1.id);
        }));
        it('show completed (!applyUserSettings)', (async () => {
            const note1 = await Note.save({ title: 'abcd', body: 'body 1' });
            const todo1 = await Note.save({ title: 'abcd', body: 'todo 1', is_todo: 1 });
            await Note.save({ title: 'qwer', body: 'body 2' });
            const todo2 = await Note.save({ title: 'abcd', body: 'todo 2', is_todo: 1, todo_completed: 1590085027710 });
            await searchEngine.syncTables();
            Setting_js_1.default.setValue('showCompletedTodos', false);
            const rows = (await SearchEngineUtils_js_1.default.notesForQuery('abcd', false, null, searchEngine)).notes;
            expect(rows.length).toBe(3);
            expect(rows.map(r => r.id)).toContain(note1.id);
            expect(rows.map(r => r.id)).toContain(todo1.id);
            expect(rows.map(r => r.id)).toContain(todo2.id);
        }));
    });
    it('remove auto added fields', (async () => {
        await Note.save({ title: 'abcd', body: 'body 1' });
        await searchEngine.syncTables();
        const testCases = [
            ['title', 'todo_due'],
            ['title', 'todo_completed'],
            ['title'],
            ['title', 'todo_completed', 'todo_due'],
        ];
        for (const testCase of testCases) {
            const rows = (await SearchEngineUtils_js_1.default.notesForQuery('abcd', false, { fields: [...testCase] }, searchEngine)).notes;
            testCase.push('type_');
            expect(Object.keys(rows[0]).length).toBe(testCase.length);
            for (const field of testCase) {
                expect(rows[0]).toHaveProperty(field);
            }
        }
    }));
});
//# sourceMappingURL=SearchEngineUtils.test.js.map