"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = default_1;
const Setting_1 = require("../../../models/Setting");
const tools_1 = require("../tools");
const registry_1 = require("../../../registry");
const Logger_1 = require("@joplin/utils/Logger");
const logger = Logger_1.default.create('handleSyncStartupOperation');
async function default_1() {
    logger.info('Processing operation:', Setting_1.default.value('sync.startupOperation'));
    if (Setting_1.default.value('sync.startupOperation') === Setting_1.SyncStartupOperation.ClearLocalSyncState) {
        await (0, tools_1.clearLocalSyncStateForReupload)(registry_1.reg.db());
        Setting_1.default.setValue('sync.startupOperation', Setting_1.SyncStartupOperation.None);
    }
    else if (Setting_1.default.value('sync.startupOperation') === Setting_1.SyncStartupOperation.ClearLocalData) {
        await (0, tools_1.clearLocalDataForRedownload)(registry_1.reg.db());
        Setting_1.default.setValue('sync.startupOperation', Setting_1.SyncStartupOperation.None);
    }
    else if (Setting_1.default.value('sync.startupOperation') === Setting_1.SyncStartupOperation.None) {
        // Nothing
    }
    else {
        throw new Error(`Invalid sync.startupOperation value: ${Setting_1.default.value('sync.startupOperation')}`);
    }
}
//# sourceMappingURL=handleSyncStartupOperation.js.map