"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const BaseItem_1 = require("../../models/BaseItem");
const Folder_1 = require("../../models/Folder");
const Note_1 = require("../../models/Note");
exports.default = async () => {
    const result = await BaseItem_1.default.allItemsInTrash();
    await Note_1.default.batchDelete(result.noteIds, { sourceDescription: 'emptyTrash/notes' });
    for (const folderId of result.folderIds) {
        await Folder_1.default.delete(folderId, { deleteChildren: false, sourceDescription: 'emptyTrash/folders' });
    }
};
//# sourceMappingURL=emptyTrash.js.map