"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const MdToHtml_1 = require("./MdToHtml");
const HtmlToHtml_1 = require("./HtmlToHtml");
const htmlUtils_1 = require("./htmlUtils");
const html_entities_1 = require("html-entities");
const types_1 = require("./types");
const defaultResourceModel_1 = require("./defaultResourceModel");
const MarkdownIt = require('markdown-it');
class MarkupToHtml {
    constructor(options = null) {
        this.renderers_ = {};
        this.options_ = Object.assign({ ResourceModel: defaultResourceModel_1.default, isSafeMode: false }, options);
    }
    renderer(markupLanguage) {
        if (this.renderers_[markupLanguage])
            return this.renderers_[markupLanguage];
        let RendererClass = null;
        if (markupLanguage === MarkupToHtml.MARKUP_LANGUAGE_MARKDOWN) {
            RendererClass = MdToHtml_1.default;
        }
        else if (markupLanguage === MarkupToHtml.MARKUP_LANGUAGE_HTML) {
            RendererClass = HtmlToHtml_1.default;
        }
        else {
            throw new Error(`Invalid markup language: ${markupLanguage}`);
        }
        // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
        this.renderers_[markupLanguage] = new RendererClass(this.options_);
        return this.renderers_[markupLanguage];
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    stripMarkup(markupLanguage, markup, options = null) {
        if (!markup)
            return '';
        options = Object.assign({ collapseWhiteSpaces: false }, options);
        let output = markup;
        if (markupLanguage === MarkupToHtml.MARKUP_LANGUAGE_MARKDOWN) {
            if (!this.rawMarkdownIt_) {
                // We enable HTML because we don't want it to be escaped, so
                // that it can be stripped off in the stripHtml call below.
                this.rawMarkdownIt_ = new MarkdownIt({ html: true });
            }
            output = this.rawMarkdownIt_.render(output);
        }
        output = htmlUtils_1.default.stripHtml(output).trim();
        if (options.collapseWhiteSpaces) {
            output = output.replace(/\n+/g, ' ');
            output = output.replace(/\s+/g, ' ');
        }
        return output;
    }
    clearCache(markupLanguage) {
        const r = this.renderer(markupLanguage);
        if (r.clearCache)
            r.clearCache();
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    async render(markupLanguage, markup, theme, options) {
        if (this.options_.isSafeMode) {
            const htmlentities = new html_entities_1.AllHtmlEntities();
            return {
                html: `<pre>${htmlentities.encode(markup)}</pre>`,
                cssStrings: [],
                pluginAssets: [],
            };
        }
        return this.renderer(markupLanguage).render(markup, theme, options);
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
    async allAssets(markupLanguage, theme, noteStyleOptions = null) {
        return this.renderer(markupLanguage).allAssets(theme, noteStyleOptions);
    }
}
MarkupToHtml.MARKUP_LANGUAGE_MARKDOWN = types_1.MarkupLanguage.Markdown;
MarkupToHtml.MARKUP_LANGUAGE_HTML = types_1.MarkupLanguage.Html;
exports.default = MarkupToHtml;
//# sourceMappingURL=MarkupToHtml.js.map