"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.waitForCliInput = exports.isTTY = void 0;
const readline = require('readline/promises');
/* eslint-disable no-console */
const isTTY = () => process.stdin.isTTY;
exports.isTTY = isTTY;
// eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
let readlineInterface = null;
const waitForCliInput = async () => {
    readlineInterface !== null && readlineInterface !== void 0 ? readlineInterface : (readlineInterface = readline.createInterface({
        input: process.stdin,
        output: process.stdout,
    }));
    if ((0, exports.isTTY)()) {
        const green = '\x1b[92m';
        const reset = '\x1b[0m';
        await readlineInterface.question(`${green}[Press enter to continue]${reset}`);
        console.log('Continuing...');
    }
    else {
        console.warn('Input is not from a TTY -- not waiting for input.');
    }
};
exports.waitForCliInput = waitForCliInput;
//# sourceMappingURL=cli.js.map