"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hasOwnProperty = exports.objectValueFromPath = void 0;
exports.checkObjectHasProperties = checkObjectHasProperties;
// eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
const objectValueFromPath = (o, path) => {
    const elements = path.split('.');
    let result = Object.assign({}, o);
    while (elements.length && result) {
        const e = elements.splice(0, 1)[0];
        result = result[e];
    }
    return result;
};
exports.objectValueFromPath = objectValueFromPath;
// eslint-disable-next-line @typescript-eslint/no-explicit-any -- Old code before rule was applied
function checkObjectHasProperties(object, properties) {
    for (const prop of properties) {
        if (!(prop in object))
            throw new Error(`Missing property "${prop}": ${JSON.stringify(object)}`);
    }
}
const hasOwnProperty = (object, property) => {
    return !!object && Object.prototype.hasOwnProperty.call(object, property);
};
exports.hasOwnProperty = hasOwnProperty;
//# sourceMappingURL=object.js.map