"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const object_1 = require("./object");
describe('object', () => {
    test.each([
        [
            {
                note: {
                    id: '123',
                    title: 'my note',
                },
            },
            'note.title',
            'my note',
        ],
        [
            {
                note: {
                    id: '123',
                    title: 'my note',
                },
            },
            'note.doesntexist',
            undefined,
        ],
    ])('should extract URLs', (object, path, expected) => {
        const actual = (0, object_1.objectValueFromPath)(object, path);
        expect(actual).toBe(expected);
    });
});
//# sourceMappingURL=object.test.js.map